!function(TcHmi){!function(Controls){!function(Helpers){class SchemaParser{static parse(schema){schema=this.resolveAllOf(this.resolveReferences(schema));const types=this.__findPossibleEditorTypes(schema),condensedTypes=[],convertedTypes=[],condense=type=>{let condensedType;return["boolean","number","string","time","enum","null"].includes(type.editorType)&&(condensedType=condensedTypes.find((condensed=>condensed.editorType===type.editorType&&condensed.id===type.schema.id&&condensed.title===type.schema.title))),condensedType?condensedType.condensedFrom.push(type):(condensedType={editorType:type.editorType,convertibles:[],condensedFrom:[type]},type.schema.id&&(condensedType.id=type.schema.id),type.schema.title&&(condensedType.title=type.schema.title),condensedTypes.push(condensedType)),condensedType};for(const type of types)type.convert?convertedTypes.push(type):condense(type);for(const type of convertedTypes){const existingTypes=condensedTypes.filter((condensed=>condensed.condensedFrom.some((condensedFrom=>condensedFrom.rawType===type.convert))));if(existingTypes.length>0)for(const existingType of existingTypes)existingType.convertibles.push(type);else{const condensedType=condense(type);condensedType.convertibles.push(...convertedTypes.filter((converted=>converted!==type&&condensedType.condensedFrom.some((condensedFrom=>condensedFrom.rawType===converted.convert)))))}}return 1===condensedTypes.length?this.__createEditorInfo(condensedTypes[0],schema):condensedTypes.length>1?this.__createChoiceEditorInfo(condensedTypes,schema):Helpers.ChoiceEditor.createAnyEditorInfo()}static resolveAllOf(schema){if(null!==(schema=tchmi_clone_object(schema))&&"object"==typeof schema){if(schema.allOf&&Array.isArray(schema.allOf))return schema.allOf.reduce(((combined,current)=>{for(const key in current)combined[key]=current[key];return combined}));if(Array.isArray(schema))for(let i=0,ii=schema.length;i<ii;i++)null!==schema[i]&&"object"==typeof schema[i]&&(schema[i]=this.resolveAllOf(schema[i]));else for(const key in schema)schema.hasOwnProperty(key)&&null!==schema[key]&&"object"==typeof schema[key]&&(schema[key]=this.resolveAllOf(schema[key]))}return schema}static resolveReferences(schema){schema=tchmi_clone_object(schema);const knownRefs=new Map,resolve=schema=>{if(null!==schema&&"object"==typeof schema){if("string"==typeof schema.$ref){let subSchema=knownRefs.get(schema.$ref);if(!subSchema){if(subSchema=tchmi_clone_object(TcHmi.Type.getSchema(schema.$ref)??void 0),!subSchema)throw new Error(TcHmi.Log.buildMessage({code:TcHmi.Errors.ERROR,message:TcHmi.Errors[TcHmi.Errors.ERROR],domain:"TcHmi.Controls.Helpers.SchemaParser",reason:`Unknown schema reference ${schema.$ref}.`}));knownRefs.set(schema.$ref,subSchema),knownRefs.set(schema.$ref,resolve(subSchema))}return subSchema}if(Array.isArray(schema))for(let i=0,ii=schema.length;i<ii;i++)null!==schema[i]&&"object"==typeof schema[i]&&(schema[i]=resolve(schema[i]));else for(const key in schema)schema.hasOwnProperty(key)&&null!==schema[key]&&"object"==typeof schema[key]&&(schema[key]=resolve(schema[key]))}return schema};return resolve(schema)}static __findPossibleEditorTypes(schema,strayRestrictions=new Map){let rawTypes=new Set;if(schema.type)"string"==typeof schema.type?rawTypes.add(schema.type):Array.isArray(schema.type)&&(rawTypes=new Set(schema.type));else if(schema.enum)for(const entry of schema.enum){const type=typeof entry;let rawType;switch(type){case"bigint":rawType="number";break;case"symbol":case"function":rawType="object";break;case"undefined":rawType="null";break;case"object":rawType=entry?"object":"null";break;default:rawType=type}rawTypes.add(rawType)}const subSchemas=[];schema.anyOf&&subSchemas.push(...schema.anyOf),schema.oneOf&&subSchemas.push(...schema.oneOf);const newStrayRestrictions=new Map;for(const[typename,keywords]of this.__restrictions)if(!rawTypes.has(typename))for(const keyword of keywords)if(keyword in schema){let restrictionMap=newStrayRestrictions.get(typename);restrictionMap||(restrictionMap=new Map,newStrayRestrictions.set(typename,restrictionMap)),restrictionMap.set(keyword,schema[keyword])}0===rawTypes.size&&0===subSchemas.length&&newStrayRestrictions.size>0&&(rawTypes=new Set(newStrayRestrictions.keys()),newStrayRestrictions.clear());for(const[typename,strayRestriction]of strayRestrictions)if(rawTypes.has(typename)){for(const[keyword,value]of strayRestriction)keyword in schema||(schema[keyword]=value);strayRestrictions.delete(typename)}for(const[typename,strayRestriction]of newStrayRestrictions){const existingStrayRestriction=strayRestrictions.get(typename);if(existingStrayRestriction)for(const[restriction,value]of strayRestriction)existingStrayRestriction.set(restriction,value);else strayRestrictions.set(typename,strayRestriction)}const types=[];for(const rawType of rawTypes){let editorType;if(schema.enum)editorType="enum";else if("date-time"===schema.format||"timespan"===schema.format)editorType="time";else switch(rawType){case"boolean":editorType="boolean";break;case"integer":case"number":editorType="number";break;case"string":editorType="string";break;case"object":editorType="object";break;case"array":editorType=Array.isArray(schema.items)?"tuple":"array";break;case"null":editorType="null";break;default:editorType="invalid"}types.push({editorType:editorType,rawType:rawType,schema:schema})}if(schema.convert)for(const type of types)type.rawType!==schema.convert&&(type.convert=schema.convert);for(const subSchema of subSchemas){const subTypes=this.__findPossibleEditorTypes(subSchema,strayRestrictions);types.push(...subTypes)}return types}static __generateName(type){if(type.title)return type.title;if(type.id){const result=/tchmi:([a-zA-Z]+)#\/definitions\/(.+)$/.exec(type.id);if(result)return result[2]}return type.editorType.charAt(0).toUpperCase()+type.editorType.slice(1)}static __createEditorInfo(type,schema){switch(type.editorType){case"boolean":return this.__createBooleanEditorInfo(type,schema);case"number":return this.__createNumberEditorInfo(type,schema);case"string":return this.__createStringEditorInfo(type,schema);case"time":return this.__createTimeEditorInfo(type,schema);case"enum":return this.__createEnumEditorInfo(type,schema);case"object":return this.__createObjectEditorInfo(type,schema);case"array":return this.__createArrayEditorInfo(type,schema);case"tuple":return this.__createTupleEditorInfo(type,schema);case"null":return this.__createNullEditorInfo(type,schema);default:return this.__createAnyEditorInfo(type,schema)}}static __createBooleanEditorInfo(type,schema){return{type:"boolean",schema:schema,name:this.__generateName(type)}}static __createNumberEditorInfo(type,schema){const restrictions=type.condensedFrom.map((type=>{const restriction={isInteger:"integer"===type.rawType};return void 0!==type.schema.multipleOf&&(restriction.multipleOf=type.schema.multipleOf),void 0!==type.schema.maximum&&(restriction.maximum={value:type.schema.maximum,exclusive:type.schema.exclusiveMaximum??!1}),void 0!==type.schema.minimum&&(restriction.minimum={value:type.schema.minimum,exclusive:type.schema.exclusiveMinimum??!1}),restriction})),info={type:"number",schema:schema,name:this.__generateName(type),restrictions:restrictions,specialValues:new Set};for(const convertible of type.convertibles)if(convertible.schema.enum)for(const item of convertible.schema.enum)info.specialValues.add(item);return info}static __createStringEditorInfo(type,schema){const restrictions=type.condensedFrom.map((type=>{const restriction={};return void 0!==type.schema.minLength&&(restriction.minLength=type.schema.minLength),void 0!==type.schema.maxLength&&(restriction.maxLength=type.schema.maxLength),type.schema.pattern&&(restriction.patterns=[new RegExp(type.schema.pattern)]),type.schema.format&&(restriction.format=type.schema.format),restriction}));return{type:"string",schema:schema,name:this.__generateName(type),restrictions:restrictions.filter((restriction=>Object.keys(restriction).length>0))}}static __createTimeEditorInfo(type,schema){const formats=new Set(type.condensedFrom.map((type=>type.schema.format)).filter((format=>"date-time"===format||"timespan"===format)));return{type:"time",schema:schema,name:this.__generateName(type),formats:formats}}static __createEnumEditorInfo(type,schema){const info={type:"enum",schema:schema,name:this.__generateName(type),members:new Map};for(const condensedFrom of type.condensedFrom)if(condensedFrom.schema.enum){for(const member of condensedFrom.schema.enum)info.members.set(member,void 0);if(condensedFrom.schema.options)for(const option of condensedFrom.schema.options)info.members.has(option.value)&&info.members.set(option.value,option.label)}return info}static __createObjectEditorInfo(type,schema){const info={type:"object",schema:schema,name:this.__generateName(type),properties:new Map,additionalProperties:{allowed:!0}},editorSchema=type.condensedFrom[0].schema;if(editorSchema.patternProperties){info.patternProperties=new Map;for(const key in editorSchema.patternProperties)info.patternProperties.set(new RegExp(key),this.parse(editorSchema.patternProperties[key]))}if(editorSchema.properties)for(const key in editorSchema.properties){let editorInfo=this.parse(editorSchema.properties[key]);if(info.patternProperties&&Array.from(info.patternProperties.keys()).some((regex=>regex.test(key)))){const matchingInfos=[];for(const[regex,patternInfo]of info.patternProperties)regex.test(key)&&matchingInfos.push(patternInfo);editorInfo=this.mergeEditorInfos(editorInfo,...matchingInfos)}editorSchema.required?.includes(key)||"optional"===editorInfo.type||(editorInfo={type:"optional",schema:editorInfo.schema,name:editorInfo.name,editorInfo:editorInfo,temporarilyRequired:!1}),info.properties.set(key,editorInfo)}if(void 0!==editorSchema.additionalProperties&&(info.additionalProperties.allowed=!1!==editorSchema.additionalProperties,info.additionalProperties.allowed&&(info.additionalProperties.editorInfo=this.parse("object"==typeof editorSchema.additionalProperties?editorSchema.additionalProperties:{}))),editorSchema.required)for(const requiredProperty of editorSchema.required.filter((item=>!info.properties.has(item))))info.properties.set(requiredProperty,Helpers.ObjectEditor.getEditorInfoForProperty(info,requiredProperty));if(void 0!==editorSchema.maxProperties&&(info.maxProperties=editorSchema.maxProperties),void 0!==editorSchema.minProperties&&(info.minProperties=editorSchema.minProperties),void 0!==editorSchema.dependencies){info.dependencies=new Map;for(const key in editorSchema.dependencies){const dependency=editorSchema.dependencies[key];if(Array.isArray(dependency)){const dependencyInfo={type:"object",schema:{},name:info.name,properties:new Map,additionalProperties:{allowed:!0}};for(const requiredProperty of dependency){const editorInfo=Helpers.ObjectEditor.getEditorInfoForProperty(info,requiredProperty);"optional"===editorInfo.type?dependencyInfo.properties.set(requiredProperty,editorInfo.editorInfo):info.properties.get(requiredProperty)!==editorInfo&&dependencyInfo.properties.set(requiredProperty,editorInfo)}info.dependencies.set(key,dependencyInfo)}else{const dependencyInfo=this.parse(dependency);"object"===dependencyInfo.type&&info.dependencies.set(key,dependencyInfo)}}}return info}static __createArrayEditorInfo(type,schema){const editorSchema=type.condensedFrom[0].schema,info={type:"array",schema:schema,name:this.__generateName(type),items:editorSchema.items&&!Array.isArray(editorSchema.items)?this.parse(editorSchema.items):Helpers.ChoiceEditor.createAnyEditorInfo(),uniqueItems:editorSchema.uniqueItems??!1};return void 0!==editorSchema.minItems&&(info.minItems=editorSchema.minItems),void 0!==editorSchema.maxItems&&(info.maxItems=editorSchema.maxItems),info}static __createTupleEditorInfo(type,schema){const editorSchema=type.condensedFrom[0].schema,info={type:"tuple",schema:schema,name:this.__generateName(type),items:[],additionalItems:{allowed:!0},uniqueItems:editorSchema.uniqueItems??!1};if(void 0!==editorSchema.minItems&&(info.minItems=editorSchema.minItems),void 0!==editorSchema.maxItems&&(info.maxItems=editorSchema.maxItems),Array.isArray(editorSchema.items)){const minItems=info.minItems??0;for(let i=0,ii=editorSchema.items.length;i<ii;i++){let editorInfo=this.parse(editorSchema.items[i]);i>=minItems&&(editorInfo={type:"optional",schema:editorInfo.schema,name:editorInfo.name,editorInfo:editorInfo,temporarilyRequired:!1}),info.items.push(editorInfo)}}return void 0!==editorSchema.additionalItems&&(info.additionalItems.allowed=!1!==editorSchema.additionalItems,info.additionalItems.allowed&&(info.additionalItems.editorInfo=this.parse("object"==typeof editorSchema.additionalItems?editorSchema.additionalItems:{}))),info}static __createChoiceEditorInfo(types,schema){const info={type:"choice",schema:schema,name:this.__generateName({editorType:"choice",id:schema.id,title:schema.title}),choices:[]};for(const type of types){const choice=this.__createEditorInfo(type,schema);if("choice"!==choice.type)info.choices.push(choice);else for(const subChoice of choice.choices??Helpers.ChoiceEditor.getAnyChoices())info.choices.push(subChoice)}return info}static __createNullEditorInfo(type,schema){return{type:"null",schema:schema,name:this.__generateName(type)}}static __createAnyEditorInfo(type,schema){const info=Helpers.ChoiceEditor.createAnyEditorInfo();return info.schema=schema,info.name=this.__generateName(type),info}static mergeEditorInfos(...toMerge){let result;const enumIndex=toMerge.findIndex((info=>"enum"===info.type));if(-1!==enumIndex)result=tchmi_clone_object(toMerge.splice(enumIndex,1)[0],SchemaParser.__cloneEditorInfoOptions);else{const nonAnyIndex=toMerge.findIndex((info=>"choice"!==info.type||void 0!==info.choices));result=-1!==nonAnyIndex?tchmi_clone_object(toMerge.splice(nonAnyIndex,1)[0],SchemaParser.__cloneEditorInfoOptions):tchmi_clone_object(toMerge.shift(),SchemaParser.__cloneEditorInfoOptions)}if(!result)return{type:"invalid",schema:{},name:"Invalid"};if(0===(toMerge=toMerge.filter((info=>"choice"!==info.type||void 0!==info.choices))).length)return result;switch(result.schema={allOf:[result.schema].concat(...toMerge.map((info=>info.schema)))},result.type){case"boolean":return this.__mergeBooleanEditorInfos(result,toMerge);case"number":return this.__mergeNumberEditorInfos(result,toMerge);case"string":return this.__mergeStringEditorInfos(result,toMerge);case"time":return this.__mergeTimeEditorInfos(result,toMerge);case"enum":return this.__mergeEnumEditorInfos(result,toMerge);case"object":return this.__mergeObjectEditorInfos(result,toMerge);case"array":return this.__mergeArrayEditorInfos(result,toMerge);case"tuple":return this.__mergeTupleEditorInfos(result,toMerge);case"choice":return this.__mergeChoiceEditorInfos(result,toMerge);case"optional":return this.__mergeOptionalEditorInfos(result,toMerge);case"null":return this.__mergeNullEditorInfos(result,toMerge);case"invalid":return result}}static __mergeBooleanEditorInfos(target,toMerge){return toMerge.every((info=>"boolean"===info.type||"optional"===info.type&&"boolean"===info.editorInfo.type||"choice"===info.type&&(!info.choices||info.choices.some((choice=>"boolean"===choice.type)))))?target:{type:"invalid",schema:target.schema,name:"Invalid"}}static __mergeNumberEditorInfos(target,toMerge){toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const numberChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"number"===choice.type));return 0===numberChoices.length?info:1===numberChoices.length?numberChoices[0]:(numberChoices[1]=tchmi_clone_object(numberChoices[1]),numberChoices.reduce(((result,current)=>{for(const specialValue of current.specialValues)result.specialValues.add(specialValue);return result.restrictions.push(...current.restrictions),result})))}return info}));for(const info of toMerge){if("number"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};if(target.specialValues=new Set([...target.specialValues].filter((value=>info.specialValues.has(value)))),info.restrictions.length>0)if(0===target.restrictions.length)target.restrictions=tchmi_clone_object(info.restrictions,SchemaParser.__cloneEditorInfoOptions);else{const restrictions=[];for(const targetRestriction of target.restrictions)for(const mergeRestriction of info.restrictions){const restriction={isInteger:targetRestriction.isInteger||mergeRestriction.isInteger};let isValid=!0;void 0!==targetRestriction.multipleOf&&void 0!==mergeRestriction.multipleOf?restriction.multipleOf=targetRestriction.multipleOf===mergeRestriction.multipleOf?targetRestriction.multipleOf:targetRestriction.multipleOf*mergeRestriction.multipleOf:void 0!==targetRestriction.multipleOf?restriction.multipleOf=targetRestriction.multipleOf:void 0!==mergeRestriction.multipleOf&&(restriction.multipleOf=mergeRestriction.multipleOf),targetRestriction.maximum&&mergeRestriction.maximum?targetRestriction.maximum.value<mergeRestriction.maximum.value?restriction.maximum=targetRestriction.maximum:mergeRestriction.maximum.value<targetRestriction.maximum.value?restriction.maximum=mergeRestriction.maximum:restriction.maximum={value:targetRestriction.maximum.value,exclusive:targetRestriction.maximum.exclusive||mergeRestriction.maximum.exclusive}:targetRestriction.maximum?restriction.maximum=targetRestriction.maximum:mergeRestriction.maximum&&(restriction.maximum=mergeRestriction.maximum),targetRestriction.minimum&&mergeRestriction.minimum?targetRestriction.minimum.value>mergeRestriction.minimum.value?restriction.minimum=targetRestriction.minimum:mergeRestriction.minimum.value>targetRestriction.minimum.value?restriction.minimum=mergeRestriction.minimum:restriction.minimum={value:targetRestriction.minimum.value,exclusive:targetRestriction.minimum.exclusive||mergeRestriction.minimum.exclusive}:targetRestriction.minimum?restriction.minimum=targetRestriction.minimum:mergeRestriction.minimum&&(restriction.minimum=mergeRestriction.minimum),restriction.maximum&&restriction.minimum&&(restriction.maximum.value<restriction.minimum.value||restriction.maximum.value===restriction.minimum.value&&(restriction.maximum.exclusive||restriction.minimum.exclusive))&&(isValid=!1),isValid&&!restrictions.some((r=>tchmi_equal(r,restriction,SchemaParser.__compareEditorInfoOptions)))&&restrictions.push(restriction)}if(!(restrictions.length>0))return{type:"invalid",schema:target.schema,name:"Invalid"};target.restrictions=restrictions}}return target}static __mergeStringEditorInfos(target,toMerge){toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const stringChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"string"===choice.type));return 0===stringChoices.length?info:1===stringChoices.length?stringChoices[0]:(stringChoices[1]=tchmi_clone_object(stringChoices[1]),stringChoices.reduce(((result,current)=>(result.restrictions.push(...current.restrictions),result))))}return info}));for(const info of toMerge){if("string"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};if(info.restrictions.length>0)if(0===target.restrictions.length)target.restrictions=tchmi_clone_object(info.restrictions,SchemaParser.__cloneEditorInfoOptions);else{const restrictions=[];for(const targetRestriction of target.restrictions)for(const mergeRestriction of info.restrictions){const restriction={};let isValid=!0;targetRestriction.patterns&&mergeRestriction.patterns?restriction.patterns=targetRestriction.patterns.concat(mergeRestriction.patterns):targetRestriction.patterns?restriction.patterns=tchmi_clone_object(targetRestriction.patterns,SchemaParser.__cloneEditorInfoOptions):mergeRestriction.patterns&&(restriction.patterns=tchmi_clone_object(mergeRestriction.patterns,SchemaParser.__cloneEditorInfoOptions)),targetRestriction.format&&mergeRestriction.format?targetRestriction.format===mergeRestriction.format?restriction.format=targetRestriction.format:isValid=!1:targetRestriction.format?restriction.format=targetRestriction.format:mergeRestriction.format&&(restriction.format=mergeRestriction.format),void 0!==targetRestriction.maxLength&&void 0!==mergeRestriction.maxLength?restriction.maxLength=Math.min(targetRestriction.maxLength,mergeRestriction.maxLength):void 0!==targetRestriction.maxLength?restriction.maxLength=targetRestriction.maxLength:void 0!==mergeRestriction.maxLength&&(restriction.maxLength=mergeRestriction.maxLength),void 0!==targetRestriction.minLength&&void 0!==mergeRestriction.minLength?restriction.minLength=Math.max(targetRestriction.minLength,mergeRestriction.minLength):void 0!==targetRestriction.minLength?restriction.minLength=targetRestriction.minLength:void 0!==mergeRestriction.minLength&&(restriction.minLength=mergeRestriction.minLength),void 0!==restriction.maxLength&&void 0!==restriction.minLength&&restriction.maxLength<restriction.minLength&&(isValid=!1),isValid&&!restrictions.some((r=>tchmi_equal(r,restriction,SchemaParser.__compareEditorInfoOptions)))&&restrictions.push(restriction)}if(!(restrictions.length>0))return{type:"invalid",schema:target.schema,name:"Invalid"};target.restrictions=restrictions}}return target}static __mergeTimeEditorInfos(target,toMerge){toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const timeChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"time"===choice.type));return 0===timeChoices.length?info:1===timeChoices.length?timeChoices[0]:(timeChoices[1]=tchmi_clone_object(timeChoices[1]),timeChoices.reduce(((result,current)=>{for(const format of current.formats)result.formats.add(format);return result})))}return info}));for(const info of toMerge){if("time"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};if(target.formats=new Set([...target.formats].filter((value=>info.formats.has(value)))),0===target.formats.size)return{type:"invalid",schema:target.schema,name:"Invalid"}}return target}static __mergeEnumEditorInfos(target,toMerge){toMerge=toMerge.map((info=>"optional"!==info.type?info:info.editorInfo));for(const info of toMerge){if("enum"===info.type)for(const member of target.members.keys())info.members.has(member)?target.members.set(member,info.members.get(member)):target.members.delete(member);else for(const member of target.members.keys())Helpers.Editor.validate(info,member)||target.members.delete(member);if(0===target.members.size)return{type:"invalid",schema:target.schema,name:"Invalid"}}return target}static __mergeObjectEditorInfos(target,toMerge){const reduceObjectEditors=(result,current)=>{if(result.additionalProperties.allowed=result.additionalProperties.allowed||current.additionalProperties.allowed,current.additionalProperties.editorInfo&&(result.additionalProperties.editorInfo?("choice"!==result.additionalProperties.editorInfo.type&&(result.additionalProperties.editorInfo={type:"choice",schema:{},name:"Choice",choices:[result.additionalProperties.editorInfo]}),"choice"===current.additionalProperties.editorInfo.type?current.additionalProperties.editorInfo.choices?result.additionalProperties.editorInfo.choices?.push(...current.additionalProperties.editorInfo.choices):delete result.additionalProperties.editorInfo.choices:result.additionalProperties.editorInfo.choices?.push(current.additionalProperties.editorInfo)):result.additionalProperties.editorInfo=current.additionalProperties.editorInfo),current.patternProperties){result.patternProperties||(result.patternProperties=new Map);for(const[regex,propertyInfo]of current.patternProperties){let resultKey=null,resultValue=propertyInfo;for(const[resultRegex,resultPropertyInfo]of result.patternProperties)if(regex.source===resultRegex.source){resultKey=resultRegex,resultValue="choice"!==resultPropertyInfo.type?{type:"choice",schema:{},name:"Choice",choices:[resultPropertyInfo]}:resultPropertyInfo,"choice"===propertyInfo.type?propertyInfo.choices?resultValue.choices?.push(...propertyInfo.choices):delete resultValue.choices:resultValue.choices?.push(propertyInfo);break}null===resultKey&&(resultKey=regex),result.patternProperties.set(resultKey,resultValue)}}const propertiesToMakeOptional=new Set(result.properties.keys());for(const[name,propertyInfo]of current.properties){let resultValue=result.properties.get(name);resultValue?(propertiesToMakeOptional.delete(name),"choice"!==resultValue.type&&(resultValue={type:"choice",schema:{},name:"Choice",choices:[resultValue]}),"choice"===propertyInfo.type?propertyInfo.choices?resultValue.choices?.push(...propertyInfo.choices):delete resultValue.choices:resultValue.choices?.push(propertyInfo)):(resultValue=propertyInfo,"optional"!==resultValue.type&&(resultValue={type:"optional",schema:{},name:resultValue.name,editorInfo:resultValue,temporarilyRequired:!1})),result.properties.set(name,resultValue)}for(const name of propertiesToMakeOptional){let resultValue=result.properties.get(name);resultValue&&("optional"!==resultValue.type&&(resultValue={type:"optional",schema:{},name:resultValue.name,editorInfo:resultValue,temporarilyRequired:!1},result.properties.set(name,resultValue)))}if(result.dependencies)if(current.dependencies){const dependenciesToDelete=new Set(result.dependencies.keys());for(const[name,dependency]of current.dependencies){let resultValue=result.dependencies.get(name);resultValue&&(dependenciesToDelete.delete(name),resultValue=reduceObjectEditors(resultValue,dependency),result.dependencies.set(name,resultValue))}for(const name of dependenciesToDelete)result.dependencies.delete(name)}else delete result.dependencies;return void 0!==result.minProperties&&(void 0===current.minProperties?delete result.minProperties:result.minProperties=Math.min(current.minProperties,result.minProperties)),void 0!==result.maxProperties&&(void 0===current.maxProperties?delete result.maxProperties:result.maxProperties=Math.max(current.maxProperties,result.maxProperties)),result};toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const objectChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"object"===choice.type));return 0===objectChoices.length?info:1===objectChoices.length?objectChoices[0]:(objectChoices[1]=tchmi_clone_object(objectChoices[1]),objectChoices.reduce(reduceObjectEditors))}return info}));for(const info of toMerge){if("object"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};if(!info.additionalProperties.allowed)for(const name of target.properties.keys())if(!(info.properties.has(name)||info.patternProperties&&Array.from(info.patternProperties.keys()).some((regex=>regex.test(name)))))return{type:"invalid",schema:target.schema,name:"Invalid"};if(info.patternProperties){target.patternProperties||(target.patternProperties=new Map);for(const[regex,mergePropertyInfo]of info.patternProperties){let foundTarget=!1;for(const[targetRegex,targetPropertyInfo]of target.patternProperties)if(targetRegex.source===regex.source){foundTarget=!0,target.patternProperties.set(targetRegex,this.mergeEditorInfos(targetPropertyInfo,mergePropertyInfo));break}foundTarget||target.patternProperties.set(regex,mergePropertyInfo);for(const[targetName,targetPropertyInfo]of target.properties)regex.test(targetName)&&target.properties.set(targetName,this.mergeEditorInfos(targetPropertyInfo,mergePropertyInfo))}}if(info.additionalProperties.editorInfo)for(const[name,targetPropertyInfo]of target.properties)info.properties.has(name)||info.patternProperties&&Array.from(info.patternProperties.keys()).some((regex=>regex.test(name)))||target.properties.set(name,this.mergeEditorInfos(targetPropertyInfo,info.additionalProperties.editorInfo));for(const[name,mergePropertyInfo]of info.properties){const targetPropertyInfo=Helpers.ObjectEditor.getEditorInfoForProperty(target,name);if("invalid"===targetPropertyInfo.type)return{type:"invalid",schema:target.schema,name:"Invalid"};target.properties.set(name,this.mergeEditorInfos(targetPropertyInfo,mergePropertyInfo))}if(target.additionalProperties.allowed=target.additionalProperties.allowed&&info.additionalProperties.allowed,target.additionalProperties.allowed?target.additionalProperties.editorInfo&&info.additionalProperties.editorInfo?target.additionalProperties.editorInfo=this.mergeEditorInfos(target.additionalProperties.editorInfo,info.additionalProperties.editorInfo):info.additionalProperties.editorInfo&&(target.additionalProperties.editorInfo=tchmi_clone_object(info.additionalProperties.editorInfo,SchemaParser.__cloneEditorInfoOptions)):target.additionalProperties.editorInfo&&delete target.additionalProperties.editorInfo,void 0!==info.maxProperties&&(void 0!==target.maxProperties?target.maxProperties=Math.min(target.maxProperties,info.maxProperties):target.maxProperties=info.maxProperties),void 0!==info.minProperties&&(void 0!==target.minProperties?target.minProperties=Math.max(target.minProperties,info.minProperties):target.minProperties=info.minProperties),info.dependencies)if(target.dependencies)for(const[name,mergeDependency]of info.dependencies){const targetDependency=target.dependencies.get(name);if(targetDependency){const dependency=this.mergeEditorInfos(targetDependency,mergeDependency);if("object"!==dependency.type)return{type:"invalid",schema:target.schema,name:"Invalid"};target.dependencies.set(name,dependency)}else target.dependencies.set(name,tchmi_clone_object(mergeDependency,SchemaParser.__cloneEditorInfoOptions))}else target.dependencies=tchmi_clone_object(info.dependencies,SchemaParser.__cloneEditorInfoOptions)}return void 0!==target.minProperties&&void 0!==target.maxProperties&&target.minProperties>target.maxProperties?{type:"invalid",schema:target.schema,name:"Invalid"}:target}static __mergeArrayEditorInfos(target,toMerge){toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const arrayChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"array"===choice.type));return 0===arrayChoices.length?info:1===arrayChoices.length?arrayChoices[0]:(arrayChoices[1]=tchmi_clone_object(arrayChoices[1]),arrayChoices.reduce(((result,current)=>("choice"!==result.items.type&&(result.items={type:"choice",schema:{},name:"Choice",choices:[result.items]}),"choice"===current.items.type?current.items.choices?result.items.choices?.push(...current.items.choices):delete result.items.choices:result.items.choices?.push(current.items),void 0!==result.minItems&&(void 0===current.minItems?delete result.minItems:result.minItems=Math.min(current.minItems,result.minItems)),void 0!==result.maxItems&&(void 0===current.maxItems?delete result.maxItems:result.maxItems=Math.max(current.maxItems,result.maxItems)),result.uniqueItems=result.uniqueItems&&current.uniqueItems,result))))}return info}));const itemInfos=[target.items];for(const info of toMerge){if("array"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};void 0!==info.minItems&&(void 0===target.minItems||target.minItems<info.minItems)&&(target.minItems=info.minItems),void 0!==info.maxItems&&(void 0===target.maxItems||target.maxItems>info.maxItems)&&(target.maxItems=info.maxItems),target.uniqueItems=target.uniqueItems||info.uniqueItems,itemInfos.push(info.items)}return void 0!==target.minItems&&void 0!==target.maxItems&&target.minItems>target.maxItems?{type:"invalid",schema:target.schema,name:"Invalid"}:(target.items=this.mergeEditorInfos(...itemInfos),"invalid"===target.items.type?{type:"invalid",schema:target.schema,name:"Invalid"}:target)}static __mergeTupleEditorInfos(target,toMerge){toMerge=toMerge.map((info=>{if("optional"===info.type)return info.editorInfo;if("choice"===info.type){const tupleChoices=(info.choices??Helpers.ChoiceEditor.getAnyChoices()).filter((choice=>"tuple"===choice.type));return 0===tupleChoices.length?info:1===tupleChoices.length?tupleChoices[0]:(tupleChoices[1]=tchmi_clone_object(tupleChoices[1]),tupleChoices.reduce(((result,current)=>{result.additionalItems.allowed=result.additionalItems.allowed||current.additionalItems.allowed,result.additionalItems.editorInfo&&(current.additionalItems.editorInfo?("choice"!==result.additionalItems.editorInfo.type&&(result.additionalItems.editorInfo={type:"choice",schema:{},name:"Choice",choices:[result.additionalItems.editorInfo]}),"choice"===current.additionalItems.editorInfo.type?current.additionalItems.editorInfo.choices?result.additionalItems.editorInfo.choices?.push(...current.additionalItems.editorInfo.choices):delete result.additionalItems.editorInfo.choices:result.additionalItems.editorInfo.choices?.push(current.additionalItems.editorInfo)):delete result.additionalItems.editorInfo);const itemsToMakeOptional=new Set(result.items.keys());for(const[index,itemInfo]of current.items.entries()){let resultValue=result.items[index];resultValue?(itemsToMakeOptional.delete(index),"choice"!==resultValue.type&&(resultValue={type:"choice",schema:{},name:"Choice",choices:[resultValue]}),"choice"===itemInfo.type?itemInfo.choices?resultValue.choices?.push(...itemInfo.choices):delete resultValue.choices:resultValue.choices?.push(itemInfo)):(resultValue=itemInfo,"optional"!==resultValue.type&&(resultValue={type:"optional",schema:{},name:resultValue.name,editorInfo:resultValue,temporarilyRequired:!1})),result.items[index]=resultValue}for(const index of itemsToMakeOptional){let resultValue=result.items[index];resultValue&&("optional"!==resultValue.type&&(resultValue={type:"optional",schema:{},name:resultValue.name,editorInfo:resultValue,temporarilyRequired:!1},result.items[index]=resultValue))}return void 0!==result.minItems&&(void 0===current.minItems?delete result.minItems:result.minItems=Math.min(current.minItems,result.minItems)),void 0!==result.maxItems&&(void 0===current.maxItems?delete result.maxItems:result.maxItems=Math.max(current.maxItems,result.maxItems)),result.uniqueItems=result.uniqueItems&&current.uniqueItems,result})))}return info}));for(const info of toMerge){if("tuple"!==info.type)return{type:"invalid",schema:target.schema,name:"Invalid"};let index=0;for(const length=target.items.length;index<length;index++){if(index<info.items.length)target.items[index]=this.mergeEditorInfos(target.items[index],info.items[index]);else{if(!info.additionalItems.allowed)return{type:"invalid",schema:target.schema,name:"Invalid"};info.additionalItems.editorInfo&&(target.items[index]=this.mergeEditorInfos(target.items[index],info.additionalItems.editorInfo))}if("invalid"===target.items[index].type)return{type:"invalid",schema:target.schema,name:"Invalid"}}for(const length=info.items.length;index<length;index++){if(!target.additionalItems.allowed)return{type:"invalid",schema:target.schema,name:"Invalid"};if(target.additionalItems.editorInfo){if(target.items[index]=this.mergeEditorInfos(target.additionalItems.editorInfo,info.items[index]),"invalid"===target.items[index].type)return{type:"invalid",schema:target.schema,name:"Invalid"}}else target.items[index]=tchmi_clone_object(info.items[index],this.__cloneEditorInfoOptions)}target.additionalItems.allowed=target.additionalItems.allowed&&info.additionalItems.allowed,target.additionalItems.allowed?target.additionalItems.editorInfo&&info.additionalItems.editorInfo?target.additionalItems.editorInfo=this.mergeEditorInfos(target.additionalItems.editorInfo,info.additionalItems.editorInfo):info.additionalItems.editorInfo&&(target.additionalItems.editorInfo=tchmi_clone_object(info.additionalItems.editorInfo,SchemaParser.__cloneEditorInfoOptions)):target.additionalItems.editorInfo&&delete target.additionalItems.editorInfo,void 0!==info.minItems&&(void 0===target.minItems||target.minItems<info.minItems)&&(target.minItems=info.minItems),void 0!==info.maxItems&&(void 0===target.maxItems||target.maxItems>info.maxItems)&&(target.maxItems=info.maxItems),target.uniqueItems=target.uniqueItems||info.uniqueItems}return void 0!==target.minItems&&void 0!==target.maxItems&&target.minItems>target.maxItems?{type:"invalid",schema:target.schema,name:"Invalid"}:target}static __mergeChoiceEditorInfos(target,toMerge){function boolToNum(value){return value?1:0}function findValidMerge(choice,candidates){const mergeOrder=Array.from(candidates).sort(((a,b)=>{const aVal=(boolToNum(a.name===choice.name)<<1)+boolToNum(a.type===choice.type);return(boolToNum(b.name===choice.name)<<1)+boolToNum(b.type===choice.type)-aVal}));for(const mergeChoice of mergeOrder){const mergeResult=SchemaParser.mergeEditorInfos(choice,mergeChoice);if("invalid"!==mergeResult.type&&"choice"!==mergeResult.type)return{validCandidate:mergeChoice,mergedInfo:mergeResult}}return null}toMerge=toMerge.map((info=>"optional"!==info.type?info:info.editorInfo));for(const info of toMerge){const mergeChoices=new Set("choice"===info.type?info.choices??Helpers.ChoiceEditor.getAnyChoices():[info]),missingChoices=new Set(mergeChoices),originalChoices=new Set(target.choices);target.choices||(target.choices=Helpers.ChoiceEditor.getAnyChoices());for(let i=0;i<target.choices.length;i++){const mergeResult=findValidMerge(target.choices[i],mergeChoices);mergeResult?(target.choices[i]=mergeResult.mergedInfo,missingChoices.delete(mergeResult.validCandidate)):(target.choices.splice(i,1),i--)}for(const choice of missingChoices){const mergeResult=findValidMerge(choice,originalChoices);mergeResult&&target.choices.push(mergeResult.mergedInfo)}}return target}static __mergeOptionalEditorInfos(target,toMerge){let temporarilyRequired=!1;const unwrappedInfos=toMerge.map((info=>"optional"===info.type?(info.temporarilyRequired&&(temporarilyRequired=!0),info.editorInfo):(temporarilyRequired=!0,info))),merged=this.mergeEditorInfos(target.editorInfo,...unwrappedInfos);return target.editorInfo="optional"!==merged.type?merged:merged.editorInfo,target.temporarilyRequired=temporarilyRequired,target}static __mergeNullEditorInfos(target,toMerge){return(toMerge=toMerge.map((info=>"optional"!==info.type?info:info.editorInfo))).every((info=>"null"===info.type))?target:{type:"invalid",schema:target.schema,name:"Invalid"}}static editorInfoEquivalent(a,b){for(const key in a)if("schema"!==key&&!tchmi_equal(a[key],b[key],SchemaParser.__compareEditorInfoOptions))return!1;return!0}}SchemaParser.__restrictions=new Map([["number",["maximum","minimum","exclusiveMaximum","exclusiveMinimum","multipleOf"]],["string",["maxLength","minLength","pattern","format"]],["object",["properties","patternProperties","dependencies","maxProperties","minProperties","required","additionalProperties"]],["array",["additionalItems","items","maxItems","minItems","uniqueItems"]]]),SchemaParser.__cloneEditorInfoOptions={cloneMaps:{deepCloneKeys:!0,deepCloneValues:!0},cloneSets:{deepCloneValues:!0},cloneDates:!0},SchemaParser.__compareEditorInfoOptions={compareMaps:{deepCompareKeys:!0,deepCompareValues:!0},compareSets:{deepCompareValues:!0},compareDates:!0},Helpers.SchemaParser=SchemaParser}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={}));var TcHmi,__classPrivateFieldGet=this&&this.__classPrivateFieldGet||function(receiver,state,kind,f){if("a"===kind&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof state?receiver!==state||!f:!state.has(receiver))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===kind?f:"a"===kind?f.call(receiver):f?f.value:state.get(receiver)};!function(TcHmi){!function(Controls){!function(Helpers){var _a,_Editor_tchmiFQN;class Editor{constructor(__element,__editorInfo,__parentControl){this.__element=__element,this.__editorInfo=__editorInfo,this.__parentControl=__parentControl,this.__className="TcHmi_Controls_Helpers_Editor",this.__childControls=new Set,this.__eventDestroyers=new Set,this.__isEnabled=!0,this.__localizations=void 0,this.__localizationSymbols=new Map,this.__onChangeManager=new Helpers.CallbackManager,this.onChange=this.__onChangeManager.getManipulators(),this.__name=`${this.__parentControl.getId()}.${this.constructor.name}-${tchmi_create_guid()}`;const controlClass=this.__parentControl.getType().replace(/\./g,"_");__element.classList.add(this.__className,`${this.__className}-${this.constructor.name}`,`${controlClass}-editor`)}static create(element,editorInfo,parentControl,localizations){let editor;switch(editorInfo.type){case"boolean":editor=new Helpers.BooleanEditor(element,editorInfo,parentControl);break;case"number":editor=new Helpers.NumberEditor(element,editorInfo,parentControl);break;case"string":editor=new Helpers.StringEditor(element,editorInfo,parentControl);break;case"time":editor=new Helpers.TimeEditor(element,editorInfo,parentControl);break;case"enum":editor=new Helpers.EnumEditor(element,editorInfo,parentControl);break;case"object":editor=new Helpers.ObjectEditor(element,editorInfo,parentControl);break;case"array":editor=new Helpers.ArrayEditor(element,editorInfo,parentControl);break;case"tuple":editor=new Helpers.TupleEditor(element,editorInfo,parentControl);break;case"optional":editor=new Helpers.OptionalEditor(element,editorInfo,parentControl);break;case"choice":editor=new Helpers.ChoiceEditor(element,editorInfo,parentControl);break;case"null":editor=new Helpers.NullEditor(element,editorInfo,parentControl);break;case"invalid":editor=new Helpers.InvalidEditor(element,editorInfo,parentControl)}return localizations&&editor.setLocalizations(localizations),editor}destroy(){for(const destroy of this.__eventDestroyers)destroy();this.__eventDestroyers.clear();for(const control of this.__childControls)this.__parentControl.__removeChild(control),control.destroy();this.__childControls.clear();for(const entry of this.__localizationSymbols.values())entry.destroyWatch(),entry.symbol.destroy();this.__localizationSymbols.clear()}setEditorInfo(editorInfo){const oldState=this.getState();let changeHandlersTriggered=!1;const detectChangeHandlersTriggered=()=>{changeHandlersTriggered=!0};this.onChange.add(detectChangeHandlersTriggered),this.__editorInfo=editorInfo,this.__processEditorInfo(),this.onChange.remove(detectChangeHandlersTriggered),changeHandlersTriggered||tchmi_equal(oldState,this.getState())||this.__onChangeManager.trigger(this)}getEditorInfo(){return this.__editorInfo}getState(){const value=this.getRawValue();return Editor.validate(this.__editorInfo,value)?{isValid:!0,value:value}:{isValid:!1}}static validate(editorInfo,value){switch(editorInfo.type){case"boolean":return Helpers.BooleanEditor.validate(editorInfo,value);case"number":return Helpers.NumberEditor.validate(editorInfo,value);case"string":return Helpers.StringEditor.validate(editorInfo,value);case"time":return Helpers.TimeEditor.validate(editorInfo,value);case"enum":return Helpers.EnumEditor.validate(editorInfo,value);case"object":return Helpers.ObjectEditor.validate(editorInfo,value);case"array":return Helpers.ArrayEditor.validate(editorInfo,value);case"tuple":return Helpers.TupleEditor.validate(editorInfo,value);case"optional":return Helpers.OptionalEditor.validate(editorInfo,value);case"choice":return Helpers.ChoiceEditor.validate(editorInfo,value);case"null":return Helpers.NullEditor.validate(editorInfo,value);case"invalid":return Helpers.InvalidEditor.validate(editorInfo,value)}}setIsEnabled(isEnabled){this.__isEnabled=isEnabled,this.__element.classList.toggle("disabled",!isEnabled);for(const control of this.__childControls)control.setIsEnabled(isEnabled)}getIsEnabled(){return this.__isEnabled}setLocalizations(texts){if(this.__localizations)for(const[name,subEditorLocalizations]of Object.entries(texts))if(this.__localizations[name])for(const[textName,text]of Object.entries(subEditorLocalizations))this.__localizations[name][textName]=text;else this.__localizations[name]=subEditorLocalizations;else this.__localizations=texts}__watchLocalization(name,localization,onChange){const existing=this.__localizationSymbols.get(name);existing?.destroyWatch(),existing?.symbol.destroy();const symbol=new TcHmi.Symbol(localization.symbolExpression),destroyWatch=symbol.watch((data=>{if(data.error!==TcHmi.Errors.NONE)return void(TCHMI_CONSOLE_LOG_LEVEL>=1&&TcHmi.Log.errorEx(`[Source=Control, Module=${this.__parentControl.getType()}, Origin=${__classPrivateFieldGet(Editor,_a,"f",_Editor_tchmiFQN)}, Id=${this.__parentControl.getId()}, SymbolExpression=${localization.symbolExpression}] `+TcHmi.Log.buildMessage(data.details)));let text=data.value??"";localization.formatValues.length>0&&(text=tchmi_format_string(text,...localization.formatValues)),onChange(text)}));this.__localizationSymbols.set(name,{symbol:symbol,destroyWatch:destroyWatch})}__unwatchLocalization(name){const existing=this.__localizationSymbols.get(name);existing&&(existing.destroyWatch(),existing.symbol.destroy(),this.__localizationSymbols.delete(name))}}_Editor_tchmiFQN={value:"TcHmi.Controls.Helpers."+(_a=Editor).name},Helpers.Editor=Editor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class TextboxBasedEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__onTextChanged=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&(this.__textbox.getElement()[0].classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this))};const textbox=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiTextbox",`${this.__name}.textbox`,{"data-tchmi-content-padding":{top:3,right:3,bottom:3,left:3}},this.__parentControl);if(!textbox)throw new Error("Could not create controls for textbox based editor.");this.__textbox=textbox,this.__childControls.add(textbox);const textboxElement=textbox.getElement()[0];textboxElement.classList.add("with-validation","invalid"),this.__element.appendChild(textboxElement),this.__eventDestroyers.add(TcHmi.EventProvider.register(textbox.getId()+".onTextChanged",this.__onTextChanged))}}Helpers.TextboxBasedEditor=TextboxBasedEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class NumberEditor extends Helpers.TextboxBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__textbox.setTextHorizontalAlignment("Right"),this.__textbox.setSystemKeyboardInputMode(editorInfo.restrictions.every((restriction=>restriction.isInteger))?"numeric":"decimal")}static validate(editorInfo,value){if("string"==typeof value)return!!value&&!(!editorInfo.specialValues.has(value)||!editorInfo.restrictions.some((restriction=>!restriction.isInteger)));if("number"!=typeof value)return!1;if(!Number.isFinite(value)){const text=value.toString();return!(!editorInfo.specialValues.has(text)||!editorInfo.restrictions.some((restriction=>!restriction.isInteger)))}if(0===editorInfo.restrictions.length)return!0;for(const restriction of editorInfo.restrictions)if((!restriction.isInteger||Number.isInteger(value))&&(!restriction.minimum||this.__testMinimum(value,restriction.minimum))&&(!restriction.maximum||this.__testMaximum(value,restriction.maximum))&&(void 0===restriction.multipleOf||value%restriction.multipleOf==0))return!0;return!1}__processEditorInfo(){this.__textbox.getElement()[0].classList.toggle("invalid",!this.getState().isValid)}static __testMinimum(value,minimum){return minimum.exclusive?value>minimum.value:value>=minimum.value}static __testMaximum(value,maximum){return maximum.exclusive?value<maximum.value:value<=maximum.value}setValue(value){"number"==typeof value?this.__textbox.setText(value.toString(10)):this.__textbox.setText(value)}getRawValue(){const text=this.__textbox.getText()??"";return/^[+-]?\d*\.?\d+(?:[eE][+-]?\d+)?$/.test(text)?parseFloat(text):text}}Helpers.NumberEditor=NumberEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class StringEditor extends Helpers.TextboxBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__processEditorInfo()}static validate(editorInfo,value){if("string"!=typeof value)return!1;if(0===editorInfo.restrictions.length)return!0;for(const restriction of editorInfo.restrictions)if(!(void 0!==restriction.minLength&&value.length<restriction.minLength)&&!(void 0!==restriction.maxLength&&value.length>restriction.maxLength)&&(!restriction.patterns||restriction.patterns.every((pattern=>pattern.test(value))))){if(restriction.format){let regex;switch(restriction.format){case"date-time":regex=/^\d{4}-(?:0\d|1[0-2])-(?:[0-2]\d|3[01])[Tt\s](?:[01]\d|2[0-3]):[0-5]\d:(?:[0-5]\d|60)(?:.\d+)?(?:[Zz]|[+-](?:[01]\d|2[0-3]):[0-5]\d)$/;break;case"timespan":regex=/^P(?=.{2,})(?:\d+Y|\d+[.,]\d+Y$)?(?:\d+M|\d+[.,]\d+M$)?(?:\d+W|\d+[.,]\d+W$)?(?:\d+D|\d+[.,]\d+D$)?(?:T(?:\d+H|\d+[.,]\d+H$)?(?:\d+M|\d+[.,]\d+M$)?(?:\d+S|\d+[.,]\d+S$)?)?$/;break;case"email":regex=/^(?:[^@\s"]+|".+")@(?:[^@.\s]+\.)+[^@.\s]+$/;break;case"hostname":regex=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;break;case"ipv4":regex=/^(?:(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d)\.){3}(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d)$/;break;case"ipv6":regex=/^(?:[0-9A-F]{1,4}:){7}[0-9A-F]{1,4}$|^(?:[0-9A-F]{1,4}:){6}(?:(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d)\.){3}(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d)$|^(?=.*::)(?!.*(::).*\1.*)(?!.*:::.*)(?:(?:::)?(?:[0-9A-F]{1,4}::?){0,6}(?:[0-9A-F]{1,4}|::?)|(?:::)?(?:[0-9A-F]{1,4}::?){0,5}(?:(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d)\.){3}(?:25[0-5]|2[0-4]\d|[0-1]?\d?\d))$/i;break;case"uri":regex=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;break;default:regex=/[\s\S]*/}if(!regex.test(value))continue}return!0}return!1}__processEditorInfo(){this.__textbox.getElement()[0].classList.toggle("invalid",!this.getState().isValid)}setValue(value){this.__textbox.setText(value)}getRawValue(){return this.__textbox.getText()??""}}Helpers.StringEditor=StringEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class TimeEditor extends Helpers.TextboxBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__onDateTimeChanged=()=>{const value=this.__dateTimePicker?.getValue();value&&this.__textbox.setText(value)},this.__onDateTimeButtonPressed=()=>{this.__dateTimePicker&&(this.__dateTimePicker.setValue(this.__textbox.getText()??null),this.__dateTimePicker.openDateTimePicker())},this.__onTimespanChanged=()=>{const value=this.__timespanPicker?.getValue();value&&this.__textbox.setText(value)},this.__onTimespanButtonPressed=()=>{this.__timespanPicker&&(this.__timespanPicker.setValue(this.__textbox.getText()??null),this.__timespanPicker.openTimespanPicker())},this.__container=document.createElement("div"),this.__container.classList.add("compound-control-container");for(const child of this.__element.children)this.__container.appendChild(child);if(this.__processEditorInfo(),!(this.__dateTimeButton||this.__dateTimePicker||this.__timespanButton||this.__timespanPicker))throw new Error("Could not create controls for time editor.");element.appendChild(this.__container),this.__textbox.getElement()[0].classList.toggle("invalid",!this.getState().isValid)}destroy(force=!1){this.__dateTimeButton&&TcHmi.Binding.removeEx2(null,"Tooltip",this.__dateTimeButton),this.__timespanButton&&TcHmi.Binding.removeEx2(null,"Tooltip",this.__timespanButton),super.destroy()}static validate(editorInfo,value){return Helpers.StringEditor.validate({type:"string",schema:editorInfo.schema,name:"String",restrictions:Array.from(editorInfo.formats).map((format=>({format:format})))},value)}__processEditorInfo(){this.__editorInfo.formats.has("date-time")?(this.__dateTimeButton&&this.__dateTimePicker||this.__createDateTimeControls(),this.__dateTimeButton?.setVisibility("Visible")):this.__dateTimeButton?.setVisibility("Collapsed"),this.__editorInfo.formats.has("timespan")?(this.__timespanButton&&this.__timespanPicker||this.__createTimespanControls(),this.__timespanButton?.setVisibility("Visible")):this.__timespanButton?.setVisibility("Collapsed")}setValue(value){this.__textbox.setText(value)}getRawValue(){return this.__textbox.getText()??""}__createDateTimeControls(){const dateTimePicker=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiDateTimePicker",`${this.__name}.dateTimePicker`,{"data-tchmi-visibility":"Collapsed","data-tchmi-is-enabled":this.__isEnabled},this.__parentControl),dateTimeButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.dateTimeButton`,{"data-tchmi-width":30,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-is-enabled":this.__isEnabled},this.__parentControl);if(!dateTimePicker||!dateTimeButton)return;this.__dateTimePicker=dateTimePicker,this.__dateTimeButton=dateTimeButton,this.__childControls.add(dateTimePicker),this.__childControls.add(dateTimeButton),this.__localizeDateTimeButton(),this.__eventDestroyers.add(TcHmi.EventProvider.register(dateTimePicker.getId()+".onValueChanged",this.__onDateTimeChanged)),this.__eventDestroyers.add(TcHmi.EventProvider.register(dateTimeButton.getId()+".onPressed",this.__onDateTimeButtonPressed));const dateTimeButtonElement=dateTimeButton.getElement()[0];dateTimeButtonElement.classList.add(`${this.__className}-button-icon-datetimepicker`),this.__container.appendChild(dateTimePicker.getElement()[0]),this.__container.appendChild(dateTimeButtonElement)}__createTimespanControls(){const timespanPicker=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiTimespanPicker",`${this.__name}.timespanPicker`,{"data-tchmi-visibility":"Collapsed","data-tchmi-is-enabled":this.__isEnabled},this.__parentControl),timespanButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.timespanButton`,{"data-tchmi-width":30,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-is-enabled":this.__isEnabled},this.__parentControl);if(!timespanPicker||!timespanButton)throw new Error("Could not create controls for time editor.");this.__timespanPicker=timespanPicker,this.__timespanButton=timespanButton,this.__childControls.add(timespanPicker),this.__childControls.add(timespanButton),this.__localizeTimespanButton(),this.__eventDestroyers.add(TcHmi.EventProvider.register(timespanPicker.getId()+".onValueChanged",this.__onTimespanChanged)),this.__eventDestroyers.add(TcHmi.EventProvider.register(timespanButton.getId()+".onPressed",this.__onTimespanButtonPressed));const timespanButtonElement=timespanButton.getElement()[0];timespanButtonElement.classList.add(`${this.__className}-button-icon-timespanpicker`),this.__container.appendChild(timespanPicker.getElement()[0]),this.__container.appendChild(timespanButtonElement)}setLocalizations(texts){super.setLocalizations(texts),this.__localizeDateTimeButton(),this.__localizeTimespanButton()}__localizeDateTimeButton(){this.__dateTimeButton&&this.__localizations?.timeEditor?.dateTimeButtonTooltip&&("string"==typeof this.__localizations.timeEditor.dateTimeButtonTooltip?(this.__unwatchLocalization("dateTimeButtonTooltip"),TcHmi.Binding.createEx2(this.__localizations.timeEditor.dateTimeButtonTooltip,"Tooltip",this.__dateTimeButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__dateTimeButton),this.__watchLocalization("dateTimeButtonTooltip",this.__localizations.timeEditor.dateTimeButtonTooltip,(text=>this.__dateTimeButton?.setTooltip(text)))))}__localizeTimespanButton(){this.__timespanButton&&this.__localizations?.timeEditor?.timespanButtonTooltip&&("string"==typeof this.__localizations.timeEditor.timespanButtonTooltip?(this.__unwatchLocalization("timespanButtonTooltip"),TcHmi.Binding.createEx2(this.__localizations.timeEditor.timespanButtonTooltip,"Tooltip",this.__timespanButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__timespanButton),this.__watchLocalization("timespanButtonTooltip",this.__localizations.timeEditor.timespanButtonTooltip,(text=>this.__timespanButton?.setTooltip(text)))))}}Helpers.TimeEditor=TimeEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ComboboxBasedEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__onSelectionChanged=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&(this.__combobox.getElement()[0].classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this))};const combobox=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiCombobox",`${this.__name}.combobox`,{"data-tchmi-content-padding":{top:3,right:3,bottom:3,left:3}},this.__parentControl);if(!combobox)throw new Error("Could not create controls for combobox based editor.");this.__combobox=combobox,this.__childControls.add(combobox);const comboboxElement=combobox.getElement()[0];comboboxElement.classList.add("with-validation","invalid"),this.__element.appendChild(comboboxElement),this.__eventDestroyers.add(TcHmi.EventProvider.register(combobox.getId()+".onSelectionChanged",this.__onSelectionChanged))}}Helpers.ComboboxBasedEditor=ComboboxBasedEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class EnumEditor extends Helpers.ComboboxBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__processEditorInfo()}static validate(editorInfo,value){return editorInfo.members.has(value)}__processEditorInfo(){function stringify(value){return"string"==typeof value?value:JSON.stringify(value)}this.__combobox.setSrcData(Array.from(this.__editorInfo.members.entries()).map((([value,label])=>({value:value,text:label??stringify(value)}))))}setValue(value){if(null===value)this.__combobox.setSelectedIndex(null);else{const index=Array.from(this.__editorInfo.members.keys()).indexOf(value);this.__combobox.setSelectedIndex(-1!==index?index:null)}}getRawValue(){return this.__combobox.getSelectedValue()}}Helpers.EnumEditor=EnumEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class BooleanEditor extends Helpers.ComboboxBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__comboboxTexts={false:"",true:""},this.__updateSrcData()}static validate(editorInfo,value){return"boolean"==typeof value}__processEditorInfo(){}setValue(value){switch(value){case!1:this.__combobox.setSelectedIndex(0);break;case!0:this.__combobox.setSelectedIndex(1);break;default:this.__combobox.setSelectedIndex(null)}}getRawValue(){return this.__combobox.getSelectedValue()}__updateSrcData(){this.__combobox.setSrcData([{value:!1,text:this.__comboboxTexts.false},{value:!0,text:this.__comboboxTexts.true}])}setLocalizations(texts){super.setLocalizations(texts);let update=!1;texts.booleanEditor?.falseText&&("string"==typeof texts.booleanEditor.falseText?(this.__comboboxTexts.false=texts.booleanEditor.falseText,update=!0):this.__watchLocalization("falseText",texts.booleanEditor.falseText,(text=>{this.__comboboxTexts.false=text,this.__updateSrcData()}))),texts.booleanEditor?.trueText&&("string"==typeof texts.booleanEditor.trueText?(this.__comboboxTexts.true=texts.booleanEditor.trueText,update=!0):this.__watchLocalization("trueText",texts.booleanEditor.trueText,(text=>{this.__comboboxTexts.true=text,this.__updateSrcData()}))),update&&this.__updateSrcData()}}Helpers.BooleanEditor=BooleanEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ButtonBasedEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__onPressed=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&this.openPopup()},this.__container=document.createElement("div"),this.__container.classList.add("compound-control-container","with-validation","invalid"),this.__textSpan=document.createElement("span"),this.__textSpan.classList.add("value-description"),this.__container.appendChild(this.__textSpan);const button=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.button`,{"data-tchmi-width":26,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-text":"..."},this.__parentControl);if(!button)throw new Error("Could not create controls for button based editor.");this.__button=button,this.__childControls.add(button),this.__container.appendChild(button.getElement()[0]),this.__element.appendChild(this.__container),this.__eventDestroyers.add(TcHmi.EventProvider.register(button.getId()+".onPressed",this.__onPressed))}destroy(force=!1){TcHmi.Binding.removeEx2(null,"Tooltip",this.__button),super.destroy()}setLocalizations(texts){super.setLocalizations(texts),texts.buttonBasedEditor?.buttonTooltip&&("string"==typeof texts.buttonBasedEditor.buttonTooltip?(this.__unwatchLocalization("buttonTooltip"),TcHmi.Binding.createEx2(texts.buttonBasedEditor.buttonTooltip,"Tooltip",this.__button)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__button),this.__watchLocalization("buttonTooltip",texts.buttonBasedEditor.buttonTooltip,(text=>this.__button.setTooltip(text)))))}}Helpers.ButtonBasedEditor=ButtonBasedEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ObjectEditor extends Helpers.ButtonBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__value={},this.__processEditorInfo()}destroy(){super.destroy(),this.__popup?.destroy(!0)}static validate(editorInfo,value){if("object"!=typeof value)return!1;if(null===value)return!1;if(Array.isArray(value))return!1;if(null!==Object.getPrototypeOf(value)&&Object.getPrototypeOf(value)!==Object.getPrototypeOf({}))return!1;const resolvedInfo=ObjectEditor.resolveDependencies(editorInfo,new Set(Object.keys(value)));if("invalid"===resolvedInfo.type)return!1;editorInfo=resolvedInfo;for(const[name,info]of editorInfo.properties)if(("optional"!==info.type||info.temporarilyRequired)&&void 0===value[name])return!1;const isValidName=name=>!!editorInfo.additionalProperties.allowed||(!!editorInfo.properties.has(name)||!(!editorInfo.patternProperties||!Array.from(editorInfo.patternProperties.keys()).some((regex=>regex.test(name)))));let propertiesCount=0;for(const propertyName in value){if(!isValidName(propertyName))return!1;const propertyEditorInfo=ObjectEditor.getEditorInfoForProperty(editorInfo,propertyName);if(!Helpers.Editor.validate(propertyEditorInfo,value[propertyName]))return!1;void 0!==value[propertyName]&&propertiesCount++}return!(void 0!==editorInfo.maxProperties&&propertiesCount>editorInfo.maxProperties)&&!(void 0!==editorInfo.minProperties&&propertiesCount<editorInfo.minProperties)}__processEditorInfo(){this.__popup?.setEditorInfo(this.__editorInfo),this.__textSpan.textContent=this.__editorInfo.name}static resolveDependencies(editorInfo,knownProperties){if(!editorInfo.dependencies)return editorInfo;const matchingDependencies=[];for(const[name,dependency]of editorInfo.dependencies)knownProperties.has(name)&&matchingDependencies.push(dependency);if(0===matchingDependencies.length)return editorInfo;const result=Helpers.SchemaParser.mergeEditorInfos(editorInfo,...matchingDependencies.map((dependency=>this.resolveDependencies(dependency,knownProperties))));return"object"!==result.type?{type:"invalid",schema:result.schema,name:"Invalid"}:result}static getEditorInfoForProperty(editorInfo,property){let info=editorInfo.properties.get(property);if(!info&&editorInfo.patternProperties){const matchingInfos=[];for(const[pattern,info]of editorInfo.patternProperties)pattern.test(property)&&matchingInfos.push(info);matchingInfos.length>0&&(info=Helpers.SchemaParser.mergeEditorInfos(...matchingInfos))}return!info&&editorInfo.additionalProperties.allowed&&(info=editorInfo.additionalProperties.editorInfo??Helpers.ChoiceEditor.createAnyEditorInfo()),info||(info={type:"invalid",schema:{},name:"Invalid"}),info}setValue(value){this.__value=value??{},this.__popup?.setValue(value),this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this)}getRawValue(){return this.__value}async openPopup(){this.__popup||(this.__popup=new Helpers.ObjectEditorPrompt(this.__editorInfo,this.__parentControl),this.__popup.setBackgroundAction({close:!0,action:"cancel"}),this.__popup.setLocalizations({buttonTextOk:this.__localizations?.objectEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.objectEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.objectEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.objectEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations}));try{this.__popup.setValue(this.__value);const result=await this.__popup.prompt();result.isOk&&(this.__value=result.value,this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this))}catch(ex){}}setLocalizations(texts){super.setLocalizations(texts),this.__popup?.setLocalizations({buttonTextOk:this.__localizations?.objectEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.objectEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.objectEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.objectEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations})}}Helpers.ObjectEditor=ObjectEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ObjectEditorPane extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__removeButtonTooltip="",this.__editors=new Map,this.__pauseChangeHandlers=!1,this.__onEditorChanged=editor=>{this.__pauseChangeHandlers||(this.__onChangeManager.trigger(this),editor instanceof Helpers.OptionalEditor&&this.__applyDependencies())},this.__onAddPropertyPressed=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&(this.__newPropertyContainer.classList.add("show"),this.__addPropertyButton.setVisibility("Collapsed"),this.__newPropertyTextbox.getElement()[0].querySelector("input")?.focus())},this.__onNewPropertyTextChanged=()=>{if(!this.__parentControl.getIsEnabled())return;if(!TcHmi.Access.checkAccess(this.__parentControl,"operate"))return;const name=this.__newPropertyTextbox.getText();if(!name)return this.__newPropertyTextbox.getElement()[0].classList.remove("invalid"),void this.__acceptNewPropertyButton.setIsEnabled(!1);!this.__editors.has(name)&&(this.__dependencyOverride.additionalProperties.allowed||this.__dependencyOverride.patternProperties&&Array.from(this.__dependencyOverride.patternProperties.keys()).some((pattern=>pattern.test(name))))?(this.__newPropertyTextbox.getElement()[0].classList.remove("invalid"),this.__acceptNewPropertyButton.setIsEnabled(!0)):(this.__newPropertyTextbox.getElement()[0].classList.add("invalid"),this.__acceptNewPropertyButton.setIsEnabled(!1))},this.__onAcceptNewPropertyPressed=()=>{if(!this.__parentControl.getIsEnabled())return;if(!TcHmi.Access.checkAccess(this.__parentControl,"operate"))return;const name=this.__newPropertyTextbox.getText();if(!name)return;let possibleEditors=[];if(this.__dependencyOverride.patternProperties&&(possibleEditors=Array.from(this.__dependencyOverride.patternProperties).filter((([pattern,info])=>pattern.test(name))).map((([pattern,info])=>info))),0===possibleEditors.length&&this.__dependencyOverride.additionalProperties.editorInfo&&(possibleEditors=[this.__dependencyOverride.additionalProperties.editorInfo]),0===possibleEditors.length)return;const editorEntry=this.__createEditorRow(name,Helpers.SchemaParser.mergeEditorInfos(...possibleEditors),!0);this.__editorTable.appendChild(editorEntry.row),this.__editors.set(name,editorEntry),this.__newPropertyTextbox.setText(null),this.__newPropertyContainer.classList.remove("show"),this.__addPropertyButton.setVisibility("Visible"),this.__pauseChangeHandlers||(this.__onChangeManager.trigger(this),this.__applyDependencies())},this.__onCancelNewPropertyPressed=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&this.__cancelNewProperty()},this.__dependencyOverride=editorInfo;this.__parentControl.getType().replace(/\./g,"_");this.__editorTable=document.createElement("table"),this.__editorTable.classList.add(`${this.__className}-editor-table`),this.__element.appendChild(this.__editorTable);const newPropertyTextbox=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiTextbox",`${this.__name}.NewPropertyTextbox`,{"data-tchmi-content-padding":{top:3,right:3,bottom:3,left:3}},this.__parentControl),acceptNewPropertyButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.AcceptNewPropertyButton`,{"data-tchmi-width":30,"data-tchmi-height":30,"data-tchmi-is-enabled":!1},this.__parentControl),cancelNewPropertyButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.CancelNewPropertyButton`,{"data-tchmi-width":30,"data-tchmi-height":30},this.__parentControl),addPropertyButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.AddPropertyButton`,{"data-tchmi-width":30,"data-tchmi-height":30,"data-tchmi-visibility":"Collapsed"},this.__parentControl);if(!(newPropertyTextbox&&acceptNewPropertyButton&&cancelNewPropertyButton&&addPropertyButton))throw new Error("Could not create controls for object editor.");this.__newPropertyTextbox=newPropertyTextbox,this.__acceptNewPropertyButton=acceptNewPropertyButton,this.__cancelNewPropertyButton=cancelNewPropertyButton,this.__addPropertyButton=addPropertyButton,this.__childControls.add(newPropertyTextbox),this.__childControls.add(acceptNewPropertyButton),this.__childControls.add(cancelNewPropertyButton),this.__childControls.add(addPropertyButton),this.__eventDestroyers.add(TcHmi.EventProvider.register(newPropertyTextbox.getId()+".onTextChanged",this.__onNewPropertyTextChanged)),this.__eventDestroyers.add(TcHmi.EventProvider.register(acceptNewPropertyButton.getId()+".onPressed",this.__onAcceptNewPropertyPressed)),this.__eventDestroyers.add(TcHmi.EventProvider.register(cancelNewPropertyButton.getId()+".onPressed",this.__onCancelNewPropertyPressed)),this.__eventDestroyers.add(TcHmi.EventProvider.register(addPropertyButton.getId()+".onPressed",this.__onAddPropertyPressed)),this.__newPropertyContainer=document.createElement("div"),this.__newPropertyContainer.classList.add("new-property-container");const newPropertyTextboxElement=newPropertyTextbox.getElement()[0];newPropertyTextboxElement.classList.add("with-validation");const cancelNewPropertyButtonElement=cancelNewPropertyButton.getElement()[0];cancelNewPropertyButtonElement.classList.add(`${this.__className}-button-icon-remove`),this.__newPropertyContainer.appendChild(newPropertyTextboxElement),this.__newPropertyContainer.appendChild(acceptNewPropertyButton.getElement()[0]),this.__newPropertyContainer.appendChild(cancelNewPropertyButtonElement),this.__element.appendChild(this.__newPropertyContainer);addPropertyButton.getElement()[0].classList.add(`${this.__className}-button-icon-add`),this.__element.appendChild(addPropertyButton.getElement()[0]),this.__processEditorInfo()}destroy(){TcHmi.Binding.removeEx2(null,"Tooltip",this.__addPropertyButton),TcHmi.Binding.removeEx2(null,"Text",this.__acceptNewPropertyButton),TcHmi.Binding.removeEx2(null,"Tooltip",this.__acceptNewPropertyButton),TcHmi.Binding.removeEx2(null,"Tooltip",this.__cancelNewPropertyButton);for(const editorEntry of this.__editors.values())editorEntry.editor.destroy(),editorEntry.removeButton&&TcHmi.Binding.removeEx2(null,"Tooltip",editorEntry.removeButton);this.__editors.clear(),super.destroy()}__processEditorInfo(){this.__pauseChangeHandlers=!0;const value=this.getRawValue();this.__editorTable.innerHTML="";for(const name of this.__editors.keys())this.__removeEditorRow(name);for(const[name,info]of this.__editorInfo.properties){const editorEntry=this.__createEditorRow(name,info,!1);this.__editorTable.appendChild(editorEntry.row),this.__editors.set(name,editorEntry)}this.__addPropertyButton.setVisibility(this.__editorInfo.additionalProperties.editorInfo||this.__editorInfo.patternProperties?"Visible":"Collapsed"),this.setValue(value),this.__pauseChangeHandlers=!1}setValue(value){this.__pauseChangeHandlers=!0;const missingProperties=new Set(this.__editors.keys());if(value)for(const key in value){let editorEntry=this.__editors.get(key);if(editorEntry)editorEntry.editor.setValue(value[key]),missingProperties.delete(key);else{const editorInfo=Helpers.ObjectEditor.getEditorInfoForProperty(this.__editorInfo,key);editorEntry=this.__createEditorRow(key,editorInfo,!0),this.__editorTable.appendChild(editorEntry.row),this.__editors.set(key,editorEntry),editorEntry.editor.setValue(value[key])}}for(const name of missingProperties){const editorEntry=this.__editors.get(name);editorEntry&&(editorEntry.additionalDestroyer?this.__removeEditorRow(name):editorEntry.editor.setValue(void 0))}this.__pauseChangeHandlers=!1,this.__onChangeManager.trigger(this),this.__applyDependencies()}getRawValue(){const value={};for(const[name,entry]of this.__editors){const rawValue=entry.editor.getRawValue();void 0!==rawValue&&(value[name]=rawValue)}return value}__applyDependencies(){this.__pauseChangeHandlers=!0;const knownProperties=new Set;for(const[name,entry]of this.__editors)void 0!==entry.editor.getRawValue()&&knownProperties.add(name);let resolvedInfo,knownPropertiesCount;do{if(resolvedInfo=Helpers.ObjectEditor.resolveDependencies(this.__editorInfo,knownProperties),knownPropertiesCount=knownProperties.size,"invalid"===resolvedInfo.type)break;for(const[property,info]of resolvedInfo.properties)("optional"!==info.type||info.temporarilyRequired)&&knownProperties.add(property)}while(knownProperties.size!==knownPropertiesCount);if("invalid"===resolvedInfo.type)return void(this.__pauseChangeHandlers=!1);if(Helpers.SchemaParser.editorInfoEquivalent(resolvedInfo,this.__dependencyOverride))return void(this.__pauseChangeHandlers=!1);this.__dependencyOverride=resolvedInfo;const updateEditor=(editorEntry,editorInfo)=>{if(!Helpers.SchemaParser.editorInfoEquivalent(editorEntry.editor.getEditorInfo(),editorInfo))if(editorEntry.editor.getEditorInfo().type===editorInfo.type)editorEntry.editor.setEditorInfo(editorInfo);else{const value=editorEntry.editor.getRawValue();editorEntry.cell.innerHTML="",editorEntry.editor.destroy(),editorEntry.editor=Helpers.Editor.create(editorEntry.cell,editorInfo,this.__parentControl,this.__localizations),editorEntry.editor.setValue(value)}},missingProperties=new Set(this.__editors.keys());for(const[name,editorInfo]of resolvedInfo.properties){missingProperties.delete(name);let entry=this.__editors.get(name);entry?updateEditor(entry,editorInfo):(entry=this.__createEditorRow(name,editorInfo,!0),this.__editorTable.appendChild(entry.row),this.__editors.set(name,entry))}for(const name of missingProperties){const entry=this.__editors.get(name);if(!entry)continue;updateEditor(entry,Helpers.ObjectEditor.getEditorInfoForProperty(resolvedInfo,name))}this.__addPropertyButton.setVisibility(!resolvedInfo.additionalProperties.editorInfo&&!resolvedInfo.patternProperties||this.__newPropertyContainer.classList.contains("show")?"Collapsed":"Visible"),this.__pauseChangeHandlers=!1,this.__onChangeManager.trigger(this)}__createEditorRow(name,editorInfo,isAdditional){const row=document.createElement("tr"),nameCell=document.createElement("td");nameCell.classList.add("name-cell"),nameCell.textContent=name,row.appendChild(nameCell);const editorCell=document.createElement("td");editorCell.classList.add("value-cell"),row.appendChild(editorCell);const editor=Helpers.Editor.create(editorCell,editorInfo,this.__parentControl,this.__localizations);editor.onChange.add(this.__onEditorChanged);const removeCell=document.createElement("td");removeCell.classList.add("remove-cell"),row.appendChild(removeCell);const ret={editor:editor,row:row,cell:editorCell};if(isAdditional){const removeButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.${name}RemoveButton`,{"data-tchmi-width":30,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-tooltip":this.__removeButtonTooltip},this.__parentControl);if(!removeButton)throw new Error("Could not create controls for object editor.");this.__childControls.add(removeButton);const destroyEvent=TcHmi.EventProvider.register(removeButton.getId()+".onPressed",this.__getRemoveButtonPressedHandler(name));this.__eventDestroyers.add(destroyEvent),ret.removeButton=removeButton,ret.additionalDestroyer=()=>{this.__childControls.delete(removeButton),this.__eventDestroyers.delete(destroyEvent),destroyEvent(),this.__parentControl.__removeChild(removeButton),removeButton.destroy()};const removeButtonElement=removeButton.getElement()[0];removeButtonElement.classList.add(`${this.__className}-button-icon-remove`),removeCell.appendChild(removeButtonElement)}return ret}__getRemoveButtonPressedHandler(name){return()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&this.__removeEditorRow(name)}}__removeEditorRow(name){const editorEntry=this.__editors.get(name);editorEntry&&(editorEntry.editor.destroy(),editorEntry.row.remove(),editorEntry.additionalDestroyer?.(),this.__editors.delete(name),this.__pauseChangeHandlers||(this.__onChangeManager.trigger(this),this.__applyDependencies()))}__cancelNewProperty(){this.__newPropertyTextbox.setText(null),this.__newPropertyContainer.classList.remove("show"),this.__addPropertyButton.setVisibility("Visible")}setIsEnabled(isEnabled){super.setIsEnabled(isEnabled),!isEnabled&&this.__newPropertyContainer.classList.contains("show")&&this.__cancelNewProperty(),this.__acceptNewPropertyButton.setIsEnabled(!1)}setLocalizations(texts){if(super.setLocalizations(texts),texts.objectEditorPane?.addButtonTooltip&&("string"==typeof texts.objectEditorPane.addButtonTooltip?(this.__unwatchLocalization("addButtonTooltip"),TcHmi.Binding.createEx2(texts.objectEditorPane.addButtonTooltip,"Tooltip",this.__addPropertyButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__addPropertyButton),this.__watchLocalization("addButtonTooltip",texts.objectEditorPane.addButtonTooltip,(text=>this.__addPropertyButton.setTooltip(text))))),texts.objectEditorPane?.acceptButtonText&&("string"==typeof texts.objectEditorPane.acceptButtonText?(this.__unwatchLocalization("acceptButtonText"),TcHmi.Binding.createEx2(texts.objectEditorPane.acceptButtonText,"Text",this.__acceptNewPropertyButton)):(TcHmi.Binding.removeEx2(null,"Text",this.__acceptNewPropertyButton),this.__watchLocalization("acceptButtonText",texts.objectEditorPane.acceptButtonText,(text=>this.__acceptNewPropertyButton.setText(text))))),texts.objectEditorPane?.acceptButtonTooltip&&("string"==typeof texts.objectEditorPane.acceptButtonTooltip?(this.__unwatchLocalization("acceptButtonTooltip"),TcHmi.Binding.createEx2(texts.objectEditorPane.acceptButtonTooltip,"Tooltip",this.__acceptNewPropertyButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__acceptNewPropertyButton),this.__watchLocalization("acceptButtonTooltip",texts.objectEditorPane.acceptButtonTooltip,(text=>this.__acceptNewPropertyButton.setTooltip(text))))),texts.objectEditorPane?.cancelButtonTooltip&&("string"==typeof texts.objectEditorPane.cancelButtonTooltip?(this.__unwatchLocalization("cancelButtonTooltip"),TcHmi.Binding.createEx2(texts.objectEditorPane.cancelButtonTooltip,"Tooltip",this.__cancelNewPropertyButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__cancelNewPropertyButton),this.__watchLocalization("cancelButtonTooltip",texts.objectEditorPane.cancelButtonTooltip,(text=>this.__cancelNewPropertyButton.setTooltip(text))))),texts.objectEditorPane?.removeButtonTooltip)if(this.__unwatchLocalization("removeButtonTooltip"),"string"==typeof texts.objectEditorPane.removeButtonTooltip){this.__removeButtonTooltip=texts.objectEditorPane.removeButtonTooltip;for(const editorEntry of this.__editors.values())editorEntry.removeButton&&TcHmi.Binding.createEx2(texts.objectEditorPane.removeButtonTooltip,"Tooltip",editorEntry.removeButton)}else{for(const editorEntry of this.__editors.values())editorEntry.removeButton&&TcHmi.Binding.removeEx2(null,"Tooltip",editorEntry.removeButton);this.__watchLocalization("removeButtonTooltip",texts.objectEditorPane.removeButtonTooltip,(text=>{this.__removeButtonTooltip=text;for(const editorEntry of this.__editors.values())editorEntry.removeButton?.setTooltip(text)}))}for(const editorEntry of this.__editors.values())editorEntry.editor.setLocalizations(texts)}}Helpers.ObjectEditorPane=ObjectEditorPane}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class OptionalEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__onToggleStateChanged=()=>{const toggleStateActive="Active"===this.__checkbox.getToggleState();this.__editor.setIsEnabled(toggleStateActive),this.__checkbox.getElement()[0].classList.toggle("invalid",this.__editorInfo.temporarilyRequired&&!toggleStateActive),this.__onChangeManager.trigger(this)},this.__onEditorChanged=()=>{this.__onChangeManager.trigger(this)},this.__container=document.createElement("div"),this.__container.classList.add("compound-control-container"),this.__editor=Helpers.Editor.create(this.__container,editorInfo.editorInfo,parentControl,this.__localizations),this.__editor.onChange.add(this.__onEditorChanged),this.__editor.setIsEnabled(editorInfo.temporarilyRequired);const checkbox=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiCheckbox",`${this.__name}.checkbox`,{"data-tchmi-width":30,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-toggle-state":editorInfo.temporarilyRequired?"Active":"Normal"},this.__parentControl);if(!checkbox)throw new Error("Could not create controls for optional editor.");this.__checkbox=checkbox,this.__childControls.add(checkbox),this.__eventDestroyers.add(TcHmi.EventProvider.register(checkbox.getId()+".onToggleStateChanged",this.__onToggleStateChanged));const checkboxElement=checkbox.getElement()[0];checkboxElement.classList.add("with-validation"),this.__container.appendChild(checkboxElement),element.appendChild(this.__container)}destroy(force=!1){TcHmi.Binding.removeEx2(null,"Tooltip",this.__checkbox),super.destroy()}setEditorInfo(editorInfo){!this.__editorInfo.temporarilyRequired&&editorInfo.temporarilyRequired&&this.__checkbox.setToggleState("Active"),super.setEditorInfo(editorInfo)}__processEditorInfo(){if(this.__editor.getEditorInfo().type===this.__editorInfo.editorInfo.type)this.__editor.setEditorInfo(this.__editorInfo.editorInfo);else{const value=this.__editor.getRawValue();this.__container.innerHTML="",this.__editor.destroy(),this.__editor=Helpers.Editor.create(this.__container,this.__editorInfo.editorInfo,this.__parentControl,this.__localizations),this.__editor.setValue(value),this.__editor.onChange.add(this.__onEditorChanged),this.__container.appendChild(this.__checkbox.getElement()[0])}this.__onToggleStateChanged()}static validate(editorInfo,value){return void 0===value?!editorInfo.temporarilyRequired:Helpers.Editor.validate(editorInfo.editorInfo,value)}setValue(value){void 0===value?(this.__checkbox.setToggleState("Normal"),this.__editor.setValue(null)):(this.__checkbox.setToggleState("Active"),this.__editor.setValue(value))}getRawValue(){return"Normal"===this.__checkbox.getToggleState()?void 0:this.__editor.getRawValue()}setLocalizations(texts){super.setLocalizations(texts),texts.optionalEditor?.optionalCheckboxTooltip&&("string"==typeof texts.optionalEditor.optionalCheckboxTooltip?(this.__unwatchLocalization("optionalCheckboxTooltip"),TcHmi.Binding.createEx2(texts.optionalEditor.optionalCheckboxTooltip,"Tooltip",this.__checkbox)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__checkbox),this.__watchLocalization("optionalCheckboxTooltip",texts.optionalEditor.optionalCheckboxTooltip,(text=>this.__checkbox.setTooltip(text))))),this.__editor.setLocalizations(texts)}}Helpers.OptionalEditor=OptionalEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ArrayEditor extends Helpers.ButtonBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__value=[],this.__processEditorInfo()}destroy(){super.destroy(),this.__popup?.destroy(!0)}static validate(editorInfo,value){if(!Array.isArray(value))return!1;if(null!==Object.getPrototypeOf(value)&&Object.getPrototypeOf(value)!==Object.getPrototypeOf([]))return!1;if(void 0!==editorInfo.minItems&&value.length<editorInfo.minItems)return!1;if(void 0!==editorInfo.maxItems&&value.length>editorInfo.maxItems)return!1;for(let i=0,ii=value.length;i<ii;i++)if(!Helpers.Editor.validate(editorInfo.items,value[i]))return!1;if(editorInfo.uniqueItems)for(let i=0,ii=value.length-1;i<ii;i++)for(let j=i+1,jj=value.length;j<jj;j++)if(tchmi_equal(value[i],value[j],{compareDates:!0}))return!1;return!0}__processEditorInfo(){this.__popup?.setEditorInfo(this.__editorInfo),this.__textSpan.textContent=this.__editorInfo.name}setValue(value){this.__value=value??[],this.__popup?.setValue(value),this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this)}getRawValue(){return this.__value}async openPopup(){this.__popup||(this.__popup=new Helpers.ArrayEditorPrompt(this.__editorInfo,this.__parentControl),this.__popup.setBackgroundAction({close:!0,action:"cancel"}),this.__popup.setLocalizations({buttonTextOk:this.__localizations?.arrayEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.arrayEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.arrayEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.arrayEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations}));try{this.__popup.setValue(this.__value);const result=await this.__popup.prompt();result.isOk&&(this.__value=result.value,this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this))}catch(ex){}}setLocalizations(texts){super.setLocalizations(texts),this.__popup?.setLocalizations({buttonTextOk:this.__localizations?.arrayEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.arrayEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.arrayEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.arrayEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations})}}Helpers.ArrayEditor=ArrayEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ArrayBasedEditorPane extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__removeButtonTooltip="",this.__editors=[],this.__selectedEditorEntry=null,this.__pauseChangeHandlers=!1,this.__onEditorChanged=editor=>{this.__handleOnEditorChanged(editor)},this.__onClick=e=>{if(!this.__parentControl.getIsEnabled())return;if(!TcHmi.Access.checkAccess(this.__parentControl,"operate"))return;if(!(e.target instanceof Element)||e.target.closest('div[data-tchmi-type="TcHmi.Controls.Beckhoff.TcHmiButton"]'))return;const row=e.target.closest("tr"),editorEntry=this.__editors.find((entry=>entry.row===row));this.__selectItem(editorEntry??null)},this.__onAddItemPressed=()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&this.__addItem()},this.__onUpPressed=()=>{if(!this.__parentControl.getIsEnabled())return;if(!TcHmi.Access.checkAccess(this.__parentControl,"operate"))return;if(!this.__selectedEditorEntry||!this.__selectedEditorEntry.row.previousElementSibling)return;const currentIndex=this.__editors.indexOf(this.__selectedEditorEntry);-1!==currentIndex&&0!==currentIndex&&(this.__selectedEditorEntry.row.previousElementSibling.insertAdjacentElement("beforebegin",this.__selectedEditorEntry.row),this.__editors.splice(currentIndex-1,0,...this.__editors.splice(currentIndex,1)),this.__onChangeManager.trigger(this),this.__selectItem(this.__selectedEditorEntry))},this.__onDownPressed=()=>{if(!this.__parentControl.getIsEnabled())return;if(!TcHmi.Access.checkAccess(this.__parentControl,"operate"))return;if(!this.__selectedEditorEntry||!this.__selectedEditorEntry.row.nextElementSibling)return;const currentIndex=this.__editors.indexOf(this.__selectedEditorEntry);-1!==currentIndex&&currentIndex!==this.__editors.length-1&&(this.__selectedEditorEntry.row.nextElementSibling.insertAdjacentElement("afterend",this.__selectedEditorEntry.row),this.__editors.splice(currentIndex+1,0,...this.__editors.splice(currentIndex,1)),this.__onChangeManager.trigger(this),this.__selectItem(this.__selectedEditorEntry))},this.__editorTable=document.createElement("table"),this.__editorTable.classList.add(`${this.__className}-editor-table`),this.__element.appendChild(this.__editorTable);const addItemButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.AddItemButton`,{"data-tchmi-width":30,"data-tchmi-height":30},this.__parentControl),upButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.UpButton`,{"data-tchmi-width":30,"data-tchmi-height":30,"data-tchmi-is-enabled":!1},this.__parentControl),downButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.DownButton`,{"data-tchmi-width":30,"data-tchmi-height":30,"data-tchmi-is-enabled":!1},this.__parentControl);if(!addItemButton||!upButton||!downButton)throw new Error("Could not create controls for array editor.");const buttonContainer=document.createElement("div");buttonContainer.classList.add(`${this.__className}-editor-table-buttons`),this.__addItemButton=addItemButton,this.__childControls.add(addItemButton),this.__eventDestroyers.add(TcHmi.EventProvider.register(addItemButton.getId()+".onPressed",this.__onAddItemPressed));addItemButton.getElement()[0].classList.add(`${this.__className}-button-icon-add`),buttonContainer.appendChild(addItemButton.getElement()[0]),this.__upButton=upButton,this.__childControls.add(upButton),this.__eventDestroyers.add(TcHmi.EventProvider.register(upButton.getId()+".onPressed",this.__onUpPressed));upButton.getElement()[0].classList.add(`${this.__className}-button-icon-up`),buttonContainer.appendChild(upButton.getElement()[0]),this.__downButton=downButton,this.__childControls.add(downButton),this.__eventDestroyers.add(TcHmi.EventProvider.register(downButton.getId()+".onPressed",this.__onDownPressed));downButton.getElement()[0].classList.add(`${this.__className}-button-icon-down`),buttonContainer.appendChild(downButton.getElement()[0]),this.__element.appendChild(buttonContainer),this.__element.addEventListener("click",this.__onClick,{passive:!0}),this.__processEditorInfo()}destroy(){TcHmi.Binding.removeEx2(null,"Tooltip",this.__addItemButton),TcHmi.Binding.removeEx2(null,"Tooltip",this.__upButton),TcHmi.Binding.removeEx2(null,"Tooltip",this.__downButton);for(const editorEntry of this.__editors)editorEntry.editor.destroy(),editorEntry.removeButton&&TcHmi.Binding.removeEx2(null,"Tooltip",editorEntry.removeButton);this.__editors=[],this.__element.removeEventListener("click",this.__onClick),super.destroy()}getRawValue(){const value=[];for(const entry of this.__editors){const rawValue=entry.editor.getRawValue();void 0!==rawValue&&value.push(rawValue)}return value}__createEditorRow(editorInfo,removable=!0){const row=document.createElement("tr"),indexCell=document.createElement("td");indexCell.classList.add("name-cell","auto-increment-index"),row.appendChild(indexCell);const editorCell=document.createElement("td");editorCell.classList.add("value-cell"),row.appendChild(editorCell);const editor=Helpers.Editor.create(editorCell,editorInfo,this.__parentControl,this.__localizations);editor.onChange.add(this.__onEditorChanged);const removeCell=document.createElement("td");removeCell.classList.add("remove-cell"),row.appendChild(removeCell);const ret={editor:editor,row:row,cell:editorCell};if(removable){const removeButton=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiButton",`${this.__name}.${tchmi_create_guid()}_RemoveButton`,{"data-tchmi-width":30,"data-tchmi-height":100,"data-tchmi-height-unit":"%","data-tchmi-tooltip":this.__removeButtonTooltip},this.__parentControl);if(!removeButton)throw new Error("Could not create controls for array editor.");this.__childControls.add(removeButton);const destroyEvent=TcHmi.EventProvider.register(removeButton.getId()+".onPressed",this.__getRemoveButtonPressedHandler(ret));this.__eventDestroyers.add(destroyEvent),ret.removeButton=removeButton,ret.removeDestroyer=()=>{this.__childControls.delete(removeButton),this.__eventDestroyers.delete(destroyEvent),destroyEvent(),this.__parentControl.__removeChild(removeButton),removeButton.destroy()};const removeButtonElement=removeButton.getElement()[0];removeButtonElement.classList.add(`${this.__className}-button-icon-remove`),removeCell.appendChild(removeButtonElement)}return ret}__handleOnEditorChanged(editor){this.__pauseChangeHandlers||this.__onChangeManager.trigger(this)}__getRemoveButtonPressedHandler(entry){return()=>{this.__parentControl.getIsEnabled()&&TcHmi.Access.checkAccess(this.__parentControl,"operate")&&this.__removeEditorRow(entry)}}__removeEditorRow(editorEntry){this.__selectedEditorEntry===editorEntry&&this.__selectItem(null);const index=this.__editors.indexOf(editorEntry);-1!==index&&(editorEntry.editor.destroy(),editorEntry.row.remove(),editorEntry.removeDestroyer?.(),this.__editors.splice(index,1),this.__pauseChangeHandlers||this.__onChangeManager.trigger(this))}__selectItem(editorEntry){this.__selectedEditorEntry!==editorEntry&&(this.__selectedEditorEntry?.row.classList.remove("selected"),this.__selectedEditorEntry=editorEntry,this.__selectedEditorEntry?.row.classList.add("selected")),this.__updateMoveButtons(editorEntry?this.__editors.indexOf(editorEntry):-1)}__updateMoveButtons(selectedIndex){this.__upButton.setIsEnabled(-1!==selectedIndex&&selectedIndex>0),this.__downButton.setIsEnabled(-1!==selectedIndex&&selectedIndex<this.__editors.length-1)}setIsEnabled(isEnabled){super.setIsEnabled(isEnabled),this.__selectItem(this.__selectedEditorEntry)}setLocalizations(texts){if(super.setLocalizations(texts),texts.arrayBasedEditorPane?.addButtonTooltip&&("string"==typeof texts.arrayBasedEditorPane.addButtonTooltip?(this.__unwatchLocalization("addButtonTooltip"),TcHmi.Binding.createEx2(texts.arrayBasedEditorPane.addButtonTooltip,"Tooltip",this.__addItemButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__addItemButton),this.__watchLocalization("addButtonTooltip",texts.arrayBasedEditorPane.addButtonTooltip,(text=>this.__addItemButton.setTooltip(text))))),texts.arrayBasedEditorPane?.upButtonTooltip&&("string"==typeof texts.arrayBasedEditorPane.upButtonTooltip?(this.__unwatchLocalization("upButtonTooltip"),TcHmi.Binding.createEx2(texts.arrayBasedEditorPane.upButtonTooltip,"Tooltip",this.__upButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__upButton),this.__watchLocalization("upButtonTooltip",texts.arrayBasedEditorPane.upButtonTooltip,(text=>this.__upButton.setTooltip(text))))),texts.arrayBasedEditorPane?.downButtonTooltip&&("string"==typeof texts.arrayBasedEditorPane.downButtonTooltip?(this.__unwatchLocalization("downButtonTooltip"),TcHmi.Binding.createEx2(texts.arrayBasedEditorPane.downButtonTooltip,"Tooltip",this.__downButton)):(TcHmi.Binding.removeEx2(null,"Tooltip",this.__downButton),this.__watchLocalization("downButtonTooltip",texts.arrayBasedEditorPane.downButtonTooltip,(text=>this.__downButton.setTooltip(text))))),texts.arrayBasedEditorPane?.removeButtonTooltip)if("string"==typeof texts.arrayBasedEditorPane.removeButtonTooltip){this.__unwatchLocalization("removeButtonTooltip"),this.__removeButtonTooltip=texts.arrayBasedEditorPane.removeButtonTooltip;for(const editorEntry of this.__editors)editorEntry.removeButton&&TcHmi.Binding.createEx2(texts.arrayBasedEditorPane.removeButtonTooltip,"Tooltip",editorEntry.removeButton)}else{for(const editorEntry of this.__editors)editorEntry.removeButton&&TcHmi.Binding.removeEx2(null,"Tooltip",editorEntry.removeButton);this.__watchLocalization("removeButtonTooltip",texts.arrayBasedEditorPane.removeButtonTooltip,(text=>{this.__removeButtonTooltip=text;for(const editorEntry of this.__editors)editorEntry.removeButton?.setTooltip(text)}))}for(const editorEntry of this.__editors)editorEntry.editor.setLocalizations(texts)}}Helpers.ArrayBasedEditorPane=ArrayBasedEditorPane}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ArrayEditorPane extends Helpers.ArrayBasedEditorPane{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl)}__processEditorInfo(){const value=this.getRawValue();this.__editorTable.innerHTML="";for(const entry of this.__editors)this.__removeEditorRow(entry);this.setValue(value)}setValue(value){this.__pauseChangeHandlers=!0,null===value&&(value=[]);let index=0;for(let length=value.length;index<length;index++){let editorEntry=this.__editors[index];editorEntry||(editorEntry=this.__createEditorRow(this.__editorInfo.items),this.__editorTable.appendChild(editorEntry.row),this.__editors.push(editorEntry)),editorEntry.editor.setValue(value[index])}if(index<this.__editors.length){const deletedEditors=this.__editors.splice(index);for(const entry of deletedEditors)this.__removeEditorRow(entry)}this.__pauseChangeHandlers=!1,this.__onChangeManager.trigger(this)}__addItem(){const editorEntry=this.__createEditorRow(this.__editorInfo.items);this.__editorTable.appendChild(editorEntry.row),this.__editors.push(editorEntry),this.__pauseChangeHandlers||this.__onChangeManager.trigger(this),this.__selectItem(editorEntry)}}Helpers.ArrayEditorPane=ArrayEditorPane}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class TupleEditor extends Helpers.ButtonBasedEditor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__value=[],this.__processEditorInfo()}destroy(){super.destroy(),this.__popup?.destroy(!0)}static validate(editorInfo,value){const arrayEditorInfo={type:"array",schema:editorInfo.schema,name:editorInfo.name,items:Helpers.ChoiceEditor.createAnyEditorInfo(),uniqueItems:editorInfo.uniqueItems};if(void 0!==editorInfo.minItems&&(arrayEditorInfo.minItems=editorInfo.minItems),void 0!==editorInfo.maxItems&&(arrayEditorInfo.maxItems=editorInfo.maxItems),!Helpers.ArrayEditor.validate(arrayEditorInfo,value))return!1;for(let i=0,ii=value.length;i<ii;i++)if(i<editorInfo.items.length){if(!Helpers.Editor.validate(editorInfo.items[i],value[i]))return!1}else{if(!editorInfo.additionalItems.allowed)return!1;if(editorInfo.additionalItems.editorInfo&&!Helpers.Editor.validate(editorInfo.additionalItems.editorInfo,value[i]))return!1}return!0}__processEditorInfo(){this.__popup?.setEditorInfo(this.__editorInfo),this.__textSpan.textContent=this.__editorInfo.name}setValue(value){this.__value=value??[],this.__popup?.setValue(value),this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this)}getRawValue(){return this.__value}async openPopup(){this.__popup||(this.__popup=new Helpers.TupleEditorPrompt(this.__editorInfo,this.__parentControl),this.__popup.setBackgroundAction({close:!0,action:"cancel"}),this.__popup.setLocalizations({buttonTextOk:this.__localizations?.tupleEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.tupleEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.tupleEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.tupleEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations}));try{this.__popup.setValue(this.__value);const result=await this.__popup.prompt();result.isOk&&(this.__value=result.value,this.__container.classList.toggle("invalid",!this.getState().isValid),this.__onChangeManager.trigger(this))}catch(ex){}}setLocalizations(texts){super.setLocalizations(texts),this.__popup?.setLocalizations({buttonTextOk:this.__localizations?.tupleEditorPrompt?.buttonTextOk,buttonTooltipOk:this.__localizations?.tupleEditorPrompt?.buttonTooltipOk,buttonTextCancel:this.__localizations?.tupleEditorPrompt?.buttonTextCancel,buttonTooltipCancel:this.__localizations?.tupleEditorPrompt?.buttonTooltipCancel,editorLocalizations:this.__localizations})}}Helpers.TupleEditor=TupleEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class TupleEditorPane extends Helpers.ArrayBasedEditorPane{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl)}__processEditorInfo(){const value=this.getRawValue();this.__editorTable.innerHTML="";for(const entry of this.__editors)this.__removeEditorRow(entry);for(const item of this.__editorInfo.items){const editorEntry=this.__createEditorRow(item,!1);this.__editorTable.appendChild(editorEntry.row),this.__editors.push(editorEntry)}this.setValue(value),this.__addItemButton.setVisibility(this.__editorInfo.additionalItems.allowed&&this.__editorInfo.additionalItems.editorInfo?"Visible":"Hidden")}setValue(value){this.__pauseChangeHandlers=!0,null===value&&(value=[]);let index=0;for(let length=value.length;index<length;index++){let editorEntry=this.__editors[index];if(!editorEntry){let info;info=this.__editorInfo.additionalItems.allowed?this.__editorInfo.additionalItems.editorInfo??Helpers.ChoiceEditor.createAnyEditorInfo():{type:"invalid",schema:{},name:"Invalid"},editorEntry=this.__createEditorRow(info),this.__editorTable.appendChild(editorEntry.row),this.__editors.push(editorEntry)}editorEntry.editor.setValue(value[index])}for(;index<this.__editorInfo.items.length;)this.__editors[index].editor.setValue(void 0),index++;if(index<this.__editors.length){const deletedEditors=this.__editors.splice(index);for(const entry of deletedEditors)this.__removeEditorRow(entry)}this.__pauseChangeHandlers=!1,this.__onChangeManager.trigger(this)}__markRequired(){this.__pauseChangeHandlers=!0;let triggerChangeHandlers=!1,shouldBeRequired=this.__editors.length>this.__editorInfo.items.length;for(let i=this.__editorInfo.items.length-1;i>=0;i--){const editor=this.__editors[i].editor;let editorInfo=this.__editors[i].editor.getEditorInfo();if("optional"!==editorInfo.type)break;editorInfo.temporarilyRequired!==shouldBeRequired&&(editorInfo=tchmi_clone_object(editorInfo),editorInfo.temporarilyRequired=shouldBeRequired,editor.setEditorInfo(editorInfo),triggerChangeHandlers=!0),shouldBeRequired||void 0===editor.getRawValue()||(shouldBeRequired=!0)}this.__pauseChangeHandlers=!1,triggerChangeHandlers&&this.__onChangeManager.trigger(this)}__handleOnEditorChanged(editor){super.__handleOnEditorChanged(editor),this.__markRequired()}__addItem(){if(!this.__editorInfo.additionalItems.allowed)return;const info=this.__editorInfo.additionalItems.editorInfo??Helpers.ChoiceEditor.createAnyEditorInfo(),editorEntry=this.__createEditorRow(info);this.__editorTable.appendChild(editorEntry.row),this.__editors.push(editorEntry),this.__pauseChangeHandlers||this.__onChangeManager.trigger(this),this.__markRequired(),this.__selectItem(editorEntry)}__removeEditorRow(editorEntry){super.__removeEditorRow(editorEntry),this.__markRequired()}__updateMoveButtons(selectedIndex){this.__upButton.setIsEnabled(-1!==selectedIndex&&selectedIndex>this.__editorInfo.items.length),this.__downButton.setIsEnabled(-1!==selectedIndex&&selectedIndex>=this.__editorInfo.items.length&&selectedIndex<this.__editors.length-1)}}Helpers.TupleEditorPane=TupleEditorPane}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class NullEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl);const textSpan=document.createElement("span");textSpan.classList.add("value-description"),textSpan.textContent="null",this.__element.appendChild(textSpan)}static validate(editorInfo,value){return null===value}__processEditorInfo(){}setValue(value){}getRawValue(){return null}}Helpers.NullEditor=NullEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class InvalidEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__textContainer=document.createElement("div"),this.__textContainer.classList.add("with-validation","invalid")}static validate(editorInfo,value){return!1}__processEditorInfo(){}setValue(value){this.__value=value,this.__textContainer.textContent="string"==typeof value?value:JSON.stringify(value)}getRawValue(){return this.__value}}Helpers.InvalidEditor=InvalidEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ChoiceEditor extends Helpers.Editor{constructor(element,editorInfo,parentControl){super(element,editorInfo,parentControl),this.__editors=new Map,this.__activeEditor=null,this.__onSelectionChanged=()=>{const choices=this.__editorInfo.choices??ChoiceEditor.getAnyChoices(),index=this.__combobox.getSelectedIndex();if(null==index||index<0||index>=choices.length)this.__activeEditor?.container.remove(),this.__activeEditor?.editor.onChange.remove(this.__onEditorChanged),this.__activeEditor=null;else{const editorInfo=choices[index];let editorEntry=this.__editors.get(editorInfo.type);if(!editorEntry){const container=document.createElement("div");container.classList.add("choice-sub-editor"),editorEntry={editor:Helpers.Editor.create(container,editorInfo,this.__parentControl,this.__localizations),container:container},this.__editors.set(editorInfo.type,editorEntry)}editorEntry.editor.setEditorInfo(editorInfo),editorEntry.editor.setValue(this.__value),this.__activeEditor?(this.__activeEditor.container.replaceWith(editorEntry.container),this.__activeEditor.editor.onChange.remove(this.__onEditorChanged)):this.__container.prepend(editorEntry.container),editorEntry.editor.onChange.add(this.__onEditorChanged),this.__activeEditor=editorEntry,this.__onChangeManager.trigger(this)}},this.__onEditorChanged=editor=>{this.__value=editor.getRawValue(),this.__onChangeManager.trigger(this)},this.__container=document.createElement("div"),this.__container.classList.add("compound-control-container");const combobox=TcHmi.ControlFactory.createEx("TcHmi.Controls.Beckhoff.TcHmiCombobox",`${this.__name}.combobox`,{"data-tchmi-content-padding":{top:3,right:3,bottom:3,left:3}},this.__parentControl);if(!combobox)throw new Error("Could not create controls for choice editor.");this.__combobox=combobox,this.__childControls.add(combobox),this.__eventDestroyers.add(TcHmi.EventProvider.register(combobox.getId()+".onSelectionChanged",this.__onSelectionChanged));const comboboxElement=combobox.getElement()[0];comboboxElement.classList.add("type-combobox"),this.__container.appendChild(comboboxElement),this.__processEditorInfo(),element.appendChild(this.__container)}static createAnyEditorInfo(){return{type:"choice",schema:{},name:"Any"}}static getAnyChoices(){return[{type:"boolean",schema:{},name:"Boolean"},{type:"number",schema:{},name:"Number",specialValues:new Set(["NaN","Infinity","-Infinity"]),restrictions:[]},{type:"string",schema:{},name:"String",restrictions:[]},{type:"time",schema:{},name:"Time",formats:new Set(["date-time","timespan"])},{type:"object",schema:{},name:"Object",properties:new Map,additionalProperties:{allowed:!0,editorInfo:ChoiceEditor.createAnyEditorInfo()}},{type:"array",schema:{},name:"Array",items:ChoiceEditor.createAnyEditorInfo(),uniqueItems:!1},{type:"null",schema:{},name:"Null"}]}static validate(editorInfo,value){return!editorInfo.choices||editorInfo.choices.some((info=>Helpers.Editor.validate(info,value)))}__processEditorInfo(){const choices=this.__editorInfo.choices??ChoiceEditor.getAnyChoices();if(this.__combobox.setSrcData(choices.map((choice=>({text:choice.name})))),this.__activeEditor){const currentlyChosenEditorInfo=this.__activeEditor.editor.getEditorInfo(),unboxedType="optional"===currentlyChosenEditorInfo.type?currentlyChosenEditorInfo.editorInfo.type:currentlyChosenEditorInfo.type;choices.some((choice=>"optional"!==choice.type?choice.type===unboxedType:choice.editorInfo.type===unboxedType&&"optional"===currentlyChosenEditorInfo.type))||(this.__activeEditor.container.remove(),this.__activeEditor.editor.onChange.remove(this.__onEditorChanged),this.__activeEditor=null,this.__onChangeManager.trigger(this))}for(const[type,editorEntry]of this.__editors){const editorInfo=editorEntry.editor.getEditorInfo(),unboxedType="optional"===editorInfo.type?editorInfo.editorInfo.type:editorInfo.type;choices.some((choice=>"optional"!==choice.type?choice.type===unboxedType:choice.editorInfo.type===unboxedType&&"optional"===editorInfo.type))||this.__editors.delete(type)}}setValue(value){if(this.__value=value,this.__activeEditor&&Helpers.Editor.validate(this.__activeEditor.editor.getEditorInfo(),value))return void this.__activeEditor.editor.setValue(value);const currentComboboxIndex=this.__combobox.getSelectedIndex(),availableTypes=[],choices=this.__editorInfo.choices??ChoiceEditor.getAnyChoices();for(const[index,choice]of choices.entries()){if(Helpers.Editor.validate(choice,value))return void this.__combobox.setSelectedIndex(index);availableTypes.push("optional"!==choice.type?choice.type:choice.editorInfo.type)}const currentlyChosenEditorInfo=this.__activeEditor?.editor.getEditorInfo(),currentType="optional"===currentlyChosenEditorInfo?.type?currentlyChosenEditorInfo.editorInfo.type:currentlyChosenEditorInfo?.type??null;let index;switch(typeof value){case"boolean":index=availableTypes.indexOf("boolean"),-1!==index&&currentType!==availableTypes[index]&&this.__combobox.setSelectedIndex(index);break;case"number":index=availableTypes.indexOf("number"),-1!==index&&currentType!==availableTypes[index]&&this.__combobox.setSelectedIndex(index);break;case"string":index=availableTypes.indexOf("string"),-1===index&&(index=availableTypes.indexOf("time")),-1!==index&&currentType!==availableTypes[index]&&this.__combobox.setSelectedIndex(index);break;case"object":null===value?index=availableTypes.indexOf("null"):Array.isArray(value)?(index=availableTypes.indexOf("array"),-1===index&&(index=availableTypes.indexOf("tuple"))):index=availableTypes.indexOf("object"),-1!==index&&currentType!==availableTypes[index]&&this.__combobox.setSelectedIndex(index)}this.__activeEditor&&this.__combobox.getSelectedIndex()===currentComboboxIndex&&this.__activeEditor.editor.setValue(value)}getState(){return this.__activeEditor?this.__activeEditor.editor.getState():{isValid:!1}}getRawValue(){return this.__activeEditor?this.__activeEditor.editor.getRawValue():this.__value}setLocalizations(texts){super.setLocalizations(texts),texts.choiceEditor?.comboboxText&&("string"==typeof texts.choiceEditor.comboboxText?(this.__unwatchLocalization("comboboxText"),TcHmi.Binding.createEx2(texts.choiceEditor.comboboxText,"comboboxText",this.__combobox)):(TcHmi.Binding.removeEx2(null,"comboboxText",this.__combobox),this.__watchLocalization("comboboxText",texts.choiceEditor.comboboxText,(text=>this.__combobox.setComboboxText(text)))));for(const editorEntry of this.__editors.values())editorEntry.editor.setLocalizations(texts)}}Helpers.ChoiceEditor=ChoiceEditor}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ObjectEditorPrompt extends Helpers.OkCancelPrompt{constructor(editorInfo,parentControl){super(parentControl),this.__onEditorChanged=editor=>{this.__okButton.setIsEnabled(editor.getState().isValid)},this.__elementHeader.textContent=editorInfo.name,this.__editorPane=new Helpers.ObjectEditorPane(this.__elementContent,editorInfo,parentControl),this.__editorPane.onChange.add(this.__onEditorChanged)}destroy(force=!1){super.destroy(force),this.__editorPane.destroy()}setEditorInfo(editorInfo){this.__editorPane.setEditorInfo(editorInfo)}setValue(value){this.__editorPane.setValue(value)}__ok(){const state=this.__editorPane.getState();state.isValid?this.__prompt?.answer({isOk:!0,value:state.value}):this.__prompt?.error(new Error("Object editor pane contained invalid values."))}setLocalizations(texts){super.setLocalizations(texts),texts.editorLocalizations&&this.__editorPane.setLocalizations(texts.editorLocalizations)}}Helpers.ObjectEditorPrompt=ObjectEditorPrompt}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class ArrayEditorPrompt extends Helpers.OkCancelPrompt{constructor(editorInfo,parentControl){super(parentControl),this.__onEditorChanged=editor=>{this.__okButton.setIsEnabled(editor.getState().isValid)},this.__elementHeader.textContent=editorInfo.name,this.__editorPane=new Helpers.ArrayEditorPane(this.__elementContent,editorInfo,parentControl),this.__editorPane.onChange.add(this.__onEditorChanged)}destroy(force=!1){super.destroy(force),this.__editorPane.destroy()}setEditorInfo(editorInfo){this.__editorPane.setEditorInfo(editorInfo)}setValue(value){this.__editorPane.setValue(value)}__ok(){const state=this.__editorPane.getState();state.isValid?this.__prompt?.answer({isOk:!0,value:state.value}):this.__prompt?.error(new Error("Array editor pane contained invalid values."))}setLocalizations(texts){super.setLocalizations(texts),texts.editorLocalizations&&this.__editorPane.setLocalizations(texts.editorLocalizations)}}Helpers.ArrayEditorPrompt=ArrayEditorPrompt}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Helpers){class TupleEditorPrompt extends Helpers.OkCancelPrompt{constructor(editorInfo,parentControl){super(parentControl),this.__onEditorChanged=editor=>{this.__okButton.setIsEnabled(editor.getState().isValid)},this.__elementHeader.textContent=editorInfo.name,this.__editorPane=new Helpers.TupleEditorPane(this.__elementContent,editorInfo,parentControl),this.__editorPane.onChange.add(this.__onEditorChanged)}destroy(force=!1){super.destroy(force),this.__editorPane.destroy()}setEditorInfo(editorInfo){this.__editorPane.setEditorInfo(editorInfo)}setValue(value){this.__editorPane.setValue(value)}__ok(){const state=this.__editorPane.getState();state.isValid?this.__prompt?.answer({isOk:!0,value:state.value}):this.__prompt?.error(new Error("Tuple editor pane contained invalid values."))}setLocalizations(texts){super.setLocalizations(texts),texts.editorLocalizations&&this.__editorPane.setLocalizations(texts.editorLocalizations)}}Helpers.TupleEditorPrompt=TupleEditorPrompt}(Controls.Helpers||(Controls.Helpers={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={}));