/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import elfman.Consts;
import elfman.ElfReference;
import elfman.Section;
import elfman.SectionHeader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Disasm {
    public static String ndisasm(Section section) throws IOException, InterruptedException {
        DisasmReader dar = Disasm.ndisasmReader(section);
        StringBuilder sb = new StringBuilder();
        char[] buff = new char[1000];
        while (dar.ready()) {
            int r = dar.read(buff);
            sb.append(buff, 0, r);
        }
        return sb.toString();
    }

    private static DisasmReader ndisasmReader(Section section) throws IOException, InterruptedException {
        byte[] code = section.toBytes();
        String off = section.header.sh_addr.toString(16);
        FileOutputStream f = new FileOutputStream(new File(Consts.DISASM_TEMP_FILENAME));
        f.write(code);
        f.close();
        ProcNdisasm pr = new ProcNdisasm(off, section);
        Thread myThread = new Thread(pr);
        myThread.start();
        long time = System.currentTimeMillis();
        while (pr.p == null && System.currentTimeMillis() < time + 500L) {
            Thread.sleep(2L);
        }
        DisasmReader r = new DisasmReader(pr.p);
        time = System.currentTimeMillis();
        while (!r.ready() && System.currentTimeMillis() < time + 500L) {
            Thread.sleep(2L);
        }
        return r;
    }

    public static LinkedList<ElfReference> findUsages(BigInteger address, int size, SectionHeader section) throws IOException, InterruptedException {
        String ndisasm = Disasm.ndisasm(section.section);
        String p = "(0x" + address.toString(16);
        for (int i = 1; i < size; ++i) {
            p = p + "|0x" + address.add(BigInteger.valueOf(i)).toString(16);
        }
        p = p + ")";
        RegExp regex = new RegExp("[0-9A-F]+ +[0-9A-F]+ +[^\n]+" + p + "[^\n0-9a-fA-F]*");
        RunAutomaton automaton = new RunAutomaton(regex.toAutomaton());
        AutomatonMatcher matcher = automaton.newMatcher((CharSequence)ndisasm);
        LinkedList<ElfReference> r = new LinkedList<ElfReference>();
        while (matcher.find()) {
            int instSize;
            BigInteger[] x = new BigInteger[3];
            String[] y = matcher.group().split("   *");
            Matcher nm = Pattern.compile(p).matcher(y[2]);
            if (!nm.find()) continue;
            String q = nm.group().substring(2);
            String qr = new String(q);
            x[1] = new BigInteger(q, 16);
            while (q.length() < 8) {
                q = "0" + q;
            }
            String w = "";
            for (int i = 0; i < q.length(); i += 2) {
                w = q.substring(i, i + 2) + w;
            }
            x[2] = new BigInteger(y[0], 16);
            if (y[2].contains("rel 0x" + qr)) {
                instSize = y[1].length() / 2;
                w = x[1].subtract(x[2]).subtract(BigInteger.valueOf(instSize)).toString(16);
            } else {
                instSize = 0;
            }
            x[0] = BigInteger.valueOf(y[1].toUpperCase().indexOf(w.toUpperCase()) / 2).add(x[2]);
            r.add(new ElfReference(section, x[0], x[1], x[2], instSize, y[2]));
        }
        return r;
    }

    static class DisasmReader
    extends BufferedReader {
        private Process pr;

        public DisasmReader(Reader in) {
            super(in);
        }

        DisasmReader(Process pr) {
            super(new InputStreamReader(pr.getInputStream()));
            this.pr = pr;
        }

        @Override
        public boolean ready() throws IOException {
            try {
                this.pr.exitValue();
                return super.ready();
            }
            catch (IllegalThreadStateException ex) {
                long time = System.currentTimeMillis();
                while (!super.ready() && System.currentTimeMillis() < time + 500L) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException ex1) {
                        Logger.getLogger(DisasmReader.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
                return super.ready();
            }
        }

        @Override
        public void close() throws IOException {
            new File(Consts.DISASM_TEMP_FILENAME).delete();
            super.close();
        }
    }

    private static class ProcNdisasm
    implements Runnable {
        public Process p;
        String off;
        Section section;

        public ProcNdisasm(String off, Section section) {
            this.off = off;
            this.section = section;
        }

        @Override
        public void run() {
            try {
                this.p = Runtime.getRuntime().exec(new String[]{Consts.PATH_TO_NDISASM, Consts.DISASM_TEMP_FILENAME, "-b" + (this.section.header.elf.elfHeader.getEi_class64() ? "64" : "32"), "-o0x" + this.off});
            }
            catch (IOException ex) {
                Logger.getLogger(Disasm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

