/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.DynamicStructure;
import elfman.ElfWriter;
import elfman.Section;
import elfman.SectionHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class DynamicSection
extends Section {
    public LinkedList<DynamicStructure> data;

    public DynamicSection(SectionHeader header, FileInputStream in) throws IOException {
        super(header);
        this.data = new LinkedList();
        do {
            this.data.add(new DynamicStructure(in, header.elf.elfHeader.getEi_class64(), header.elf.elfHeader.ei_dataBigEndian));
        } while (this.data.getLast().d_tag != 0L);
    }

    public DynamicSection(SectionHeader header, LinkedList<DynamicStructure> data) {
        super(header);
        this.data = data;
    }

    @Override
    public byte[] toBytes() {
        byte[] r = new byte[this.data.size() * (this.header.elf.elfHeader.getEi_class64() ? 16 : 8)];
        int o = 0;
        for (DynamicStructure ds : this.data) {
            if (this.header.elf.elfHeader.getEi_class64()) {
                r = ElfWriter.long2sig8(r, o, ds.d_tag, this.header.elf.elfHeader.ei_dataBigEndian);
                r = ElfWriter.big2uns8(r, o + 8, ds.d_un, this.header.elf.elfHeader.ei_dataBigEndian);
                o += 16;
                continue;
            }
            r = ElfWriter.int2sig4(r, o, (int)ds.d_tag, this.header.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, o + 4, ds.d_un, this.header.elf.elfHeader.ei_dataBigEndian);
            o += 8;
        }
        return r;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.data.size() * (this.header.elf.elfHeader.getEi_class64() ? 16 : 8));
    }

    @Override
    public long getSh_type() {
        return 6L;
    }
}

