/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfException;
import elfman.ElfHeader;
import elfman.ElfString;
import elfman.ElfWriter;
import elfman.ProgbitsSection;
import elfman.ProgramHeader;
import elfman.Section;
import elfman.SectionHeader;
import elfman.StrTabSection;
import elfman.Writable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Elf {
    public ElfHeader elfHeader;
    public LinkedList<ProgramHeader> programHeaderTable;
    public LinkedList<SectionHeader> sectionHeaderTable;

    public Elf(ElfHeader elfHeader) {
        this.elfHeader = elfHeader;
        this.programHeaderTable = new LinkedList();
        this.sectionHeaderTable = new LinkedList();
        elfHeader.elf = this;
    }

    public Elf(ElfHeader elfHeader, LinkedList<ProgramHeader> programHeaderTable, LinkedList<SectionHeader> sectionHeaderTable) {
        this.elfHeader = elfHeader;
        this.programHeaderTable = programHeaderTable;
        this.sectionHeaderTable = sectionHeaderTable;
    }

    public void removeSection(int index) {
        boolean a = this.sectionHeaderTable.get(index).getNameFromShstrtab() != null;
        boolean b = a ? this.sectionHeaderTable.get((int)index).name.equals(".shstrtab") : false;
        this.sectionHeaderTable.remove(index);
        this.elfHeader.setE_shnum_auto();
        if (b) {
            this.elfHeader.setE_shstrndx_auto();
        }
        if (a && this.elfHeader.e_shstrndx != 0) {
            try {
                ((StrTabSection)this.sectionHeaderTable.get((int)this.elfHeader.e_shstrndx).section).setStrTabFromSectionNames(false);
            }
            catch (ElfException ex) {
                Logger.getLogger(Elf.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.buildSectionToSegmentMapping();
    }

    public BigInteger addSection(Section section, String name, long sh_type, long sh_flags, BigInteger sh_addr, long sh_link, long sh_info, BigInteger sh_addralign, BigInteger sh_entsize) {
        SectionHeader header;
        BigInteger sh_offset;
        try {
            Section l = this.getLastSection();
            sh_offset = l == null ? BigInteger.valueOf(this.elfHeader.e_ehsize + this.elfHeader.e_phnum * this.elfHeader.e_phentsize) : l.header.sh_offset.add(l.header.sh_size);
        }
        catch (ElfException ex) {
            sh_offset = this.elfHeader.e_phoff.add(BigInteger.valueOf(this.elfHeader.e_phnum * this.elfHeader.e_phentsize));
        }
        section.header = header = new SectionHeader(this, section, sh_type, sh_flags, sh_addr, sh_offset, section.getSize(), sh_link, sh_info, sh_addralign, sh_entsize, name);
        this.sectionHeaderTable.add(header);
        this.elfHeader.setE_shnum_auto();
        if (name != null) {
            try {
                this.buildShStrTab(false);
                if (this.getShStrTab() == this.getLastSection()) {
                    StrTabSection sst = this.getShStrTab();
                    sst.header.sh_offset = sh_offset;
                    header.sh_offset = sh_offset.add(sst.header.sh_size);
                }
            }
            catch (ElfException ex) {
                // empty catch block
            }
        }
        this.elfHeader.setE_shoff_auto();
        this.buildSectionToSegmentMapping();
        return header.sh_offset;
    }

    public void addSection(Section section, String name, BigInteger sh_offset, long sh_type, long sh_flags, BigInteger sh_addr, long sh_link, long sh_info, BigInteger sh_addralign, BigInteger sh_entsize) {
        SectionHeader header;
        section.header = header = new SectionHeader(this, section, sh_type, sh_flags, sh_addr, sh_offset, section.getSize(), sh_link, sh_info, sh_addralign, sh_entsize, name);
        this.sectionHeaderTable.add(header);
        this.elfHeader.setE_shnum_auto();
        if (name != null) {
            try {
                this.buildShStrTab(false);
            }
            catch (ElfException ex) {
                Logger.getLogger(Elf.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.elfHeader.setE_shoff_auto();
        this.buildSectionToSegmentMapping();
    }

    public void addSection(SectionHeader header) {
        String name = header.name;
        BigInteger sh_offset = null;
        try {
            Section l = this.getLastSection();
            if (l == null) {
                sh_offset = BigInteger.valueOf(this.elfHeader.e_ehsize + this.elfHeader.e_phnum * this.elfHeader.e_phentsize);
            } else {
                l.header.sh_offset.add(l.header.sh_size);
            }
        }
        catch (ElfException ex) {
            sh_offset = this.elfHeader.e_phoff.add(BigInteger.valueOf(this.elfHeader.e_phnum * this.elfHeader.e_phentsize));
        }
        header.sh_offset = sh_offset;
        this.sectionHeaderTable.add(header);
        this.elfHeader.setE_shnum_auto();
        if (name != null) {
            try {
                this.buildShStrTab(false);
            }
            catch (ElfException ex) {
                // empty catch block
            }
        }
        this.elfHeader.setE_shoff_auto();
    }

    public void buildSectionToSegmentMapping() {
        if (this.elfHeader.e_phnum > 0 && this.elfHeader.e_shnum > 0) {
            for (ProgramHeader ph : this.programHeaderTable) {
                ph.sections = new LinkedList();
                for (SectionHeader sh : this.sectionHeaderTable) {
                    if (sh.sh_size.compareTo(BigInteger.ZERO) <= 0 || !((sh.sh_flags & 2L) > 0L ? sh.sh_addr.compareTo(ph.p_vaddr) >= 0 && sh.sh_addr.add(sh.sh_size).compareTo(ph.p_vaddr.add(ph.p_memsz)) <= 0 : sh.sh_offset.compareTo(ph.p_offset) >= 0 && sh.sh_offset.add(sh.sh_size).compareTo(ph.p_offset.add(ph.p_filesz)) <= 0)) continue;
                    ph.sections.add(sh);
                }
            }
        }
    }

    public void buildShStrTab(boolean addSectionIfNotExisting) throws ElfException {
        StrTabSection shstrtab = this.getShStrTab();
        if (shstrtab == null) {
            if (!addSectionIfNotExisting) {
                return;
            }
            this.addSection(new StrTabSection(null, new LinkedList<String>()), ".shstrtab", 3L, 0L, BigInteger.ZERO, 0L, 0L, BigInteger.ONE, BigInteger.ZERO);
            this.elfHeader.setE_shstrndx_auto();
            shstrtab = this.getShStrTab();
        }
        shstrtab.setStrTabFromSectionNames(true);
        this.setSectionNamesFromShStrTab();
    }

    public StrTabSection getShStrTab() {
        int sti = this.elfHeader.e_shstrndx;
        if (sti == 0) {
            return null;
        }
        if (sti == 65535) {
            sti = (int)this.sectionHeaderTable.getFirst().sh_link;
        }
        try {
            return (StrTabSection)this.sectionHeaderTable.get((int)sti).section;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public Section getLastSection() throws ElfException {
        if (this.sectionHeaderTable.size() == 0) {
            return null;
        }
        BigInteger max = BigInteger.ZERO;
        Section r = this.sectionHeaderTable.getFirst().section;
        for (SectionHeader sh : this.sectionHeaderTable) {
            BigInteger t = sh.sh_offset.add(sh.sh_size);
            if (t.compareTo(max) <= 0) continue;
            max = t;
            r = sh.section;
        }
        if (this.elfHeader.e_phoff.compareTo(max) > 0) {
            throw new ElfException("Program header table is positioned after the last section");
        }
        return r;
    }

    public Section getLastFreeSection() throws ElfException {
        if (this.sectionHeaderTable.size() == 0) {
            return null;
        }
        BigInteger max = BigInteger.ZERO;
        Section r = this.sectionHeaderTable.getFirst().section;
        for (SectionHeader sh : this.sectionHeaderTable) {
            BigInteger t;
            if (!sh.isPartOfSegment() || (t = sh.sh_offset.add(sh.sh_size)).compareTo(max) <= 0) continue;
            max = t;
            r = sh.section;
        }
        if (this.elfHeader.e_phoff.compareTo(max) > 0) {
            throw new ElfException("Program header table is positioned after the last section");
        }
        return r;
    }

    public LinkedList<ElfString> findStrings(Iterable<SectionHeader> shs, int minLen) {
        LinkedList<ElfString> r = new LinkedList<ElfString>();
        for (SectionHeader sh : shs) {
            if (!(sh.section instanceof ProgbitsSection)) continue;
            r.addAll(((ProgbitsSection)sh.section).findStrings(minLen));
        }
        return r;
    }

    public void setSectionNamesFromShStrTab() {
        for (SectionHeader sh : this.sectionHeaderTable) {
            sh.setNameFromShstrtab();
        }
    }

    public boolean isEmptyFileSpace(BigInteger offset, int size) {
        PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(this);
        BigInteger end = offset.add(BigInteger.valueOf(size - 1));
        while (!pq.isEmpty()) {
            Writable a = pq.poll();
            if (a.offset.compareTo(end) > 0) {
                return true;
            }
            if (a.offset.add(a.size()).compareTo(offset) <= 0 || a.isSectionHeaderTable() || a.isSection() && !((SectionHeader)a.writable).isPartOfSegment()) continue;
            return false;
        }
        return true;
    }

    public boolean hasMemSpace(ProgramHeader ph, int size) {
        BigInteger end = ph.p_vaddr.add(ph.p_memsz).subtract(BigInteger.ONE);
        BigInteger nextPage = end.subtract(end.mod(ph.p_align)).add(ph.p_align);
        end = end.add(BigInteger.valueOf(size));
        for (ProgramHeader iph : this.programHeaderTable) {
            if (iph == ph || (iph.p_type & 1L) != 0L || iph.p_offset.compareTo(end) > 0 || iph.p_offset.add(iph.p_memsz).compareTo(nextPage) < 0) continue;
            return false;
        }
        return true;
    }

    public void rearrangeAllFreeSections() {
        this.rearrangeAllFreeSections(BigInteger.ZERO, BigInteger.ZERO);
    }

    BigInteger nextNotSegmentOffset(BigInteger start, BigInteger size) {
        BigInteger n = start.add(size);
        for (ProgramHeader ph : this.programHeaderTable) {
            if (ph.p_offset.compareTo(n) >= 0 || ph.p_offset.add(ph.p_filesz).compareTo(start) <= 0) continue;
            return this.nextNotSegmentOffset(ph.p_offset.add(ph.p_filesz), size);
        }
        return start;
    }

    public void rearrangeAllFreeSections(BigInteger restrictionStart, BigInteger restrictionEnd) {
        HashSet<SectionHeader> aa = new HashSet<SectionHeader>();
        for (SectionHeader sh : this.sectionHeaderTable) {
            if (sh.isPartOfSegment() || sh.sh_size.equals(BigInteger.ZERO) || sh.sh_type == 8L) continue;
            PriorityQueue<Writable> tq = ElfWriter.generateFileWritables(this);
            BigInteger off = BigInteger.ZERO;
            while (!tq.isEmpty()) {
                if (tq.peek().isSectionHeaderTable() || tq.peek().isSection() && !aa.contains((SectionHeader)tq.peek().writable) && !((SectionHeader)tq.peek().writable).isPartOfSegment()) {
                    tq.poll();
                }
                if (off.compareTo(restrictionEnd) < 0 && off.add(sh.sh_size).compareTo(restrictionStart) >= 0) {
                    off = restrictionEnd;
                }
                off = this.nextNotSegmentOffset(off, sh.sh_size);
                while (!tq.isEmpty() && tq.peek().offset.add(tq.peek().size()).compareTo(off) < 0) {
                    tq.poll();
                }
                if (tq.isEmpty() || tq.peek().offset.compareTo(off.add(sh.sh_size)) > 0) break;
                Writable d = tq.poll();
                off = d.offset.add(d.size());
            }
            sh.sh_offset = off;
            aa.add(sh);
        }
        this.elfHeader.setE_shoff_auto(restrictionStart, restrictionEnd);
    }

    public static Elf createSimpleElf(byte[] code, boolean buildShStrTab) {
        BigInteger entry;
        BigInteger addr = new BigInteger("08048000", 16);
        Elf elf = new Elf(new ElfHeader(null, 2, 3, 1L, addr, BigInteger.ZERO, BigInteger.ZERO, 0L, 0, 0, 0, false, false, 1, 0, 0));
        BigInteger offset = BigInteger.ZERO;
        BigInteger size = BigInteger.valueOf(elf.elfHeader.e_ehsize + code.length + elf.elfHeader.e_phentsize);
        ProgramHeader ph = new ProgramHeader(elf, 1L, offset, addr, addr, size, size, 5L, BigInteger.valueOf(4096L));
        elf.programHeaderTable.add(ph);
        elf.elfHeader.setE_phnum_auto();
        elf.elfHeader.e_phoff = BigInteger.valueOf(elf.elfHeader.e_ehsize);
        offset = size.subtract(BigInteger.valueOf(code.length));
        elf.elfHeader.e_entry = entry = offset.add(addr);
        ProgbitsSection section = new ProgbitsSection(null, code);
        elf.addSection(section, null, offset, section.getSh_type(), 6L, entry, 0L, 0L, BigInteger.ZERO, BigInteger.ZERO);
        if (buildShStrTab) {
            try {
                elf.sectionHeaderTable.getFirst().name = ".text";
                elf.buildShStrTab(true);
            }
            catch (ElfException ex) {
                Logger.getLogger(Elf.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return elf;
    }
}

