/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.Elf;
import elfman.ElfReader;
import elfman.ElfReaderException;
import elfman.ElfWriter;
import elfman.Writable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.PriorityQueue;

public class ElfHeader {
    public Elf elf;
    public int e_type;
    public int e_machine;
    public long e_version;
    public BigInteger e_entry;
    public BigInteger e_phoff;
    public BigInteger e_shoff;
    public long e_flags;
    public int e_ehsize;
    public int e_phentsize;
    public int e_phnum;
    public int e_shentsize;
    public int e_shnum;
    public int e_shstrndx;
    protected boolean ei_class64;
    public boolean ei_dataBigEndian;
    public int ei_version;
    public int ei_osabi;
    public int ei_abiversion;

    public ElfHeader(Elf elf, int e_type, int e_machine, long e_version, BigInteger e_entry, BigInteger e_phoff, BigInteger e_shoff, long e_flags, int e_phnum, int e_shnum, int e_shstrndx, boolean ei_class64, boolean ei_dataBigEndian, int ei_version, int ei_osabi, int ei_abiversion) {
        this.elf = elf;
        this.e_type = e_type;
        this.e_machine = e_machine;
        this.e_version = e_version;
        this.e_entry = e_entry;
        this.e_phoff = e_phoff;
        this.e_shoff = e_shoff;
        this.e_flags = e_flags;
        this.e_phnum = e_phnum;
        this.e_shnum = e_shnum;
        this.e_shstrndx = e_shstrndx;
        this.ei_dataBigEndian = ei_dataBigEndian;
        this.ei_version = ei_version;
        this.ei_osabi = ei_osabi;
        this.ei_abiversion = ei_abiversion;
        this.setEi_class(ei_class64);
    }

    public ElfHeader(InputStream in, Elf elf) throws ElfReaderException, IOException {
        this.elf = elf;
        if (in.read() != 127 || in.read() != 69 || in.read() != 76 || in.read() != 70) {
            throw new ElfReaderException("Invalid ELF magic number");
        }
        int ei_class = in.read();
        if (ei_class == 1) {
            this.ei_class64 = false;
        } else if (ei_class == 2) {
            this.ei_class64 = true;
        } else {
            throw new ElfReaderException("Invalid ELF class");
        }
        byte[] hdr = new byte[(this.ei_class64 ? 64 : 52) - 5];
        if (in.read(hdr, 0, hdr.length) != hdr.length) {
            throw new ElfReaderException("Unexpected end of file");
        }
        if (hdr[0] == 1) {
            this.ei_dataBigEndian = false;
        } else if (hdr[0] == 2) {
            this.ei_dataBigEndian = true;
        } else {
            throw new ElfReaderException("Invalid ELF data encoding");
        }
        this.ei_version = hdr[1];
        this.ei_osabi = hdr[2];
        this.ei_abiversion = hdr[3];
        this.e_type = ElfReader.uns22int(hdr, 11, this.ei_dataBigEndian);
        this.e_machine = ElfReader.uns22int(hdr, 13, this.ei_dataBigEndian);
        this.e_version = ElfReader.uns42long(hdr, 15, this.ei_dataBigEndian);
        if (this.ei_class64) {
            this.e_entry = ElfReader.uns82big(hdr, 19, this.ei_dataBigEndian);
            this.e_phoff = ElfReader.uns82big(hdr, 27, this.ei_dataBigEndian);
            this.e_shoff = ElfReader.uns82big(hdr, 35, this.ei_dataBigEndian);
            this.e_flags = ElfReader.uns42long(hdr, 43, this.ei_dataBigEndian);
            this.e_ehsize = ElfReader.uns22int(hdr, 47, this.ei_dataBigEndian);
            this.e_phentsize = ElfReader.uns22int(hdr, 49, this.ei_dataBigEndian);
            this.e_phnum = ElfReader.uns22int(hdr, 51, this.ei_dataBigEndian);
            this.e_shentsize = ElfReader.uns22int(hdr, 53, this.ei_dataBigEndian);
            this.e_shnum = ElfReader.uns22int(hdr, 55, this.ei_dataBigEndian);
            this.e_shstrndx = ElfReader.uns22int(hdr, 57, this.ei_dataBigEndian);
        } else {
            this.e_entry = ElfReader.uns42big(hdr, 19, this.ei_dataBigEndian);
            this.e_phoff = ElfReader.uns42big(hdr, 23, this.ei_dataBigEndian);
            this.e_shoff = ElfReader.uns42big(hdr, 27, this.ei_dataBigEndian);
            this.e_flags = ElfReader.uns42long(hdr, 31, this.ei_dataBigEndian);
            this.e_ehsize = ElfReader.uns22int(hdr, 35, this.ei_dataBigEndian);
            this.e_phentsize = ElfReader.uns22int(hdr, 37, this.ei_dataBigEndian);
            this.e_phnum = ElfReader.uns22int(hdr, 39, this.ei_dataBigEndian);
            this.e_shentsize = ElfReader.uns22int(hdr, 41, this.ei_dataBigEndian);
            this.e_shnum = ElfReader.uns22int(hdr, 43, this.ei_dataBigEndian);
            this.e_shstrndx = ElfReader.uns22int(hdr, 45, this.ei_dataBigEndian);
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[this.e_ehsize];
        r[0] = 127;
        r[1] = 69;
        r[2] = 76;
        r[3] = 70;
        r[4] = this.ei_class64 ? 2 : 1;
        r[5] = this.ei_dataBigEndian ? 2 : 1;
        r[6] = (byte)this.ei_version;
        r[7] = (byte)this.ei_osabi;
        r[8] = (byte)this.ei_abiversion;
        r = ElfWriter.int2uns2(r, 16, this.e_type, this.ei_dataBigEndian);
        r = ElfWriter.int2uns2(r, 18, this.e_machine, this.ei_dataBigEndian);
        r = ElfWriter.long2uns4(r, 20, this.e_version, this.ei_dataBigEndian);
        if (this.ei_class64) {
            r = ElfWriter.big2uns8(r, 24, this.e_entry, this.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 32, this.e_phoff, this.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 40, this.e_shoff, this.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 48, this.e_flags, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 52, this.e_ehsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 54, this.e_phentsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 56, this.e_phnum, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 58, this.e_shentsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 60, this.e_shnum, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 62, this.e_shstrndx, this.ei_dataBigEndian);
        } else {
            r = ElfWriter.big2uns4(r, 24, this.e_entry, this.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 28, this.e_phoff, this.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 32, this.e_shoff, this.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 36, this.e_flags, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 40, this.e_ehsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 42, this.e_phentsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 44, this.e_phnum, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 46, this.e_shentsize, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 48, this.e_shnum, this.ei_dataBigEndian);
            r = ElfWriter.int2uns2(r, 50, this.e_shstrndx, this.ei_dataBigEndian);
        }
        return r;
    }

    public void setE_shnum_auto() {
        if (this.elf.sectionHeaderTable.size() >= 65280) {
            this.e_shnum = 0;
            this.elf.sectionHeaderTable.getFirst().sh_size = BigInteger.valueOf(this.elf.sectionHeaderTable.size());
        } else {
            this.e_shnum = this.elf.sectionHeaderTable.size();
        }
    }

    public void setE_phnum_auto() {
        this.e_phnum = this.elf.programHeaderTable.size();
    }

    public void setE_shstrndx_auto() {
        int r = 0;
        for (int i = 0; i < this.elf.sectionHeaderTable.size(); ++i) {
            if (!".shstrtab".equals(this.elf.sectionHeaderTable.get((int)i).name)) continue;
            r = i;
            break;
        }
        if (r >= 65280) {
            this.e_shstrndx = 65535;
            this.elf.sectionHeaderTable.getFirst().sh_link = r;
        } else {
            this.e_shstrndx = r;
        }
    }

    public void setE_shoff_auto() {
        PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(this.elf);
        BigInteger off = BigInteger.ZERO;
        BigInteger shtsize = BigInteger.valueOf(this.e_shnum * this.e_shentsize);
        while (!pq.isEmpty()) {
            if (pq.peek().isSectionHeaderTable()) {
                pq.poll();
            }
            off = this.elf.nextNotSegmentOffset(off, shtsize);
            while (!pq.isEmpty() && pq.peek().offset.add(pq.peek().size()).compareTo(off) < 0) {
                pq.poll();
            }
            if (pq.isEmpty() || pq.peek().offset.compareTo(off.add(shtsize)) > 0) break;
            Writable d = pq.poll();
            off = d.offset.add(d.size());
        }
        this.e_shoff = off;
    }

    public void setE_shoff_auto(BigInteger restrictionStart, BigInteger restrictionEnd) {
        PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(this.elf);
        BigInteger off = BigInteger.ZERO;
        BigInteger shtsize = BigInteger.valueOf(this.e_shnum * this.e_shentsize);
        while (!pq.isEmpty()) {
            if (pq.peek().isSectionHeaderTable()) {
                pq.poll();
            }
            if (off.compareTo(restrictionEnd) < 0 && off.add(shtsize).compareTo(restrictionStart) >= 0) {
                off = restrictionEnd;
            }
            off = this.elf.nextNotSegmentOffset(off, shtsize);
            while (!pq.isEmpty() && pq.peek().offset.add(pq.peek().size()).compareTo(off) < 0) {
                pq.poll();
            }
            if (pq.isEmpty() || pq.peek().offset.compareTo(off.add(shtsize)) > 0) break;
            Writable d = pq.poll();
            off = d.offset.add(d.size());
        }
        this.e_shoff = off;
    }

    public void setEi_class(boolean class64) {
        this.ei_class64 = class64;
        if (class64) {
            this.e_ehsize = 64;
            this.e_phentsize = 56;
            this.e_shentsize = 64;
        } else {
            this.e_ehsize = 52;
            this.e_phentsize = 32;
            this.e_shentsize = 40;
        }
    }

    public boolean getEi_class64() {
        return this.ei_class64;
    }
}

