/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.Elf;
import elfman.ElfHeader;
import elfman.ElfReaderException;
import elfman.ProgramHeader;
import elfman.SectionHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class ElfReader {
    public static Elf open(File file) throws FileNotFoundException, IOException, ElfReaderException {
        int i;
        FileInputStream in = new FileInputStream(file);
        Elf elf = new Elf(null, null, null);
        elf.elfHeader = new ElfHeader(in, elf);
        BigInteger readerPosition = BigInteger.valueOf(elf.elfHeader.e_ehsize);
        if (readerPosition.compareTo(elf.elfHeader.e_phoff) > 0) {
            in.close();
            in = new FileInputStream(file);
            readerPosition = BigInteger.ZERO;
        }
        ElfReader.fisSkip(in, elf.elfHeader.e_phoff.subtract(readerPosition));
        readerPosition = elf.elfHeader.e_phoff;
        if (elf.elfHeader.e_phnum > 0) {
            elf.programHeaderTable = new LinkedList();
            for (i = 0; i < elf.elfHeader.e_phnum; ++i) {
                elf.programHeaderTable.add(new ProgramHeader(in, elf));
            }
        }
        readerPosition = readerPosition.add(BigInteger.valueOf(elf.elfHeader.e_phnum * elf.elfHeader.e_phentsize));
        if (elf.elfHeader.e_shoff.compareTo(BigInteger.ZERO) > 0) {
            if (readerPosition.compareTo(elf.elfHeader.e_shoff) > 0) {
                in.close();
                in = new FileInputStream(file);
                readerPosition = BigInteger.ZERO;
            }
            ElfReader.fisSkip(in, elf.elfHeader.e_shoff.subtract(readerPosition));
            readerPosition = elf.elfHeader.e_shoff;
            SectionHeader firstSH = new SectionHeader(in, elf);
            int shnum = elf.elfHeader.e_shnum == 0 ? firstSH.sh_size.intValue() : elf.elfHeader.e_shnum;
            elf.sectionHeaderTable = new LinkedList();
            elf.sectionHeaderTable.add(firstSH);
            for (int i2 = 1; i2 < shnum; ++i2) {
                elf.sectionHeaderTable.add(new SectionHeader(in, elf));
            }
        }
        in.close();
        elf.buildSectionToSegmentMapping();
        elf.sectionHeaderTable.get(elf.elfHeader.e_shstrndx).readSection(file);
        elf.setSectionNamesFromShStrTab();
        for (i = 0; i < elf.sectionHeaderTable.size(); ++i) {
            if (i == elf.elfHeader.e_shstrndx) continue;
            elf.sectionHeaderTable.get(i).readSection(file);
        }
        return elf;
    }

    static void fisSkip(FileInputStream in, BigInteger skip) throws IOException {
        if (skip.testBit(63)) {
            in.skip(Long.MAX_VALUE);
            in.skip(1L);
            skip.clearBit(63);
        }
        in.skip(skip.longValue());
    }

    static int sig42int(byte[] sig4, int offset, boolean bigEndian) {
        return (int)ElfReader.byteArray2Num(sig4, offset, bigEndian, 4);
    }

    static long uns42long(byte[] uns4, int offset, boolean bigEndian) {
        return ElfReader.byteArray2Num(uns4, offset, bigEndian, 4);
    }

    static BigInteger uns42big(byte[] uns4, int offset, boolean bigEndian) {
        return BigInteger.valueOf(ElfReader.uns42long(uns4, offset, bigEndian));
    }

    static long sig82long(byte[] sig8, int offset, boolean bigEndian) {
        return (int)ElfReader.byteArray2Num(sig8, offset, bigEndian, 8);
    }

    static BigInteger uns82big(byte[] sig8, int offset, boolean bigEndian) {
        sig8 = ElfReader.extr8(sig8, offset, !bigEndian);
        return new BigInteger(1, sig8);
    }

    static byte[] extr8(byte[] a, int offset, boolean reverse) {
        byte[] r = new byte[8];
        if (reverse) {
            for (int i = 0; i < 8; ++i) {
                r[i] = a[offset + 7 - i];
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                r[i] = a[offset + i];
            }
        }
        return r;
    }

    static byte[] reverse(byte[] a) {
        byte[] r = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[r.length - i - 1] = a[i];
        }
        return r;
    }

    static int uns22int(byte[] uns2, int offset, boolean bigEndian) {
        return (int)ElfReader.byteArray2Num(uns2, offset, bigEndian, 2);
    }

    static long byteArray2Num(byte[] a, int offset, boolean bigEndian, int len) {
        long r = 0L;
        if (bigEndian) {
            for (int i = 0; i <= len - 1; ++i) {
                r <<= 8;
                r |= (long)(a[offset + i] & 0xFF);
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                r <<= 8;
                r |= (long)(a[offset + i] & 0xFF);
            }
        }
        return r;
    }
}

