/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ProgbitsSection;
import elfman.SectionHeader;
import java.math.BigInteger;

public class ElfString {
    public String string;
    public SectionHeader section;
    public int offset;

    public ElfString(String string, SectionHeader section, int offset) {
        this.string = string;
        this.section = section;
        this.offset = offset;
    }

    public String toString() {
        return this.string;
    }

    public void replaceSimple(String text) {
        ((ProgbitsSection)this.section.section).setString(this.offset, text);
    }

    public void replacePascal(String text) {
        if (text.length() > 255) {
            throw new UnsupportedOperationException("text longer then 255 - not supported");
        }
        if (this.offset < 1) {
            throw new ArrayIndexOutOfBoundsException(this.offset);
        }
        ((ProgbitsSection)this.section.section).data[this.offset - 1] = (byte)text.length();
        System.out.println(text.length());
        ((ProgbitsSection)this.section.section).setString(this.offset, text);
    }

    public BigInteger getAddress() {
        return this.section.sh_addr.add(BigInteger.valueOf(this.offset));
    }
}

