/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.Elf;
import elfman.ElfWriterException;
import elfman.NoBitsSection;
import elfman.NullSection;
import elfman.SectionHeader;
import elfman.Writable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.PriorityQueue;

public class ElfWriter {
    public static void save(Elf elf, File file) throws FileNotFoundException, IOException, ElfWriterException {
        FileOutputStream out = new FileOutputStream(file);
        PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(elf);
        BigInteger writerPosition = BigInteger.ZERO;
        while (!pq.isEmpty()) {
            Writable w = pq.poll();
            switch (w.offset.compareTo(writerPosition)) {
                case -1: {
                    throw new ElfWriterException("Sections overlap!");
                }
                case 1: {
                    ElfWriter.fosWriteNull(out, w.offset.subtract(writerPosition));
                    writerPosition = writerPosition.add(w.offset.subtract(writerPosition));
                }
                case 0: {
                    writerPosition = w.write(out, writerPosition);
                }
            }
        }
        out.close();
    }

    public static PriorityQueue<Writable> generateFileWritables(Elf elf) {
        PriorityQueue<Writable> pq = new PriorityQueue<Writable>();
        pq.add(new Writable(elf.elfHeader));
        if (elf.programHeaderTable != null && elf.programHeaderTable.size() > 0) {
            pq.add(new Writable(elf.programHeaderTable, elf));
        }
        if (elf.sectionHeaderTable == null) {
            return pq;
        }
        for (SectionHeader sh : elf.sectionHeaderTable) {
            if (sh.section.getSize().compareTo(BigInteger.ZERO) <= 0 || sh.section instanceof NoBitsSection || sh.section instanceof NullSection) continue;
            pq.add(new Writable(sh));
        }
        if (elf.sectionHeaderTable.size() > 0) {
            pq.add(new Writable(elf.sectionHeaderTable, elf));
        }
        return pq;
    }

    private static void fosWriteNull(FileOutputStream out, BigInteger num) throws IOException {
        BigInteger maxint = BigInteger.valueOf(Integer.MAX_VALUE);
        if (num.compareTo(maxint) > 0) {
            System.err.println("WARNING: Writer:fosWriteNull: Writing more than MAXINT zeros!");
            while (num.compareTo(maxint) >= 0) {
                out.write(new byte[Integer.MAX_VALUE]);
                num.subtract(maxint);
            }
            BigInteger i = BigInteger.ZERO;
            while (i.compareTo(num) < 0) {
                out.write(0);
                i.add(BigInteger.ONE);
            }
        } else {
            out.write(new byte[num.intValue()]);
        }
    }

    static byte[] int2uns2(byte[] r, int offset, int a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a, bigEndian, 2);
    }

    static byte[] int2sig4(byte[] r, int offset, int a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a, bigEndian, 4);
    }

    static byte[] long2uns4(byte[] r, int offset, long a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a, bigEndian, 4);
    }

    static byte[] big2uns4(byte[] r, int offset, BigInteger a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a.longValue(), bigEndian, 4);
    }

    static byte[] long2sig8(byte[] r, int offset, long a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a, bigEndian, 8);
    }

    static byte[] big2sig8(byte[] r, int offset, BigInteger a, boolean bigEndian) {
        return ElfWriter.num2byteArray(r, offset, a.longValue(), bigEndian, 4);
    }

    static byte[] big2uns8(byte[] r, int offset, BigInteger a, boolean bigEndian) {
        boolean t = a.testBit(63);
        a.clearBit(63);
        r = ElfWriter.num2byteArray(r, offset, a.longValue(), bigEndian, 8);
        if (t) {
            int n = bigEndian ? offset : offset + 7;
            r[n] = (byte)(r[n] | 8);
        }
        return r;
    }

    private static byte[] num2byteArray(byte[] r, int offset, long a, boolean bigEndian, int len) {
        if (bigEndian) {
            for (int i = offset + len - 1; i >= offset; --i) {
                r[i] = (byte)(a & 0xFFL);
                a >>= 8;
            }
        } else {
            for (int i = offset; i < offset + len; ++i) {
                r[i] = (byte)(a & 0xFFL);
                a >>= 8;
            }
        }
        return r;
    }
}

