/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfReader;
import elfman.ElfWriter;
import elfman.Section;
import elfman.SectionHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class NoteSection
extends Section {
    public long namesz;
    public long descsz;
    public long type;
    public byte[] name;
    public byte[] desc;
    private int alignpad;

    public NoteSection(SectionHeader header, FileInputStream in) throws IOException {
        super(header);
        byte[] data = new byte[12];
        boolean be = header.elf.elfHeader.ei_dataBigEndian;
        in.read(data);
        this.namesz = ElfReader.uns42long(data, 0, be);
        this.descsz = ElfReader.uns42long(data, 4, be);
        this.type = ElfReader.uns42long(data, 8, be);
        this.alignpad = header.elf.elfHeader.getEi_class64() ? 8 : 4;
        this.name = new byte[(int)this.namesz];
        in.read(this.name);
        in.skip(this.pad(this.namesz));
        this.desc = new byte[(int)this.descsz];
        in.read(this.desc);
        in.skip(this.pad(this.descsz));
    }

    public NoteSection(SectionHeader header, long namesz, long descsz, long type, byte[] name, byte[] desc) {
        super(header);
        this.namesz = namesz;
        this.descsz = descsz;
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public String name() {
        int i = 0;
        String r = "";
        do {
            r = r + (char)this.name[i++];
        } while (i < this.name.length && this.name[i] != 0);
        return r;
    }

    @Override
    public byte[] toBytes() {
        boolean be = this.header.elf.elfHeader.ei_dataBigEndian;
        byte[] r = new byte[12 + this.name.length + this.pad(this.name.length) + this.desc.length + this.pad(this.desc.length)];
        r = ElfWriter.long2uns4(r, 0, this.namesz, be);
        r = ElfWriter.long2uns4(r, 4, this.descsz, be);
        r = ElfWriter.long2uns4(r, 8, this.type, be);
        System.arraycopy(this.name, 0, r, 12, this.name.length);
        System.arraycopy(this.desc, 0, r, 12 + this.name.length + this.pad(this.name.length), this.desc.length);
        return r;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(12 + this.name.length + this.pad(this.name.length) + this.desc.length + this.pad(this.desc.length));
    }

    @Override
    public long getSh_type() {
        return 7L;
    }

    private int pad(long a) {
        return 0;
    }
}

