/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfException;
import elfman.ElfString;
import elfman.Section;
import elfman.SectionHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProgbitsSection
extends Section {
    public byte[] data;

    public ProgbitsSection(SectionHeader header, FileInputStream in) throws IOException {
        super(header);
        this.data = new byte[header.sh_size.intValue()];
        in.read(this.data);
    }

    public ProgbitsSection(SectionHeader header, byte[] data) {
        super(header);
        this.data = data;
    }

    @Override
    public byte[] toBytes() {
        return this.data;
    }

    public LinkedList<ElfString> findStrings(int minLen) {
        LinkedList<ElfString> r = new LinkedList<ElfString>();
        String t = "";
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= 32 && this.data[i] <= 126 || this.data[i] == 13 || this.data[i] == 10) {
                t = t + "" + (char)this.data[i];
                continue;
            }
            if (this.data[i] == 0 && t.length() >= minLen) {
                r.add(new ElfString(t, this.header, i - t.length()));
                t = "";
                continue;
            }
            t = "";
        }
        return r;
    }

    public void setString(int offset, String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.data[offset + i] = (byte)text.charAt(i);
        }
        this.data[offset + text.length()] = 0;
    }

    public void extendWithString(String text) throws ElfException {
        byte[] newData = new byte[this.data.length + text.length() + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        byte[] string = new byte[text.length()];
        try {
            string = text.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ProgbitsSection.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.arraycopy(string, 0, newData, this.data.length, string.length);
        newData[this.data.length + text.length()] = 0;
        this.data = newData;
        if (this.setSize_auto(false)) {
            byte[] oldData = new byte[this.data.length - text.length() - 1];
            System.arraycopy(this.data, 0, oldData, 0, oldData.length);
            this.data = oldData;
            throw new ElfException("Extending not-last section");
        }
    }

    public void extendWithPascalString(String text) throws ElfException {
        byte[] newData = new byte[this.data.length + text.length() + 2];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        byte[] string = new byte[text.length() + 1];
        string[0] = (byte)text.length();
        try {
            System.arraycopy(text.getBytes("US-ASCII"), 0, string, 1, text.length());
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ProgbitsSection.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.arraycopy(string, 0, newData, this.data.length, string.length);
        newData[this.data.length + text.length()] = 0;
        this.data = newData;
        if (this.setSize_auto(false)) {
            byte[] oldData = new byte[this.data.length - text.length() - 1];
            System.arraycopy(this.data, 0, oldData, 0, oldData.length);
            this.data = oldData;
            throw new ElfException("Extending not-last section");
        }
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.data.length);
    }

    @Override
    public long getSh_type() {
        return 1L;
    }
}

