/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.Elf;
import elfman.ElfException;
import elfman.ElfReader;
import elfman.ElfReaderException;
import elfman.ElfWriter;
import elfman.SectionHeader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.LinkedList;

public class ProgramHeader {
    public Elf elf;
    public LinkedList<SectionHeader> sections;
    public long p_type;
    public BigInteger p_offset;
    public BigInteger p_vaddr;
    public BigInteger p_paddr;
    public BigInteger p_filesz;
    public BigInteger p_memsz;
    public long p_flags;
    public BigInteger p_align;

    public ProgramHeader(Elf elf, long p_type, BigInteger p_offset, BigInteger p_vaddr, BigInteger p_paddr, BigInteger p_filesz, BigInteger p_memsz, long p_flags, BigInteger p_align) {
        this.elf = elf;
        this.p_type = p_type;
        this.p_offset = p_offset;
        this.p_vaddr = p_vaddr;
        this.p_paddr = p_paddr;
        this.p_filesz = p_filesz;
        this.p_memsz = p_memsz;
        this.p_flags = p_flags;
        this.p_align = p_align;
    }

    public ProgramHeader(InputStream in, Elf elf) throws ElfReaderException, IOException {
        this.elf = elf;
        byte[] ph = new byte[elf.elfHeader.e_phentsize];
        if (in.read(ph) != elf.elfHeader.e_phentsize) {
            throw new ElfReaderException("Unexpected end of file while reading a program header");
        }
        this.p_type = ElfReader.uns42long(ph, 0, elf.elfHeader.ei_dataBigEndian);
        if (elf.elfHeader.getEi_class64()) {
            this.p_flags = ElfReader.uns42long(ph, 4, elf.elfHeader.ei_dataBigEndian);
            this.p_offset = ElfReader.uns82big(ph, 8, elf.elfHeader.ei_dataBigEndian);
            this.p_vaddr = ElfReader.uns82big(ph, 16, elf.elfHeader.ei_dataBigEndian);
            this.p_paddr = ElfReader.uns82big(ph, 24, elf.elfHeader.ei_dataBigEndian);
            this.p_filesz = ElfReader.uns82big(ph, 32, elf.elfHeader.ei_dataBigEndian);
            this.p_memsz = ElfReader.uns82big(ph, 40, elf.elfHeader.ei_dataBigEndian);
            this.p_align = ElfReader.uns82big(ph, 48, elf.elfHeader.ei_dataBigEndian);
        } else {
            this.p_offset = ElfReader.uns42big(ph, 4, elf.elfHeader.ei_dataBigEndian);
            this.p_vaddr = ElfReader.uns42big(ph, 8, elf.elfHeader.ei_dataBigEndian);
            this.p_paddr = ElfReader.uns42big(ph, 12, elf.elfHeader.ei_dataBigEndian);
            this.p_filesz = ElfReader.uns42big(ph, 16, elf.elfHeader.ei_dataBigEndian);
            this.p_memsz = ElfReader.uns42big(ph, 20, elf.elfHeader.ei_dataBigEndian);
            this.p_flags = ElfReader.uns42long(ph, 24, elf.elfHeader.ei_dataBigEndian);
            this.p_align = ElfReader.uns42big(ph, 28, elf.elfHeader.ei_dataBigEndian);
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[this.elf.elfHeader.e_phentsize];
        r = ElfWriter.long2uns4(r, 0, this.p_type, this.elf.elfHeader.ei_dataBigEndian);
        if (this.elf.elfHeader.getEi_class64()) {
            r = ElfWriter.long2uns4(r, 4, this.p_flags, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 8, this.p_offset, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 16, this.p_vaddr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 24, this.p_paddr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 32, this.p_filesz, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 40, this.p_memsz, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 48, this.p_align, this.elf.elfHeader.ei_dataBigEndian);
        } else {
            r = ElfWriter.big2uns4(r, 4, this.p_offset, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 8, this.p_vaddr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 12, this.p_paddr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 16, this.p_filesz, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 20, this.p_memsz, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 24, this.p_flags, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 28, this.p_align, this.elf.elfHeader.ei_dataBigEndian);
        }
        return r;
    }

    public void setP_offset(BigInteger p_offset) throws ElfException {
        if (this.p_align.compareTo(BigInteger.ONE) > 0 && this.p_vaddr.mod(this.p_align).compareTo(p_offset.mod(this.p_align)) != 0) {
            throw new ElfException("Invalid p_offset - p_align restriction (p_vaddr should equal p_offset, modulo p_align)");
        }
        this.p_offset = p_offset;
    }

    public void setP_vaddr(BigInteger p_vaddr) throws ElfException {
        if (this.p_align.compareTo(BigInteger.ONE) > 0 && !p_vaddr.mod(this.p_align).equals(this.p_offset.mod(this.p_align))) {
            throw new ElfException("Invalid p_vaddr - p_align restriction (p_vaddr should equal p_offset, modulo p_align)");
        }
        this.p_vaddr = p_vaddr;
    }

    public void extendSize(int n) {
        this.p_filesz = this.p_filesz.add(BigInteger.valueOf(n));
        this.p_memsz = this.p_memsz.add(BigInteger.valueOf(n));
    }

    public boolean isAlignmentOk() {
        if (this.p_align.bitCount() != 1) {
            return false;
        }
        return this.p_align.compareTo(BigInteger.ONE) <= 0 || this.p_vaddr.mod(this.p_align).equals(this.p_offset.mod(this.p_align));
    }
}

