/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.RelocationEntry;
import elfman.Section;
import elfman.SectionHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class RelSection
extends Section {
    public LinkedList<RelocationEntry> entries;
    public boolean withAddend;
    private int entrySize;

    public RelSection(SectionHeader header, FileInputStream in, boolean withAddend) throws IOException {
        super(header);
        this.withAddend = withAddend;
        int n = this.entrySize = header.elf.elfHeader.getEi_class64() ? 16 : 8;
        if (withAddend) {
            this.entrySize += header.elf.elfHeader.getEi_class64() ? 8 : 4;
        }
        int n2 = header.sh_size.divide(BigInteger.valueOf(this.entrySize)).intValue();
        this.entries = new LinkedList();
        for (int i = 0; i < n2; ++i) {
            this.entries.add(new RelocationEntry(this, in, withAddend));
        }
    }

    public RelSection(SectionHeader header, LinkedList<RelocationEntry> entries, boolean withAddend) {
        super(header);
        this.entries = entries;
        this.withAddend = withAddend;
        this.entrySize = header.elf.elfHeader.getEi_class64() ? 16 : 8;
    }

    @Override
    public byte[] toBytes() {
        byte[] r = new byte[this.getSize().intValue()];
        int p = 0;
        for (RelocationEntry e : this.entries) {
            r = e.toBytes(r, p);
            p += this.entrySize;
        }
        return r;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.entries.size()).multiply(BigInteger.valueOf(this.withAddend ? (long)(3 * (this.header.elf.elfHeader.getEi_class64() ? 8 : 4)) : (long)(2 * (this.header.elf.elfHeader.getEi_class64() ? 8 : 4))));
    }

    @Override
    public long getSh_type() {
        return this.withAddend ? 4L : 9L;
    }
}

