/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfHeader;
import elfman.ElfReader;
import elfman.ElfWriter;
import elfman.RelSection;
import elfman.SymTabSection;
import elfman.SymbolTableEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class RelocationEntry {
    public RelSection section;
    public boolean withAddend;
    private ElfHeader elfHeader;
    public BigInteger r_offset;
    public BigInteger r_info;
    public long r_addend;

    public RelocationEntry(RelSection section, FileInputStream in, boolean withAddend) throws IOException {
        int size;
        this.elfHeader = section.header.elf.elfHeader;
        this.section = section;
        this.withAddend = withAddend;
        int n = size = this.elfHeader.getEi_class64() ? 16 : 8;
        if (withAddend) {
            size += this.elfHeader.getEi_class64() ? 8 : 4;
        }
        byte[] data = new byte[size];
        in.read(data);
        if (this.elfHeader.getEi_class64()) {
            this.r_offset = ElfReader.uns82big(data, 0, this.elfHeader.ei_dataBigEndian);
            this.r_info = ElfReader.uns82big(data, 8, this.elfHeader.ei_dataBigEndian);
            if (withAddend) {
                this.r_addend = ElfReader.sig82long(data, 16, this.elfHeader.ei_dataBigEndian);
            }
        } else {
            this.r_offset = ElfReader.uns42big(data, 0, this.elfHeader.ei_dataBigEndian);
            this.r_info = ElfReader.uns42big(data, 4, this.elfHeader.ei_dataBigEndian);
            if (withAddend) {
                this.r_addend = ElfReader.sig42int(data, 8, this.elfHeader.ei_dataBigEndian);
            }
        }
    }

    public RelocationEntry(RelSection section, boolean withAddend, BigInteger r_offset, BigInteger r_info, long r_addend) {
        this.section = section;
        this.withAddend = withAddend;
        this.r_offset = r_offset;
        this.r_info = r_info;
        this.r_addend = r_addend;
        this.elfHeader = section.header.elf.elfHeader;
    }

    public long getSymTabIndex() {
        return this.r_info.shiftRight(this.elfHeader.getEi_class64() ? 32 : 8).longValue();
    }

    public SymbolTableEntry getSymbol() {
        return ((SymTabSection)this.elfHeader.elf.sectionHeaderTable.get((int)((int)this.section.header.sh_link)).section).data.get((int)this.getSymTabIndex());
    }

    public byte[] toBytes(byte[] r, int p) {
        if (this.elfHeader.getEi_class64()) {
            r = ElfWriter.big2uns8(r, p, this.r_offset, this.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, p + 8, this.r_info, this.elfHeader.ei_dataBigEndian);
            if (this.withAddend) {
                r = ElfWriter.long2sig8(r, p + 16, this.r_addend, this.elfHeader.ei_dataBigEndian);
            }
        } else {
            r = ElfWriter.big2uns4(r, p, this.r_offset, this.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, p + 4, this.r_info, this.elfHeader.ei_dataBigEndian);
            if (this.withAddend) {
                r = ElfWriter.int2sig4(r, p + 8, (int)this.r_addend, this.elfHeader.ei_dataBigEndian);
            }
        }
        return r;
    }
}

