/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfWriter;
import elfman.SectionHeader;
import elfman.Writable;
import java.math.BigInteger;
import java.util.PriorityQueue;

public abstract class Section {
    public SectionHeader header;

    protected Section(SectionHeader header) {
        this.header = header;
    }

    public abstract byte[] toBytes();

    public abstract BigInteger getSize();

    public abstract long getSh_type();

    protected boolean setSize_auto(boolean reposition) {
        BigInteger newSize = this.getSize();
        if (this.header.sh_size.equals(newSize)) {
            return false;
        }
        BigInteger newEnd = this.header.sh_offset.add(newSize.subtract(BigInteger.ONE));
        boolean hasEnoughSpace = true;
        if (this.header.sh_size.compareTo(newSize) < 0) {
            hasEnoughSpace = true;
            Writable lastw = null;
            PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(this.header.elf);
            while (!pq.isEmpty()) {
                lastw = pq.poll();
                if (lastw.isSectionHeaderTable() || lastw.writable == this.header || lastw.offset.compareTo(newEnd) > 0 || lastw.offset.add(lastw.size()).compareTo(this.header.sh_offset) <= 0 || lastw.isSection() && !((SectionHeader)lastw.writable).isPartOfSegment()) continue;
                hasEnoughSpace = false;
                break;
            }
            if (!hasEnoughSpace) {
                if (!reposition) {
                    return true;
                }
                while (!pq.isEmpty()) {
                    lastw = pq.poll();
                }
                this.header.sh_offset = lastw.offset.add(lastw.size());
            }
        }
        this.header.sh_size = newSize;
        this.header.elf.rearrangeAllFreeSections();
        return !hasEnoughSpace;
    }
}

