/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.DefaultSection;
import elfman.DynamicSection;
import elfman.Elf;
import elfman.ElfReader;
import elfman.ElfReaderException;
import elfman.ElfWriter;
import elfman.NoBitsSection;
import elfman.NoteSection;
import elfman.NullSection;
import elfman.ProgbitsSection;
import elfman.ProgramHeader;
import elfman.RelSection;
import elfman.Section;
import elfman.StrTabSection;
import elfman.SymTabSection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class SectionHeader {
    public Elf elf;
    public Section section;
    public long sh_name;
    public long sh_type;
    public long sh_flags;
    public BigInteger sh_addr;
    public BigInteger sh_offset;
    public BigInteger sh_size;
    public long sh_link;
    public long sh_info;
    public BigInteger sh_addralign;
    public BigInteger sh_entsize;
    public String name;

    public SectionHeader(Elf elf, Section section, long sh_type, long sh_flags, BigInteger sh_addr, BigInteger sh_offset, BigInteger sh_size, long sh_link, long sh_info, BigInteger sh_addralign, BigInteger sh_entsize, String name) {
        this.elf = elf;
        this.section = section;
        this.sh_type = sh_type;
        this.sh_flags = sh_flags;
        this.sh_addr = sh_addr;
        this.sh_offset = sh_offset;
        this.sh_size = sh_size;
        this.sh_link = sh_link;
        this.sh_info = sh_info;
        this.sh_addralign = sh_addralign;
        this.sh_entsize = sh_entsize;
        this.name = name;
    }

    public SectionHeader(InputStream in, Elf elf) throws ElfReaderException, IOException {
        this.elf = elf;
        byte[] sh = new byte[elf.elfHeader.e_shentsize];
        if (in.read(sh) != elf.elfHeader.e_shentsize) {
            throw new ElfReaderException("Unexpected end of file while reading a section header");
        }
        this.sh_name = ElfReader.uns42long(sh, 0, elf.elfHeader.ei_dataBigEndian);
        this.sh_type = ElfReader.uns42long(sh, 4, elf.elfHeader.ei_dataBigEndian);
        if (elf.elfHeader.getEi_class64()) {
            this.sh_flags = ElfReader.sig82long(sh, 8, elf.elfHeader.ei_dataBigEndian);
            this.sh_addr = ElfReader.uns82big(sh, 16, elf.elfHeader.ei_dataBigEndian);
            this.sh_offset = ElfReader.uns82big(sh, 24, elf.elfHeader.ei_dataBigEndian);
            this.sh_size = ElfReader.uns82big(sh, 32, elf.elfHeader.ei_dataBigEndian);
            this.sh_link = ElfReader.uns42long(sh, 40, elf.elfHeader.ei_dataBigEndian);
            this.sh_info = ElfReader.uns42long(sh, 44, elf.elfHeader.ei_dataBigEndian);
            this.sh_addralign = ElfReader.uns82big(sh, 48, elf.elfHeader.ei_dataBigEndian);
            this.sh_entsize = ElfReader.uns82big(sh, 56, elf.elfHeader.ei_dataBigEndian);
        } else {
            this.sh_flags = ElfReader.uns42long(sh, 8, elf.elfHeader.ei_dataBigEndian);
            this.sh_addr = ElfReader.uns42big(sh, 12, elf.elfHeader.ei_dataBigEndian);
            this.sh_offset = ElfReader.uns42big(sh, 16, elf.elfHeader.ei_dataBigEndian);
            this.sh_size = ElfReader.uns42big(sh, 20, elf.elfHeader.ei_dataBigEndian);
            this.sh_link = ElfReader.uns42long(sh, 24, elf.elfHeader.ei_dataBigEndian);
            this.sh_info = ElfReader.uns42long(sh, 28, elf.elfHeader.ei_dataBigEndian);
            this.sh_addralign = ElfReader.uns42big(sh, 32, elf.elfHeader.ei_dataBigEndian);
            this.sh_entsize = ElfReader.uns42big(sh, 36, elf.elfHeader.ei_dataBigEndian);
        }
        if (this.sh_size.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UnsupportedOperationException("ERROR: sh_size > MAX INT");
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[this.elf.elfHeader.e_shentsize];
        r = ElfWriter.long2uns4(r, 0, this.sh_name, this.elf.elfHeader.ei_dataBigEndian);
        r = ElfWriter.long2uns4(r, 4, this.sh_type, this.elf.elfHeader.ei_dataBigEndian);
        if (this.elf.elfHeader.getEi_class64()) {
            r = ElfWriter.long2sig8(r, 8, this.sh_flags, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 16, this.sh_addr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 24, this.sh_offset, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 32, this.sh_size, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 40, this.sh_link, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 44, this.sh_info, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 48, this.sh_addralign, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns8(r, 56, this.sh_entsize, this.elf.elfHeader.ei_dataBigEndian);
        } else {
            r = ElfWriter.long2uns4(r, 8, this.sh_flags, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 12, this.sh_addr, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 16, this.sh_offset, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 20, this.sh_size, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 24, this.sh_link, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.long2uns4(r, 28, this.sh_info, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 32, this.sh_addralign, this.elf.elfHeader.ei_dataBigEndian);
            r = ElfWriter.big2uns4(r, 36, this.sh_entsize, this.elf.elfHeader.ei_dataBigEndian);
        }
        return r;
    }

    public void readSection(File file) throws FileNotFoundException, IOException {
        FileInputStream in = null;
        switch ((int)this.sh_type) {
            case 0: {
                this.section = new NullSection(this);
                break;
            }
            case 3: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new StrTabSection(this, in);
                break;
            }
            case 8: {
                this.section = new NoBitsSection(this);
                break;
            }
            case 1: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new ProgbitsSection(this, in);
                break;
            }
            case 9: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new RelSection(this, in, false);
                break;
            }
            case 4: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new RelSection(this, in, true);
                break;
            }
            case 6: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new DynamicSection(this, in);
                break;
            }
            case 2: 
            case 11: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new SymTabSection(this, in);
                break;
            }
            case 7: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new NoteSection(this, in);
                break;
            }
            default: {
                in = new FileInputStream(file);
                ElfReader.fisSkip(in, this.sh_offset);
                this.section = new DefaultSection(this, in);
            }
        }
        if (in != null) {
            in.close();
        }
    }

    public String getNameFromShstrtab() {
        StrTabSection shstrtab = this.elf.getShStrTab();
        if (shstrtab == null) {
            return null;
        }
        return shstrtab.stringAt((int)this.sh_name);
    }

    public String toString() {
        if (this.elf == null || this.elf.sectionHeaderTable == null || this.elf.sectionHeaderTable.indexOf(this) < 0) {
            return "";
        }
        String x = "(" + this.elf.sectionHeaderTable.indexOf(this) + ")";
        String y = this.getNameFromShstrtab();
        if (y != null) {
            x = x + " " + y;
        }
        return x;
    }

    public void setNameFromShstrtab() {
        this.name = this.getNameFromShstrtab();
    }

    public boolean isPartOfSegment() {
        BigInteger n = this.sh_offset.add(this.sh_size);
        for (ProgramHeader ph : this.elf.programHeaderTable) {
            if (ph.p_offset.compareTo(n) >= 0 || ph.p_offset.add(ph.p_filesz).compareTo(this.sh_offset) <= 0) continue;
            return true;
        }
        return false;
    }
}

