/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfException;
import elfman.Section;
import elfman.SectionHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StrTabSection
extends Section {
    byte[] strTab;

    public StrTabSection(SectionHeader header, FileInputStream in) throws IOException {
        super(header);
        this.strTab = new byte[header.sh_size.intValue()];
        in.read(this.strTab);
    }

    public StrTabSection(SectionHeader header, LinkedList<String> strings) {
        super(header);
        this.strTab = new byte[0];
        try {
            this.setStrTabFromStrings(strings, true);
        }
        catch (ElfException ex) {
            Logger.getLogger(StrTabSection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String stringAt(int i) {
        if (i == 0 || i > this.strTab.length) {
            return null;
        }
        String r = "";
        do {
            r = r + (char)this.strTab[i++];
        } while (i < this.strTab.length && this.strTab[i] != 0);
        return r;
    }

    public LinkedList<String> getAllStrings() {
        LinkedList<String> r = new LinkedList<String>();
        for (int i = 1; i < this.strTab.length; i += r.getLast().length() + 1) {
            r.add(this.stringAt(i));
        }
        return r;
    }

    @Override
    public byte[] toBytes() {
        return this.strTab;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStrTabFromStrings(Iterable<String> strings, boolean acceptLonger) throws ElfException {
        String r = "\u0000";
        for (String string : strings) {
            r = r + string + '\u0000';
        }
        if (r.length() > this.strTab.length) {
            if (!acceptLonger) throw new ElfException("Input string longer than original");
            this.strTab = new byte[r.length()];
            if (this.header != null) {
                this.setSize_auto(true);
            }
        } else if (this.header != null && r.length() < this.strTab.length) {
            this.setSize_auto(true);
        }
        try {
            this.strTab = r.getBytes("US-ASCII");
            return;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(StrTabSection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setStrTabFromSectionNames(boolean acceptLonger) throws ElfException {
        LinkedList<String> names = new LinkedList<String>();
        for (SectionHeader s : this.header.elf.sectionHeaderTable) {
            if (s.name == null) continue;
            names.add(s.name);
        }
        this.setStrTabFromStrings(names, acceptLonger);
        long p = 1L;
        for (SectionHeader s : this.header.elf.sectionHeaderTable) {
            if (s.name == null) continue;
            s.sh_name = p;
            p += (long)(s.name.length() + 1);
        }
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.strTab.length);
    }

    @Override
    public long getSh_type() {
        return 3L;
    }
}

