/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfWriter;
import elfman.Section;
import elfman.SectionHeader;
import elfman.SymbolTableEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class SymTabSection
extends Section {
    public LinkedList<SymbolTableEntry> data;

    public SymTabSection(SectionHeader header, FileInputStream in) throws IOException {
        super(header);
        int n = header.sh_size.divide(BigInteger.valueOf(header.elf.elfHeader.getEi_class64() ? 24L : 16L)).intValue();
        this.data = new LinkedList();
        for (int i = 0; i < n; ++i) {
            this.data.add(new SymbolTableEntry(in, this));
        }
    }

    public SymTabSection(SectionHeader header, LinkedList<SymbolTableEntry> data) {
        super(header);
        this.data = data;
    }

    @Override
    public byte[] toBytes() {
        byte[] r = new byte[this.data.size() * (this.header.elf.elfHeader.getEi_class64() ? 24 : 16)];
        int o = 0;
        for (SymbolTableEntry ste : this.data) {
            r = ElfWriter.long2uns4(r, o + 0, ste.st_name, this.header.elf.elfHeader.ei_dataBigEndian);
            if (this.header.elf.elfHeader.getEi_class64()) {
                r[o + 4] = (byte)ste.st_info;
                r[o + 5] = (byte)ste.st_other;
                r = ElfWriter.int2uns2(r, o + 6, ste.st_shndx, this.header.elf.elfHeader.ei_dataBigEndian);
                r = ElfWriter.big2uns8(r, o + 8, ste.st_value, this.header.elf.elfHeader.ei_dataBigEndian);
                r = ElfWriter.big2uns8(r, o + 16, ste.st_size, this.header.elf.elfHeader.ei_dataBigEndian);
            } else {
                r = ElfWriter.big2uns4(r, o + 4, ste.st_value, this.header.elf.elfHeader.ei_dataBigEndian);
                r = ElfWriter.big2uns4(r, o + 8, ste.st_size, this.header.elf.elfHeader.ei_dataBigEndian);
                r[o + 12] = (byte)ste.st_info;
                r[o + 13] = (byte)ste.st_other;
                r = ElfWriter.int2uns2(r, o + 14, ste.st_shndx, this.header.elf.elfHeader.ei_dataBigEndian);
            }
            o += this.header.elf.elfHeader.getEi_class64() ? 24 : 16;
        }
        return r;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.data.size()).multiply(BigInteger.valueOf(this.header.elf.elfHeader.getEi_class64() ? 24L : 16L));
    }

    @Override
    public long getSh_type() {
        return 2L;
    }
}

