/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.ElfReader;
import elfman.StrTabSection;
import elfman.SymTabSection;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class SymbolTableEntry {
    public long st_name;
    public BigInteger st_value;
    public BigInteger st_size;
    public int st_info;
    public int st_other;
    public int st_shndx;
    public SymTabSection section;

    public SymbolTableEntry(FileInputStream in, SymTabSection section) throws IOException {
        boolean class64 = section.header.elf.elfHeader.getEi_class64();
        boolean bigEndian = section.header.elf.elfHeader.ei_dataBigEndian;
        this.section = section;
        byte[] data = new byte[class64 ? 24 : 16];
        in.read(data);
        this.st_name = ElfReader.uns42long(data, 0, bigEndian);
        if (class64) {
            this.st_info = data[4];
            this.st_other = data[5];
            this.st_shndx = ElfReader.uns22int(data, 6, bigEndian);
            this.st_value = ElfReader.uns82big(data, 8, bigEndian);
            this.st_size = ElfReader.uns82big(data, 16, bigEndian);
        } else {
            this.st_value = ElfReader.uns42big(data, 4, bigEndian);
            this.st_size = ElfReader.uns42big(data, 8, bigEndian);
            this.st_info = data[12];
            this.st_other = data[13];
            this.st_shndx = ElfReader.uns22int(data, 14, bigEndian);
        }
    }

    public SymbolTableEntry(SymTabSection section, long st_name, BigInteger st_value, BigInteger st_size, int st_info, int st_other, int st_shndx) {
        this.st_name = st_name;
        this.st_value = st_value;
        this.st_size = st_size;
        this.st_info = st_info;
        this.st_other = st_other;
        this.st_shndx = st_shndx;
        this.section = section;
    }

    public int getSt_Bind() {
        return this.st_info >> 4;
    }

    public int getSt_Type() {
        return this.st_info & 0xF;
    }

    public int getSt_Visibility() {
        return this.st_other & 3;
    }

    public String getName() {
        if (this.st_name == 0L) {
            return null;
        }
        try {
            return ((StrTabSection)this.section.header.elf.sectionHeaderTable.get((int)((int)this.section.header.sh_link)).section).stringAt((int)this.st_name);
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            return null;
        }
    }
}

