/*
 * Decompiled with CFR 0.152.
 */
package elfman;

import elfman.Elf;
import elfman.ElfHeader;
import elfman.ProgramHeader;
import elfman.SectionHeader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class Writable
implements Comparable {
    public BigInteger offset;
    public Object writable;

    Writable(SectionHeader sh) {
        this.writable = sh;
        this.offset = sh.sh_offset;
    }

    Writable(ElfHeader eh) {
        this.writable = eh;
        this.offset = BigInteger.ZERO;
    }

    Writable(LinkedList ht, Elf elf) {
        this.writable = ht;
        this.offset = ht.getFirst() instanceof SectionHeader ? elf.elfHeader.e_shoff : elf.elfHeader.e_phoff;
    }

    public BigInteger write(FileOutputStream out, BigInteger writerPosition) throws IOException {
        if (this.writable instanceof SectionHeader) {
            byte[] w = ((SectionHeader)this.writable).section.toBytes();
            if (out != null) {
                out.write(w);
            }
            return writerPosition.add(BigInteger.valueOf(w.length));
        }
        if (this.writable instanceof ElfHeader) {
            byte[] w = ((ElfHeader)this.writable).toBytes();
            if (out != null) {
                out.write(w);
            }
            return writerPosition.add(BigInteger.valueOf(w.length));
        }
        if (((LinkedList)this.writable).getFirst() instanceof SectionHeader) {
            for (SectionHeader sh : (LinkedList)this.writable) {
                byte[] w = sh.toBytes();
                if (out != null) {
                    out.write(w);
                }
                writerPosition = writerPosition.add(BigInteger.valueOf(w.length));
            }
            return writerPosition;
        }
        for (ProgramHeader sh : (LinkedList)this.writable) {
            byte[] w = sh.toBytes();
            if (out != null) {
                out.write(w);
            }
            writerPosition = writerPosition.add(BigInteger.valueOf(w.length));
        }
        return writerPosition;
    }

    public int compareTo(Object o) {
        return this.offset.compareTo(((Writable)o).offset);
    }

    public String toString() {
        if (this.writable instanceof SectionHeader) {
            return this.writable.toString();
        }
        if (this.writable instanceof ElfHeader) {
            return "ELF header";
        }
        if (((LinkedList)this.writable).getFirst() instanceof SectionHeader) {
            return "Section header table";
        }
        return "Program header table";
    }

    public BigInteger size() {
        if (this.writable instanceof SectionHeader) {
            return ((SectionHeader)this.writable).sh_size;
        }
        if (this.writable instanceof ElfHeader) {
            return BigInteger.valueOf(((ElfHeader)this.writable).e_ehsize);
        }
        if (((LinkedList)this.writable).getFirst() instanceof SectionHeader) {
            return BigInteger.valueOf(((SectionHeader)((LinkedList)this.writable).getFirst()).elf.elfHeader.e_shentsize * ((SectionHeader)((LinkedList)this.writable).getFirst()).elf.elfHeader.e_shnum);
        }
        return BigInteger.valueOf(((ProgramHeader)((LinkedList)this.writable).getFirst()).elf.elfHeader.e_phentsize * ((ProgramHeader)((LinkedList)this.writable).getFirst()).elf.elfHeader.e_phnum);
    }

    public boolean isSectionHeaderTable() {
        if (this.writable instanceof SectionHeader) {
            return false;
        }
        if (this.writable instanceof ElfHeader) {
            return false;
        }
        return ((LinkedList)this.writable).getFirst() instanceof SectionHeader;
    }

    public boolean isSection() {
        if (this.writable instanceof SectionHeader) {
            return true;
        }
        if (this.writable instanceof ElfHeader) {
            return false;
        }
        if (((LinkedList)this.writable).getFirst() instanceof SectionHeader) {
            return false;
        }
        return false;
    }

    public boolean isElfHeader() {
        if (this.writable instanceof SectionHeader) {
            return false;
        }
        if (this.writable instanceof ElfHeader) {
            return true;
        }
        if (((LinkedList)this.writable).getFirst() instanceof SectionHeader) {
            return false;
        }
        return false;
    }

    public boolean isProgramHeaderTable() {
        if (this.writable instanceof SectionHeader) {
            return false;
        }
        if (this.writable instanceof ElfHeader) {
            return false;
        }
        return !(((LinkedList)this.writable).getFirst() instanceof SectionHeader);
    }
}

