/*
 * Decompiled with CFR 0.152.
 */
package elfmangui;

import elfman.Disasm;
import elfman.ElfReference;
import elfman.ProgbitsSection;
import elfman.SectionHeader;
import elfmangui.MainFrame;
import elfmangui.NoEditTableModel;
import elfmangui.ReplaceString;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

class FindReferences
extends JFrame {
    private MainFrame parent;
    private BigInteger addt;
    private int length;
    private static final String[] columns = new String[]{"#", "Target address", "Address of instruction", "Instruction", "Relative addressing"};
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    FindReferences(MainFrame parent) {
        this.initComponents();
        this.parent = parent;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton4 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jButton5 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new CardLayout());
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReferences.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Next");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReferences.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("This will search for references to the specified address in the program code.");
        this.jLabel2.setText("Find references to:");
        this.jLabel3.setText("0x");
        this.jLabel4.setText("and the following");
        this.jTextField2.setText("0");
        this.jLabel5.setText("addresses");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 73, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(1, 1, 1).addComponent(this.jTextField1, -2, 118, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextField2, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5))))).addGap(0, 4, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 118, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "card2");
        this.jLabel6.setText("Select sections to search for instructions addressing the selected addresses:");
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        this.jButton4.setText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReferences.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Next");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReferences.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 73, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jButton4))).addComponent(this.jScrollPane2, -1, 219, Short.MAX_VALUE)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "card3");
        this.jLabel7.setText("jLabel4");
        this.jButton5.setText("Close");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReferences.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new NoEditTableModel(new Object[columns.length][1], columns));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 451, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5, -2, 73, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 190, Short.MAX_VALUE).addComponent(this.jButton5)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel3, "card4");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            this.addt = new BigInteger(this.jTextField1.getText(), 16);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "You did not enter a valid address.", "Error", 0);
            return;
        }
        try {
            this.length = this.jTextField2.getText().startsWith("0x") ? Integer.valueOf(this.jTextField2.getText().substring(2), 16).intValue() : Integer.valueOf(this.jTextField2.getText()).intValue();
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "You did not enter a valid length.", "Error", 0);
            return;
        }
        DefaultListModel<SectionHeader> lm = new DefaultListModel<SectionHeader>();
        for (SectionHeader sh : this.parent.elf.sectionHeaderTable) {
            if (!(sh.section instanceof ProgbitsSection)) continue;
            lm.addElement(sh);
        }
        this.jList1.setModel(lm);
        int[] si = new int[lm.size()];
        int o = 0;
        for (int i = 0; i < si.length; ++i) {
            String n = ((SectionHeader)lm.get(i)).getNameFromShstrtab();
            if (n == null || !n.equals(".text") && !n.equals(".init") && !n.equals(".fini")) continue;
            si[o++] = i;
        }
        int[] z = new int[o];
        System.arraycopy(si, 0, z, 0, o);
        this.jList1.setSelectedIndices(z);
        ((CardLayout)this.getContentPane().getLayout()).next(this.getContentPane());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        List shs = this.jList1.getSelectedValuesList();
        LinkedList<ElfReference> refs = new LinkedList<ElfReference>();
        for (SectionHeader sh : shs) {
            try {
                refs.addAll(Disasm.findUsages(this.addt, this.length, sh));
            }
            catch (IOException | InterruptedException ex) {
                Logger.getLogger(ReplaceString.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
        }
        this.jLabel7.setText("There were " + refs.size() + " references found in the selected " + shs.size() + " sections.");
        Object[][] data = new String[refs.size()][columns.length];
        for (int i = 0; i < refs.size(); ++i) {
            ElfReference ref = (ElfReference)refs.get(i);
            data[i][0] = MainFrame.Num2Str(i, 10);
            data[i][2] = "0x" + MainFrame.Num2Str(ref.instAddr, 16);
            data[i][1] = "0x" + MainFrame.Num2Str(ref.tarAddr, 16);
            data[i][3] = ref.instString;
            data[i][4] = ref.relativeAddressing() ? "Yes" : "No";
        }
        this.jTable1.setModel(new NoEditTableModel(data, columns));
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
        this.jTable1.getColumnModel().getColumn(4).setPreferredWidth(15);
        ((CardLayout)this.getContentPane().getLayout()).next(this.getContentPane());
    }
}

