/*
 * Decompiled with CFR 0.152.
 */
package elfmangui;

import elfmangui.MainFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigInteger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

class Hexdump
extends JFrame {
    private byte[] data;
    private int d;
    private BigInteger sb;
    private int nbzn;
    private BigInteger endAddress;
    private static final BigInteger sestnajst = BigInteger.valueOf(16L);
    private JScrollBar jScrollBar1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private JTextField jTextField1;
    private JTextField jTextField2;

    Hexdump() {
        this.initComponents();
    }

    Hexdump(BigInteger startAddress, byte[] data, String label) {
        this.initComponents();
        this.data = data;
        this.jScrollBar1.setMinimum(0);
        this.d = startAddress.mod(BigInteger.valueOf(16L)).intValue();
        this.sb = startAddress.subtract(BigInteger.valueOf(this.d));
        this.jScrollBar1.setMaximum(-25 + (int)Math.ceil(((double)(data.length + this.d) + 0.0) / 16.0));
        if (this.jScrollBar1.getMaximum() < 0) {
            this.jScrollBar1.setMaximum(0);
            this.jScrollBar1.setMinimum(0);
            this.jScrollBar1.setValue(0);
            this.jScrollBar1.setVisible(false);
        }
        this.endAddress = startAddress.add(BigInteger.valueOf(data.length));
        this.nbzn = this.endAddress.toString(16).length();
        this.setTitle(label);
        this.refresh();
    }

    private void refresh() {
        int i;
        int j;
        BigInteger cst = this.sb.add(sestnajst.multiply(BigInteger.valueOf(this.jScrollBar1.getValue())));
        String a = "";
        String b = "";
        String c = "";
        if (this.jScrollBar1.getValue() == 0) {
            j = 0;
            for (i = 0; i < this.d; ++i) {
                a = a + "   ";
                c = c + " ";
            }
        } else {
            j = this.jScrollBar1.getValue() * 16 - this.d;
        }
        for (i = 0; i < 35; ++i) {
            b = b + this.frontSpaces("0x" + MainFrame.Num2Str(cst, 16, this.nbzn), 15) + "\n";
            for (int k = 0; k < 15; ++k) {
                if (j == 0) {
                    k += this.d;
                }
                try {
                    a = a + MainFrame.Num2Str(this.data[j], 16, 2) + " ";
                    c = c + this.ascii(this.data[j++]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    break;
                }
            }
            try {
                a = a + MainFrame.Num2Str(this.data[j], 16, 2) + "\n";
                c = c + this.ascii(this.data[j++]) + "\n";
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            cst = cst.add(sestnajst);
        }
        this.jTextArea1.setText(a);
        this.jTextArea2.setText(b);
        this.jTextArea3.setText(c);
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextArea3 = new JTextArea();
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.jScrollBar1 = new JScrollBar();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                Hexdump.this.formMouseWheelMoved(evt);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setFont(new Font("Monospaced", 0, 12));
        this.jTextField1.setText(" 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F");
        this.jTextField1.setAutoscrolls(false);
        this.jTextField1.setBorder(null);
        this.jTextField1.setFocusable(false);
        this.jTextField2.setEditable(false);
        this.jTextField2.setFont(new Font("Monospaced", 0, 12));
        this.jTextField2.setText("0123456789ABCDEF");
        this.jTextField2.setAutoscrolls(false);
        this.jTextField2.setBorder(null);
        this.jTextField2.setFocusable(false);
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea3.setRows(5);
        this.jTextArea3.setMaximumSize(new Dimension(144, 89));
        this.jTextArea3.setMinimumSize(new Dimension(144, 89));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setMaximumSize(new Dimension(144, 89));
        this.jTextArea1.setMinimumSize(new Dimension(144, 89));
        this.jTextArea2.setBackground(new Color(240, 240, 240));
        this.jTextArea2.setColumns(5);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea2.setRows(5);
        this.jTextArea2.setBorder(null);
        this.jTextArea2.setFocusable(false);
        this.jTextArea2.setMaximumSize(new Dimension(35, 89));
        this.jTextArea2.setMinimumSize(new Dimension(35, 89));
        this.jTextArea2.setPreferredSize(new Dimension(70, 75));
        this.jScrollBar1.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                Hexdump.this.jScrollBar1AdjustmentValueChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jTextArea2, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextArea1, -2, 329, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextArea3, -2, 112, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollBar1, -2, -1, -2).addContainerGap(28, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextArea3, -1, 527, Short.MAX_VALUE).addComponent(this.jTextArea1, -1, 527, Short.MAX_VALUE).addComponent(this.jTextArea2, -1, 527, Short.MAX_VALUE).addComponent(this.jScrollBar1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent evt) {
        this.refresh();
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        if (!this.jScrollBar1.isVisible()) {
            return;
        }
        int r = this.jScrollBar1.getValue() + (evt.getScrollType() == 1 ? 35 : evt.getUnitsToScroll());
        if (r < 0) {
            this.jScrollBar1.setValue(0);
        } else if (r > this.jScrollBar1.getMaximum()) {
            this.jScrollBar1.setValue(this.jScrollBar1.getMaximum());
        } else {
            this.jScrollBar1.setValue(r);
        }
    }

    private char ascii(byte a) {
        char r = (char)a;
        return r < ' ' || r > '~' ? (char)'.' : r;
    }

    private String frontSpaces(String a, int n) {
        while (a.length() < n) {
            a = " " + a;
        }
        return a;
    }
}

