/*
 * Decompiled with CFR 0.152.
 */
package elfmangui;

import elfman.Consts;
import elfman.DynamicSection;
import elfman.Elf;
import elfman.ElfHeader;
import elfman.ElfReader;
import elfman.ElfReaderException;
import elfman.ElfString;
import elfman.ElfWriter;
import elfman.ElfWriterException;
import elfman.NoBitsSection;
import elfman.NoteSection;
import elfman.NullSection;
import elfman.ProgbitsSection;
import elfman.ProgramHeader;
import elfman.RelSection;
import elfman.SectionHeader;
import elfman.StrTabSection;
import elfman.SymTabSection;
import elfman.Writable;
import elfmangui.Disassembly;
import elfmangui.EditHeaderDialog;
import elfmangui.FindReferences;
import elfmangui.Hexdump;
import elfmangui.NewSimpleELF;
import elfmangui.NoEditTableModel;
import elfmangui.ReplaceString;
import elfmangui.SectionEntries;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MainFrame
extends JFrame {
    public Elf elf;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemSave;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    public JTable jTable3;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextPane jTextPane1;
    private JTextPane jTextPane2;
    private static final String[] sectionColumns = new String[]{"#", "Name", "Type", "Address", "Offset", "Size", "Entry size", "Flags", "Link", "Info", "Alignment"};
    private String[] segmentColumns = new String[]{"#", "Type", "Offset", "Virtual address", "Physical address", "File size", "Memory size", "Flags", "Alignment"};
    private static final String[] stringColumns = new String[]{"#", "Section", "Section offset", "File offset", "Address", "String"};
    private LinkedList<SectionHeader> selectedSectionsForStringFinding;
    private int stringMinLen = 2;
    private LinkedList<ElfString> u;
    private String stringContains = "";

    public MainFrame() {
        this.initComponents();
        this.refreshAll();
        this.skrijDodatneGumbe();
    }

    public MainFrame(File elfFile) {
        this.initComponents();
        try {
            this.elf = ElfReader.open(elfFile);
            this.setTitle("ElfMan - " + elfFile.getName());
            this.jLabel29.setText(elfFile.getCanonicalPath());
        }
        catch (ElfReaderException | IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
        this.refreshAll();
        this.skrijDodatneGumbe();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        MainFrame mf = args.length > 0 ? new MainFrame(new File(args[0])) : new MainFrame();
        mf.setVisible(true);
        mf.setExtendedState(mf.getExtendedState() | 6);
    }

    private void skrijDodatneGumbe() {
        this.jButton5.setVisible(false);
        this.jButton6.setVisible(false);
        this.jButton7.setVisible(false);
        this.jButton8.setVisible(false);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel29 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel25 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel11 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel8 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jButton5 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.jTable3 = new JTable();
        this.jPanel8 = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jList1 = new JList();
        this.jTextArea1 = new JTextArea();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane8 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jTextField2 = new JTextField();
        this.jLabel28 = new JLabel();
        this.jButton4 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu3 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuItemExit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("ElfMan");
        this.jLabel29.setText(" ");
        this.jLabel25.setText("jLabel13");
        this.jLabel17.setText("jLabel13");
        this.jLabel10.setText("Data encoding:");
        this.jLabel2.setText("File type:");
        this.jLabel26.setText("File size");
        this.jLabel3.setText("jLabel3");
        this.jLabel4.setText("OS/ABI:");
        this.jLabel11.setText("jLabel11");
        this.jLabel20.setText("Number of program headers:");
        this.jLabel9.setText("jLabel3");
        this.jLabel24.setText("Section header string table index:");
        this.jLabel6.setText("Machine:");
        this.jLabel21.setText("jLabel13");
        this.jLabel16.setText("Section header table offset:");
        this.jLabel15.setText("jLabel13");
        this.jLabel14.setText("Program header table offset:");
        this.jLabel23.setText("jLabel13");
        this.jLabel7.setText("jLabel3");
        this.jLabel19.setText("jLabel13");
        this.jLabel22.setText("Number of section headers:");
        this.jLabel18.setText("Flags:");
        this.jLabel5.setText("jLabel3");
        this.jLabel12.setText("Entry point address:");
        this.jLabel8.setText("Class:");
        this.jLabel13.setText("jLabel13");
        this.jLabel27.setText("jLabel13");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel8).addComponent(this.jLabel10).addComponent(this.jLabel14).addComponent(this.jLabel16).addComponent(this.jLabel18).addComponent(this.jLabel6).addComponent(this.jLabel2).addComponent(this.jLabel20).addComponent(this.jLabel22).addComponent(this.jLabel24).addComponent(this.jLabel12).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel25, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel23, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel17, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel11).addComponent(this.jLabel9).addComponent(this.jLabel7).addComponent(this.jLabel3)))).addComponent(this.jSeparator2)).addGap(185, 185, 185)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel25)).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addComponent(this.jLabel13).addGap(138, 138, 138))).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel24))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27).addComponent(this.jLabel26)).addContainerGap()));
        this.jButton5.setText("Edit");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton5ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel9, -2, -1, -2).addGap(0, 729, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel29, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton5, -2, 79, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel29).addGap(18, 18, 18).addComponent(this.jPanel9, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addGap(211, 211, 211)));
        this.jTabbedPane1.addTab("File info", this.jPanel1);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setFont(new Font("Monospaced", 0, 15));
        this.jTable1.setModel(new NoEditTableModel(new Object[sectionColumns.length][1], sectionColumns));
        this.jTable1.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jTable1.getSelectionModel().addListSelectionListener(new RowListenerSections());
        this.jPanel6.setMaximumSize(new Dimension(321, Short.MAX_VALUE));
        this.jButton1.setText("View hexdump");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("View disassembly");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("View entries");
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jScrollPane5.setMaximumSize(new Dimension(321, Short.MAX_VALUE));
        this.jTextPane2.setEditable(false);
        this.jTextPane2.setDisabledTextColor(UIManager.getDefaults().getColor("FormattedTextField.foreground"));
        this.jTextPane2.setEnabled(false);
        this.jTextPane2.setMaximumSize(new Dimension(321, Integer.MAX_VALUE));
        this.jScrollPane5.setViewportView(this.jTextPane2);
        this.jButton6.setText("Remove");
        this.jButton6.setEnabled(false);
        this.jButton7.setText("Add");
        this.jButton8.setText("Edit");
        this.jButton8.setEnabled(false);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 280, -2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -2, 263, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 935, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 645, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Sections", this.jPanel2);
        this.jTable2.setAutoCreateRowSorter(true);
        this.jTable2.setFont(new Font("Monospaced", 0, 15));
        this.jTable2.setModel(new NoEditTableModel(new Object[this.segmentColumns.length][1], this.segmentColumns));
        this.jTable2.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable2);
        this.jTable2.getSelectionModel().addListSelectionListener(new RowListenerSegments());
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setDisabledTextColor(UIManager.getDefaults().getColor("FormattedTextField.foreground"));
        this.jTextPane1.setEnabled(false);
        this.jScrollPane3.setViewportView(this.jTextPane1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 1002, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 237, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 344, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 645, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Segments", this.jPanel3);
        this.jPanel5.setPreferredSize(new Dimension(0, 0));
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.jScrollPane4.setViewportView(this.jPanel5);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 1245, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 645, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Structure overview", this.jPanel4);
        this.jTable3.setAutoCreateRowSorter(true);
        this.jTable3.setModel(new NoEditTableModel(new Object[stringColumns.length][1], stringColumns));
        this.jTable3.setSelectionMode(0);
        this.jScrollPane6.setViewportView(this.jTable3);
        this.jTable3.getSelectionModel().addListSelectionListener(new RowListenerStrings());
        this.jList1.setFont(new Font("Ubuntu", 0, 13));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MainFrame.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jList1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Select one or more PROGBITS sections to search null-terminated strings in:");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextField1.setText("2");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextField1FocusLost(evt);
            }
        });
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainFrame.this.jTextField1KeyReleased(evt);
            }
        });
        this.jLabel1.setText("Minimal length:");
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setRows(5);
        this.jScrollPane8.setViewportView(this.jTextArea2);
        this.jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextField2FocusLost(evt);
            }
        });
        this.jTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainFrame.this.jTextField2KeyReleased(evt);
            }
        });
        this.jLabel28.setText("Filter:");
        this.jButton4.setText("Replace string");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextArea1, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane8).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane7, -2, 262, -2).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel28, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, GroupLayout.Alignment.TRAILING).addComponent(this.jTextField1, -2, 51, -2)))).addComponent(this.jButton4)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup().addComponent(this.jScrollPane8, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel28)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextArea1, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane7, -2, 267, -2)));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setCursor(null);
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setFont(UIManager.getFont("Label.font"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane6, -1, 971, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel8, -2, -1, -2).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane6)).addContainerGap()));
        this.jTabbedPane1.addTab("Strings", this.jPanel7);
        this.jMenu1.setText("File");
        this.jMenu3.setText("New");
        this.jMenuItem1.setText("Simple ELF file");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenu3);
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setText("Open");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemOpen);
        this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItemSave.setText("Save");
        this.jMenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemSave);
        this.jMenuItemExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuItem2.setText("Find references");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        this.pack();
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setApproveButtonText("Open");
        int result = jfc.showOpenDialog(this);
        if (result == 0) {
            try {
                this.elf = ElfReader.open(jfc.getSelectedFile());
                this.setTitle("ElfMan - " + jfc.getSelectedFile().getName());
                this.jLabel29.setText(jfc.getSelectedFile().getCanonicalPath());
                this.refreshAll();
            }
            catch (ElfReaderException | IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        SectionHeader sh = this.elf.sectionHeaderTable.get(this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow()));
        byte[] data = sh.section.toBytes();
        String n = sh.getNameFromShstrtab();
        if (n == null) {
            n = "";
        }
        n = "(" + sh.elf.sectionHeaderTable.indexOf(sh) + ") " + n;
        n = "Hexdump of section " + n + " (" + data.length + " bytes)";
        new Hexdump(sh.sh_addr, data, n).setVisible(true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        SectionHeader sh = this.elf.sectionHeaderTable.get(this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow()));
        byte[] data = sh.section.toBytes();
        String n = sh.getNameFromShstrtab();
        if (n == null) {
            n = "";
        }
        n = "(" + sh.elf.sectionHeaderTable.indexOf(sh) + ") " + n;
        n = "Disassembly of section " + n + " (" + data.length + " bytes)";
        new Disassembly(sh.sh_addr, sh.section, n).setVisible(true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        SectionHeader sh = this.elf.sectionHeaderTable.get(this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow()));
        String n = sh.getNameFromShstrtab();
        if (n == null) {
            n = "";
        }
        n = "(" + sh.elf.sectionHeaderTable.indexOf(sh) + ") " + n;
        new SectionEntries(sh.section, n).setVisible(true);
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setApproveButtonText("Save");
        int result = jfc.showSaveDialog(this);
        if (result == 0) {
            try {
                ElfWriter.save(this.elf, jfc.getSelectedFile());
                this.setTitle("ElfMan - " + jfc.getSelectedFile().getName());
                this.jLabel29.setText(jfc.getSelectedFile().getCanonicalPath());
            }
            catch (ElfWriterException | IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        new NewSimpleELF(this, true).setVisible(true);
        this.setTitle("ElfMan - Untitled");
        this.jLabel29.setText(" ");
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.stringsUpdateSelectedSections();
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        this.stringMinLenUpdate();
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.stringMinLenUpdate();
        }
    }

    private void jTextField2FocusLost(FocusEvent evt) {
        this.containsFilterUpdate();
    }

    private void jTextField2KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.containsFilterUpdate();
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        new ReplaceString(this).setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        new FindReferences(this).setVisible(true);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        new EditHeaderDialog((Frame)this, true, this.elf.elfHeader).showDialog();
        this.refreshAll();
    }

    public void refreshAll() {
        this.refreshFileInfo();
        this.refreshSections();
        this.refreshSegments();
        this.refreshStructureOverview();
        this.stringsRefreshSelectedSections();
    }

    private void refreshFileInfo() {
        if (this.elf == null) {
            this.jLabel3.setText("");
            this.jLabel5.setText("");
            this.jLabel7.setText("");
            this.jLabel9.setText("");
            this.jLabel11.setText("");
            this.jLabel13.setText("");
            this.jLabel15.setText("");
            this.jLabel17.setText("");
            this.jLabel19.setText("");
            this.jLabel21.setText("");
            this.jLabel23.setText("");
            this.jLabel25.setText("");
        } else {
            this.jLabel3.setText(MainFrame.mapGet((Map)Consts.fileType, this.elf.elfHeader.e_type));
            this.jLabel5.setText(MainFrame.mapGet((Map)Consts.architecture, this.elf.elfHeader.e_machine));
            this.jLabel7.setText(MainFrame.mapGet((Map)Consts.osabi, this.elf.elfHeader.ei_osabi));
            this.jLabel9.setText((String)Consts.class_.get(this.elf.elfHeader.getEi_class64()));
            this.jLabel11.setText((String)Consts.encoding.get(this.elf.elfHeader.ei_dataBigEndian));
            this.jLabel13.setText("0x" + MainFrame.Num2Str(this.elf.elfHeader.e_entry, 16));
            this.jLabel15.setText("0x" + MainFrame.Num2Str(this.elf.elfHeader.e_phoff, 16));
            this.jLabel17.setText("0x" + MainFrame.Num2Str(this.elf.elfHeader.e_shoff, 16));
            this.jLabel19.setText("0x" + MainFrame.Num2Str(this.elf.elfHeader.e_flags, 16));
            this.jLabel21.setText(MainFrame.Num2Str(this.elf.elfHeader.e_phnum, 10));
            this.jLabel23.setText(MainFrame.Num2Str(this.elf.elfHeader.e_shnum >= 65280 ? this.elf.sectionHeaderTable.get((int)0).sh_size.intValue() : this.elf.elfHeader.e_shnum, 10));
            this.jLabel25.setText(MainFrame.Num2Str(this.elf.elfHeader.e_shstrndx, 10));
        }
    }

    private void refreshSections() {
        Object[][] data;
        if (this.elf == null || this.elf.sectionHeaderTable == null) {
            data = new String[0][11];
        } else {
            data = new String[this.elf.sectionHeaderTable.size()][11];
            for (int i = 0; i < this.elf.sectionHeaderTable.size(); ++i) {
                data[i][0] = MainFrame.Num2Str(i, 10);
                data[i][1] = this.elf.sectionHeaderTable.get(i).getNameFromShstrtab();
                data[i][2] = MainFrame.mapGet((Map)Consts.sectionType, (int)this.elf.sectionHeaderTable.get((int)i).sh_type);
                data[i][3] = "0x" + MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_addr, 16);
                data[i][4] = "0x" + MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_offset, 16);
                data[i][5] = "0x" + MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_size, 16);
                data[i][6] = "0x" + MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_entsize, 16);
                data[i][7] = this.shFlags2Str(this.elf.sectionHeaderTable.get((int)i).sh_flags);
                data[i][8] = MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_link, 10);
                data[i][9] = MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_info, 10);
                data[i][10] = "0x" + MainFrame.Num2Str(this.elf.sectionHeaderTable.get((int)i).sh_addralign, 16);
            }
        }
        this.jTable1.setModel(new NoEditTableModel(data, sectionColumns));
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
        this.jTable1.getColumnModel().getColumn(2).setMaxWidth(120);
        this.jTable1.getColumnModel().getColumn(3).setMaxWidth(160);
        this.jTable1.getColumnModel().getColumn(4).setMaxWidth(160);
        this.jTable1.getColumnModel().getColumn(5).setMaxWidth(90);
        this.jTable1.getColumnModel().getColumn(6).setMaxWidth(90);
        this.jTable1.getColumnModel().getColumn(7).setMaxWidth(70);
        this.jTable1.getColumnModel().getColumn(8).setMaxWidth(60);
        this.jTable1.getColumnModel().getColumn(9).setMaxWidth(60);
        this.jTable1.getColumnModel().getColumn(10).setMaxWidth(90);
    }

    private String shFlags2Str(long flags) {
        String r = "";
        r = r + ((flags & 1L) != 0L ? "W" : "");
        r = r + ((flags & 2L) != 0L ? "A" : "");
        r = r + ((flags & 4L) != 0L ? "E" : "");
        r = r + ((flags & 0x10L) != 0L ? "M" : "");
        r = r + ((flags & 0x20L) != 0L ? "S" : "");
        r = r + ((flags & 0x40L) != 0L ? "I" : "");
        r = r + ((flags & 0x80L) != 0L ? "L" : "");
        r = r + ((flags & 0x200L) != 0L ? "G" : "");
        r = r + ((flags & 0x400L) != 0L ? "T" : "");
        r = r + ((flags & 0x100L) != 0L ? "O" : "");
        r = r + ((flags & 0xFF00000L) != 0L ? "o" : "");
        r = r + ((flags & 0xFFFFFFFFF0000000L) != 0L ? "p" : "");
        return r;
    }

    private void refreshSegments() {
        Object[][] data;
        if (this.elf == null || this.elf.programHeaderTable == null) {
            data = new String[0][9];
        } else {
            data = new String[this.elf.programHeaderTable.size()][9];
            for (int i = 0; i < this.elf.programHeaderTable.size(); ++i) {
                data[i][0] = MainFrame.Num2Str(i, 10);
                data[i][1] = MainFrame.mapGet((Map)Consts.segmentType, (int)this.elf.programHeaderTable.get((int)i).p_type);
                data[i][2] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_offset, 16);
                data[i][3] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_vaddr, 16);
                data[i][4] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_paddr, 16);
                data[i][5] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_filesz, 16);
                data[i][6] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_memsz, 16);
                data[i][7] = MainFrame.phFlags2Str(this.elf.programHeaderTable.get((int)i).p_flags);
                data[i][8] = "0x" + MainFrame.Num2Str(this.elf.programHeaderTable.get((int)i).p_align, 16);
                if (this.elf.programHeaderTable.get(i).isAlignmentOk()) continue;
                Object[] objectArray = data[i];
                objectArray[8] = (String)objectArray[8] + "(!)";
            }
        }
        this.jTable2.setModel(new NoEditTableModel(data, this.segmentColumns));
        this.jTable2.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    static String phFlags2Str(long flags) {
        String r = "";
        r = r + ((flags & 4L) != 0L ? "R" : " ");
        r = r + ((flags & 2L) != 0L ? "W" : " ");
        r = r + ((flags & 1L) != 0L ? "X" : " ");
        return r;
    }

    private String secToSegMap(int i) {
        String r = "";
        if (i < 0) {
            return r;
        }
        for (SectionHeader sh : this.elf.programHeaderTable.get((int)i).sections) {
            r = r + "(" + this.elf.sectionHeaderTable.indexOf(sh) + ") ";
            String n = sh.getNameFromShstrtab();
            if (n != null) {
                r = r + n;
            }
            r = r + "\n";
        }
        return r.length() > 1 ? r.substring(0, r.length() - 1) : r;
    }

    private void refreshStructureOverview() {
        int wsize;
        Writable w;
        HashMap<Integer, Integer> omap = new HashMap<Integer, Integer>();
        this.jPanel5.setLayout(null);
        this.jPanel5.removeAll();
        this.jPanel5.repaint();
        if (this.elf == null || this.elf.sectionHeaderTable == null) {
            this.jLabel27.setText("");
            return;
        }
        int off = 0;
        PriorityQueue<Writable> pq = ElfWriter.generateFileWritables(this.elf);
        BigInteger koup = BigInteger.valueOf(-1L);
        while (true) {
            w = pq.poll();
            wsize = w.size().intValue();
            String wname = w.toString();
            GuiSection p = new GuiSection(w.offset, wsize, wname, this.structColor(w), pq.isEmpty(), koup.compareTo(w.offset) >= 0);
            koup = w.offset.add(BigInteger.valueOf(wsize - 1));
            p.setBounds(0, off, 300, p.height());
            if (wname.startsWith("(")) {
                p.setToolTipText("Section " + wname + " (" + wsize + " bytes)");
            } else {
                p.setToolTipText(wname + " (" + wsize + " bytes)");
            }
            this.jPanel5.add(p);
            omap.put(w.offset.intValue(), off);
            omap.put(w.offset.intValue() + wsize - 1, (off += p.height()) - 1);
            if (pq.isEmpty()) break;
            Writable n = pq.peek();
            if (n.offset.compareTo(w.offset.add(BigInteger.valueOf(wsize + 1))) <= 0) continue;
            p = new GuiSection(w.offset.add(BigInteger.valueOf(wsize)), n.offset.subtract(w.offset.add(BigInteger.valueOf(wsize + 1))), " ", Color.WHITE, false, false);
            p.setBounds(0, off, 300, p.height());
            p.setToolTipText("Empty space (" + MainFrame.Num2Str(n.offset.subtract(w.offset.add(BigInteger.valueOf(wsize))), 10) + " bytes)");
            this.jPanel5.add(p);
            omap.put(w.offset.intValue() + wsize, off);
            omap.put(n.offset.intValue() - 1, (off += p.height()) - 1);
        }
        int filesz = w.offset.intValue() + wsize;
        this.jLabel27.setText(MainFrame.Num2Str(filesz, 10) + " bytes");
        int xoff = 300;
        if (this.elf.programHeaderTable != null) {
            for (int i = 0; i < this.elf.programHeaderTable.size(); ++i) {
                ProgramHeader ph = this.elf.programHeaderTable.get(i);
                if (ph.p_filesz.compareTo(BigInteger.ONE) < 0) continue;
                int start = MainFrame.xOmap(ph.p_offset.intValue(), omap);
                int end = MainFrame.xOmap(ph.p_offset.intValue() + ph.p_filesz.intValue(), omap);
                GuiSector p = new GuiSector(i, end - start - 1, ph.p_type == 1L ? Color.GREEN : Color.DARK_GRAY);
                p.setBounds(xoff, start, 30, end - start + 20);
                p.setToolTipText("Segment " + i + ": 0x" + MainFrame.Num2Str(ph.p_offset, 16) + " - 0x" + MainFrame.Num2Str(ph.p_offset.intValue() + ph.p_filesz.intValue() - 1, 16));
                this.jPanel5.add(p);
                xoff += 34;
            }
        }
        this.jPanel5.setPreferredSize(new Dimension(xoff, off + 10));
    }

    private Color structColor(Writable w) {
        if (w.writable instanceof SectionHeader) {
            switch ((int)((SectionHeader)w.writable).sh_type) {
                case 1: {
                    return new Color(26, 219, 21);
                }
                case 3: {
                    return new Color(216, 42, 232);
                }
            }
            if (w.toString() != null && w.toString().startsWith(".")) {
                return new Color(198, 146, 114);
            }
            return new Color(237, 173, 135);
        }
        if (w.writable instanceof ElfHeader) {
            return new Color(169, 225, 60);
        }
        if (((LinkedList)w.writable).getFirst() instanceof SectionHeader) {
            return new Color(96, 209, 229);
        }
        return new Color(225, 215, 60);
    }

    private static int xOmap(int po, HashMap<Integer, Integer> omap) {
        int maxlower = Integer.MIN_VALUE;
        int minhigher = Integer.MAX_VALUE;
        for (int ioff : omap.keySet()) {
            if (ioff == po) {
                maxlower = ioff;
                minhigher = ioff;
                break;
            }
            if (ioff < po && ioff > maxlower) {
                maxlower = ioff;
                continue;
            }
            if (ioff <= po || ioff >= minhigher) continue;
            minhigher = ioff;
        }
        if (maxlower == Integer.MIN_VALUE) {
            maxlower = Integer.MAX_VALUE;
            for (int ioff : omap.keySet()) {
                if (ioff >= maxlower) continue;
                maxlower = ioff;
            }
        }
        if (minhigher == Integer.MAX_VALUE) {
            minhigher = Integer.MIN_VALUE;
            for (int ioff : omap.keySet()) {
                if (ioff <= minhigher) continue;
                minhigher = ioff;
            }
        }
        if (maxlower == minhigher) {
            Integer r = omap.get(po);
            if (r == null) {
                r = omap.get(minhigher);
            }
            if (r == null) {
                r = omap.get(maxlower);
            }
            return r;
        }
        return (int)((double)omap.get(maxlower).intValue() + ((double)(po - maxlower) + 0.0) / (double)(minhigher - maxlower) * (double)(omap.get(minhigher) - omap.get(maxlower)));
    }

    private void stringsRefreshSelectedSections() {
        if (this.elf == null || this.elf.sectionHeaderTable == null) {
            this.jList1.setModel(new DefaultListModel());
        } else {
            String n;
            int i;
            DefaultListModel<SectionHeader> lm = new DefaultListModel<SectionHeader>();
            for (SectionHeader sh : this.elf.sectionHeaderTable) {
                if (!(sh.section instanceof ProgbitsSection)) continue;
                lm.addElement(sh);
            }
            this.jList1.setModel(lm);
            int[] si = new int[lm.size()];
            int o = 0;
            for (i = 0; i < si.length; ++i) {
                n = ((SectionHeader)lm.get(i)).getNameFromShstrtab();
                if (n == null || !n.startsWith("elfman.newstrings") && !n.equals(".rodata") && !n.equals(".rodata1") && !n.equals(".data") && !n.equals(".data1")) continue;
                si[o++] = i;
            }
            if (o == 0) {
                for (i = 0; i < si.length; ++i) {
                    n = ((SectionHeader)lm.get(i)).getNameFromShstrtab();
                    if (n == null || !n.equals(".text")) continue;
                    si[o++] = i;
                }
            }
            int[] z = new int[o];
            System.arraycopy(si, 0, z, 0, o);
            this.jList1.setSelectedIndices(z);
        }
        this.stringsUpdateSelectedSections();
        this.printStrings();
    }

    private void stringsUpdateSelectedSections() {
        this.selectedSectionsForStringFinding = new LinkedList();
        for (Object sh : this.jList1.getSelectedValuesList()) {
            this.selectedSectionsForStringFinding.add((SectionHeader)sh);
        }
        this.printStrings();
    }

    private void printStrings() {
        Object[][] data;
        if (this.elf == null || this.elf.programHeaderTable == null) {
            data = new String[0][9];
        } else {
            int i;
            this.u = this.elf.findStrings(this.selectedSectionsForStringFinding, this.stringMinLen);
            for (i = 0; i < this.u.size(); ++i) {
                if ("".equals(this.stringContains) || this.u.get((int)i).string.contains(this.stringContains)) continue;
                this.u.remove(i--);
            }
            data = new Object[this.u.size()][6];
            for (i = 0; i < this.u.size(); ++i) {
                ElfString si = this.u.get(i);
                data[i][0] = MainFrame.Num2Str(i, 10);
                data[i][1] = "(" + this.elf.sectionHeaderTable.indexOf(si.section) + ") " + si.section.getNameFromShstrtab();
                data[i][2] = "0x" + MainFrame.Num2Str(si.offset, 16);
                data[i][3] = "0x" + MainFrame.Num2Str(si.section.sh_offset.add(BigInteger.valueOf(si.offset)), 16);
                data[i][4] = "0x" + MainFrame.Num2Str(si.getAddress(), 16);
                data[i][5] = si;
            }
        }
        this.jTable3.setModel(new NoEditTableModel(data, stringColumns));
        this.jTable3.getColumnModel().getColumn(0).setMaxWidth(45);
        this.jTable3.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.jTable3.getColumnModel().getColumn(1).setMaxWidth(350);
        this.jTable3.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable3.getColumnModel().getColumn(2).setMaxWidth(120);
        this.jTable3.getColumnModel().getColumn(3).setMaxWidth(120);
        this.jTable3.getColumnModel().getColumn(4).setMaxWidth(150);
    }

    private void stringMinLenUpdate() {
        this.jTextField1.setText(this.jTextField1.getText().replaceAll("[^0-9]", ""));
        if (this.jTextField1.getText().length() < 1 || Integer.parseInt(this.jTextField1.getText()) < 1) {
            this.jTextField1.setText("" + this.stringMinLen);
        }
        this.stringMinLen = Integer.parseInt(this.jTextField1.getText());
        this.printStrings();
    }

    private void containsFilterUpdate() {
        this.stringContains = this.jTextField2.getText();
        this.printStrings();
    }

    static String Num2Str(Number n, int radix) {
        if (n instanceof BigInteger) {
            return ((BigInteger)n).toString(radix).toUpperCase();
        }
        if (n instanceof Integer) {
            return Integer.toString((Integer)n, radix).toUpperCase();
        }
        if (n instanceof Long) {
            return Long.toString((Long)n, radix);
        }
        byte[] b = new byte[]{(Byte)n};
        return new BigInteger(1, b).toString(16).toUpperCase();
    }

    static String Num2Str(Number n, int radix, int len) {
        String r = MainFrame.Num2Str(n, radix);
        while (r.length() < len) {
            r = "0" + r;
        }
        return r;
    }

    static String mapGet(Map f, int key) {
        String r = (String)f.get(key);
        if (r == null) {
            return "0x" + MainFrame.Num2Str(key, 16);
        }
        return r;
    }

    static String mapGet(Map f, Object key) {
        return (String)f.get(key);
    }

    private class RowListenerStrings
    implements ListSelectionListener {
        private RowListenerStrings() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (MainFrame.this.jTable3.getSelectedRow() < 0) {
                return;
            }
            MainFrame.this.jTextArea2.setText(MainFrame.this.jTable3.getModel().getValueAt(MainFrame.this.jTable3.convertRowIndexToModel(MainFrame.this.jTable3.getSelectedRow()), 5).toString());
        }
    }

    private static class GuiSection
    extends JComponent {
        private static final int rectWidth = 200;
        private static final int rectX = 84;
        private static final int minsize = 34;
        private int offset;
        private int size;
        private String name;
        private Color color;
        private int drawEnd;
        private boolean overlapping;
        private static Font b = new Font("Monospaced", 1, 13);
        private static Font n = new Font("Monospaced", 0, 13);

        GuiSection(Number offset, Number size, String name, Color color, boolean drawEnd, boolean overlapping) {
            this.offset = GuiSection.Num2Int(offset);
            int n = this.size = GuiSection.Num2Int(size) >= 34 ? GuiSection.Num2Int(size) : 34;
            if (this.size > 1200) {
                this.size = 1220;
            }
            this.name = name;
            this.color = color;
            this.drawEnd = drawEnd ? GuiSection.Num2Int(offset) + GuiSection.Num2Int(size) - 1 : -1;
            this.overlapping = overlapping;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.overlapping ? Color.RED : Color.BLACK);
            g.setFont(n);
            g.drawString("0x" + MainFrame.Num2Str(this.offset, 16, 8), 0, 10);
            g.setColor(this.color);
            g.fillRect(84, 0, 200, GuiSection.Num2Int(this.size) / 2);
            g.setColor(Color.BLACK);
            g.drawLine(84, 0, 283, 0);
            if (this.size == 1220) {
                g.drawLine(83, 450, 103, 430);
                g.drawLine(103, 430, 123, 450);
                g.drawLine(123, 450, 143, 430);
                g.drawLine(143, 430, 163, 450);
                g.drawLine(163, 450, 183, 430);
                g.drawLine(183, 430, 203, 450);
                g.drawLine(203, 450, 223, 430);
                g.drawLine(223, 430, 243, 450);
                g.drawLine(243, 450, 263, 430);
                g.drawLine(263, 430, 283, 450);
                g.drawLine(83, 460, 103, 440);
                g.drawLine(103, 440, 123, 460);
                g.drawLine(123, 460, 143, 440);
                g.drawLine(143, 440, 163, 460);
                g.drawLine(163, 460, 183, 440);
                g.drawLine(183, 440, 203, 460);
                g.drawLine(203, 460, 223, 440);
                g.drawLine(223, 440, 243, 460);
                g.drawLine(243, 460, 263, 440);
                g.drawLine(263, 440, 283, 460);
            }
            int stringLen = (int)g.getFontMetrics().getStringBounds(this.name, g).getWidth();
            int startX = 100 - stringLen / 2;
            int stringHei = (int)g.getFontMetrics().getStringBounds(this.name, g).getHeight();
            int startY = GuiSection.Num2Int(this.size) / 4 + stringHei / 2;
            if (this.name.startsWith("(")) {
                g.setFont(n);
            } else {
                g.setFont(b);
            }
            g.drawString(this.name, startX + 84, GuiSection.Num2Int(this.size) == 34 ? startY - 2 : startY);
            if (this.drawEnd > 0) {
                g.setFont(n);
                g.drawString("0x" + MainFrame.Num2Str(this.drawEnd, 16, 8), 0, this.height());
            }
        }

        int height() {
            return GuiSection.Num2Int(this.size) / 2;
        }

        private static int Num2Int(Number n) {
            if (n instanceof BigInteger) {
                return ((BigInteger)n).intValue();
            }
            return (Integer)n;
        }
    }

    private static class GuiSector
    extends JComponent {
        private static final int width = 30;
        private int i;
        private int size;
        private Color color;

        private GuiSector(int i, int size, Color color) {
            this.i = i;
            this.size = size;
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            int stringHei = (int)g.getFontMetrics().getStringBounds("" + this.i, g).getHeight();
            int stringWid = (int)g.getFontMetrics().getStringBounds("" + this.i, g).getWidth();
            g.setColor(this.color);
            g.fillRect(0, 0, 30, 2);
            g.fillRect(28, 0, 2, this.size);
            g.fillRect(0, this.size - 2, 30, 2);
            g.setColor(Color.BLACK);
            if (this.size > 20) {
                g.drawString("" + this.i, 5, stringHei + 2);
            } else {
                g.drawString("" + this.i, 5, stringHei + this.size);
            }
        }
    }

    private class RowListenerSections
    implements ListSelectionListener {
        private RowListenerSections() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (MainFrame.this.jTable1.getSelectedRow() < 0) {
                MainFrame.this.jButton1.setEnabled(false);
                MainFrame.this.jButton2.setEnabled(false);
                MainFrame.this.jButton3.setEnabled(false);
                MainFrame.this.jButton6.setEnabled(false);
                MainFrame.this.jButton8.setEnabled(false);
                return;
            }
            MainFrame.this.jButton6.setEnabled(true);
            MainFrame.this.jButton8.setEnabled(true);
            SectionHeader sh = MainFrame.this.elf.sectionHeaderTable.get(MainFrame.this.jTable1.convertRowIndexToModel(MainFrame.this.jTable1.getSelectedRow()));
            if (!(sh.section instanceof NoBitsSection) && !(sh.section instanceof NullSection)) {
                MainFrame.this.jButton1.setEnabled(true);
                MainFrame.this.jButton2.setEnabled(true);
            } else {
                MainFrame.this.jButton1.setEnabled(false);
                MainFrame.this.jButton2.setEnabled(false);
            }
            if (sh.section instanceof StrTabSection | sh.section instanceof DynamicSection | sh.section instanceof RelSection | sh.section instanceof SymTabSection) {
                MainFrame.this.jButton3.setEnabled(true);
            } else {
                MainFrame.this.jButton3.setEnabled(false);
            }
            if (sh.section instanceof NoteSection) {
                NoteSection t = (NoteSection)sh.section;
                String p = "Notes:\nOwner: " + t.name() + "\nData size: 0x" + MainFrame.Num2Str(t.descsz, 16) + "\nType: 0x" + MainFrame.Num2Str(t.type, 16) + "\nData:\n";
                for (int i = 0; i < t.desc.length; ++i) {
                    p = p + MainFrame.Num2Str(t.desc[i], 16, 2) + " " + (i > 0 && (i + 1) % 4 == 0 ? "\n" : "");
                }
                MainFrame.this.jTextPane2.setText(p.substring(0, p.length() - 1));
                MainFrame.this.jTextPane2.setCaretPosition(0);
            } else {
                MainFrame.this.jTextPane2.setText(Consts.specialSectionNames.get(sh.getNameFromShstrtab()));
            }
        }
    }

    private class RowListenerSegments
    implements ListSelectionListener {
        private RowListenerSegments() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (MainFrame.this.jTable2.getSelectedRow() < 0) {
                return;
            }
            MainFrame.this.jTextPane1.setText("Section to segment mapping:\n" + MainFrame.this.secToSegMap(MainFrame.this.jTable2.convertRowIndexToModel(MainFrame.this.jTable2.getSelectedRow())));
            MainFrame.this.jTextPane1.setCaretPosition(0);
        }
    }
}

