/*
 * Decompiled with CFR 0.152.
 */
package elfmangui;

import elfman.Consts;
import elfman.Disasm;
import elfman.Elf;
import elfman.ElfException;
import elfman.ElfReference;
import elfman.ElfString;
import elfman.ProgbitsSection;
import elfman.ProgramHeader;
import elfman.Section;
import elfman.SectionHeader;
import elfman.StrTabSection;
import elfmangui.MainFrame;
import elfmangui.NoEditTableModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

class ReplaceString
extends JDialog {
    public static final String NEWSTRINGS_SECTION_NAME = "elfman.newstrings";
    private static boolean pascalMode = false;
    private int stringLength;
    private MainFrame parent;
    private ElfString si;
    private String newSectionName;
    private ProgramHeader phToReplace;
    private Elf elf;
    private boolean ozp = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTable jTable1;
    private JTextArea jTextArea1;

    ReplaceString(MainFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        String label = "Section: " + (String)this.parent.jTable3.getModel().getValueAt(this.parent.jTable3.getSelectedRow(), 1) + ", file offset: " + (String)this.parent.jTable3.getModel().getValueAt(this.parent.jTable3.getSelectedRow(), 3) + ", address: " + (String)this.parent.jTable3.getModel().getValueAt(this.parent.jTable3.getSelectedRow(), 4);
        this.si = (ElfString)this.parent.jTable3.getModel().getValueAt(this.parent.jTable3.getSelectedRow(), 5);
        this.elf = this.si.section.elf;
        this.stringLength = this.si.toString().length();
        this.initComponents();
        this.jCheckBox2.setVisible(this.jCheckBox1.isSelected());
        this.jLabel1.setText(label);
        this.jTextArea1.setText(this.si.toString());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jList2 = new JList();
        this.jLabel5 = new JLabel();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jLabel8 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Replace string");
        this.setModal(true);
        this.getContentPane().setLayout(new CardLayout());
        this.jPanel1.setMinimumSize(new Dimension(485, 296));
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Next");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("Input new text:");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jCheckBox1.setSelected(pascalMode);
        this.jCheckBox1.setText("Pascal string mode");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("Ignore first character");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("Extend writable segments also");
        this.jCheckBox3.setToolTipText("If selected, also segments that have the writable flag set, can be chosen to be extended by the new string (program could write over the string).");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 98, Short.MAX_VALUE).addComponent(this.jButton1, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 73, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jCheckBox3)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 233, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "card2");
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        this.jButton3.setText("Next");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Select sections to search for instructions addressing the selected string:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 73, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 92, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jButton4))).addComponent(this.jScrollPane2, -1, 321, Short.MAX_VALUE)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "card3");
        this.jLabel4.setText("jLabel4");
        this.jList2.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.jList2);
        this.jLabel5.setText("Select references to be changed:");
        this.jButton5.setText("Cancel");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton6.setText("Next");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton6ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6, -2, 73, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addGap(0, 359, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton6).addComponent(this.jButton5))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 298, Short.MAX_VALUE))).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel3, "card4");
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.jTable1);
        this.jTable1.getSelectionModel().addListSelectionListener(new RowListener());
        this.jLabel6.setText("Select a program header to be replaced or click skip to skip this step:");
        this.jLabel7.setText("A program header must be replaced with a new one that will contain the new section.");
        this.jButton7.setText("Cancel");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton8.setText("Next");
        this.jButton8.setEnabled(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButton9.setText("Skip");
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceString.this.jButton9ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("If you click skip, the new string section may not be loaded into memory.");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton8, -1, 73, Short.MAX_VALUE).addComponent(this.jButton9, -1, -1, Short.MAX_VALUE))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 211, Short.MAX_VALUE).addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton8).addComponent(this.jButton7))).addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel4, "card5");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected() && this.jTextArea1.getText().length() > 255) {
            JOptionPane.showMessageDialog(this, "Pascal type strings are supported only if not longer than 255", "Error", 0);
            return;
        }
        if (this.jTextArea1.getText().length() <= this.stringLength && JOptionPane.showConfirmDialog(this, "The new string is not longer than the old one. Do you want the original to be overwritten?", "Replace string in-place", 0, 3) == 0) {
            if (!this.jCheckBox1.isSelected()) {
                this.si.replaceSimple(this.jTextArea1.getText());
            } else {
                this.si.replacePascal(this.jTextArea1.getText());
            }
            this.parent.refreshAll();
            this.dispose();
            return;
        }
        DefaultListModel<SectionHeader> lm = new DefaultListModel<SectionHeader>();
        for (SectionHeader sh : this.elf.sectionHeaderTable) {
            if (!(sh.section instanceof ProgbitsSection)) continue;
            lm.addElement(sh);
        }
        this.jList1.setModel(lm);
        int[] si = new int[lm.size()];
        int o = 0;
        for (int i = 0; i < si.length; ++i) {
            String n = ((SectionHeader)lm.get(i)).getNameFromShstrtab();
            if (n == null || !n.equals(".text") && !n.equals(".init") && !n.equals(".fini")) continue;
            si[o++] = i;
        }
        int[] z = new int[o];
        System.arraycopy(si, 0, z, 0, o);
        this.jList1.setSelectedIndices(z);
        ((CardLayout)this.getContentPane().getLayout()).next(this.getContentPane());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        List shs = this.jList1.getSelectedValuesList();
        LinkedList<ElfReference> refs = new LinkedList<ElfReference>();
        for (SectionHeader sh : shs) {
            try {
                if (!this.jCheckBox1.isSelected()) {
                    refs.addAll(Disasm.findUsages(this.si.getAddress(), this.si.toString().length(), sh));
                    continue;
                }
                refs.addAll(Disasm.findUsages(this.si.getAddress().subtract(BigInteger.ONE), 0, sh));
            }
            catch (IOException | InterruptedException ex) {
                Logger.getLogger(ReplaceString.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
        }
        this.jLabel4.setText("There were " + refs.size() + " references found in the selected " + shs.size() + " sections.");
        DefaultListModel<ElfReference> lm = new DefaultListModel<ElfReference>();
        for (ElfReference ref : refs) {
            lm.addElement(ref);
        }
        this.jList2.setModel(lm);
        this.jList2.setSelectionInterval(0, refs.size() - 1);
        ((CardLayout)this.getContentPane().getLayout()).next(this.getContentPane());
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        LinkedList<SectionHeader> lnssh = new LinkedList<SectionHeader>();
        for (SectionHeader sh : this.elf.sectionHeaderTable) {
            if (!(sh.section instanceof ProgbitsSection) || !sh.getNameFromShstrtab().startsWith(NEWSTRINGS_SECTION_NAME)) continue;
            lnssh.add(sh);
        }
        String mnssh = lnssh.isEmpty() ? null : ((SectionHeader)lnssh.getLast()).getNameFromShstrtab().replace(NEWSTRINGS_SECTION_NAME, "");
        int len = this.jTextArea1.getText().length() + (this.jCheckBox1.isSelected() ? 2 : 1);
        while (!lnssh.isEmpty()) {
            SectionHeader nssh = (SectionHeader)lnssh.removeFirst();
            BigInteger oldEndOff = nssh.sh_offset.add(nssh.sh_size);
            ProgramHeader tph = null;
            for (ProgramHeader ph : this.elf.programHeaderTable) {
                if (ph.p_type != 1L || !ph.p_offset.add(ph.p_filesz).equals(oldEndOff)) continue;
                tph = ph;
                break;
            }
            if (tph == null || !this.elf.hasMemSpace(tph, len) || !this.elf.isEmptyFileSpace(nssh.sh_offset.add(nssh.sh_size), len) || JOptionPane.showConfirmDialog(this, "Do you want to extend the existing " + nssh.toString() + " section? If you choose NO, a new section will be constructed.", "String replace - confirm", 0) != 0) continue;
            try {
                if (!this.jCheckBox1.isSelected()) {
                    ((ProgbitsSection)nssh.section).extendWithString(this.jTextArea1.getText());
                } else {
                    ((ProgbitsSection)nssh.section).extendWithPascalString(this.jTextArea1.getText());
                }
                tph.extendSize(len);
                this.replaceReferences(nssh.sh_addr.add(nssh.sh_size).subtract(BigInteger.valueOf(len)));
                this.parent.refreshAll();
                this.dispose();
                return;
            }
            catch (ElfException ex) {
                throw new RuntimeException("the section could not be extended even though it should have space");
            }
        }
        this.newSectionName = mnssh != null ? (mnssh.length() == 0 ? "elfman.newstrings1" : NEWSTRINGS_SECTION_NAME + (Integer.parseInt(mnssh) + 1)) : NEWSTRINGS_SECTION_NAME;
        ProgramHeader ste = null;
        for (ProgramHeader ph : this.elf.programHeaderTable) {
            if ((ph.p_type & 1L) == 0L || (ph.p_flags & 2L) != 0L || (ph.p_flags & 4L) == 0L || !this.elf.isEmptyFileSpace(ph.p_offset.add(ph.p_memsz), len) || !this.elf.hasMemSpace(ph, len)) continue;
            ste = ph;
            break;
        }
        if (ste == null && this.jCheckBox3.isSelected()) {
            for (ProgramHeader ph : this.elf.programHeaderTable) {
                if ((ph.p_type & 1L) == 0L || (ph.p_flags & 4L) == 0L || !this.elf.isEmptyFileSpace(ph.p_offset.add(ph.p_memsz), len) || !this.elf.hasMemSpace(ph, len)) continue;
                ste = ph;
                break;
            }
        }
        if (ste != null) {
            this.constructNewstringsSection(ste);
            return;
        }
        String[] columns = new String[]{"#", "Type", "Virtual address", "File size", "Flags"};
        int sr = -1;
        Object[][] data = new String[this.elf.programHeaderTable.size()][9];
        ProgramHeader[] tablephs = new ProgramHeader[this.elf.programHeaderTable.size()];
        for (int i = 0; i < this.elf.programHeaderTable.size(); ++i) {
            tablephs[i] = this.elf.programHeaderTable.get(i);
            if (sr == -1 && tablephs[i].p_type == 4L) {
                sr = i;
            }
            data[i][0] = "" + i;
            data[i][1] = MainFrame.mapGet((Map)Consts.segmentType, (int)tablephs[i].p_type);
            data[i][2] = "0x" + MainFrame.Num2Str(tablephs[i].p_vaddr, 16);
            data[i][3] = "0x" + MainFrame.Num2Str(tablephs[i].p_filesz, 16);
            data[i][4] = MainFrame.phFlags2Str(tablephs[i].p_flags);
        }
        this.jTable1.setModel(new NoEditTableModel(data, columns));
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
        if (sr != -1) {
            this.jTable1.getSelectionModel().setSelectionInterval(sr, sr);
            this.jButton8.setEnabled(true);
        }
        ((CardLayout)this.getContentPane().getLayout()).next(this.getContentPane());
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.phToReplace = this.elf.programHeaderTable.get(this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow()));
        if (this.phToReplace.p_type == 1L && JOptionPane.showConfirmDialog(this, "You have selected a LOAD type program header. Replacing it likely causes the program to stop working. Are you sure?", "Warning", 0, 2) != 0) {
            return;
        }
        this.constructNewstringsSection(null);
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.phToReplace = null;
        this.constructNewstringsSection(null);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.jCheckBox2.setVisible(this.jCheckBox1.isSelected());
        pascalMode = this.jCheckBox1.isSelected();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        if (!this.ozp && this.jCheckBox2.isSelected()) {
            ++this.si.offset;
            --this.stringLength;
            this.jLabel1.setText(this.jLabel1.getText() + " + 1");
            this.ozp = true;
        } else if (this.ozp) {
            --this.si.offset;
            ++this.stringLength;
            this.jLabel1.setText(this.jLabel1.getText().substring(0, this.jLabel1.getText().length() - 4));
            this.ozp = false;
        }
    }

    private void constructNewstringsSection(ProgramHeader ph) {
        LinkedList<String> ls = new LinkedList<String>();
        ls.add(this.jTextArea1.getText());
        ProgbitsSection ns = new ProgbitsSection(null, new StrTabSection(null, ls).toBytes());
        if (this.jCheckBox1.isSelected()) {
            byte[] td = new byte[ns.data.length + 1];
            System.arraycopy(new StrTabSection(null, ls).toBytes(), 0, td, 1, td.length - 1);
            td[1] = (byte)this.jTextArea1.getText().length();
            ns = new ProgbitsSection(null, td);
        }
        BigInteger vaddr = BigInteger.ZERO;
        if (ph != null) {
            vaddr = ph.p_vaddr.add(ph.p_memsz);
            BigInteger sh_offset = ph.p_offset.add(ph.p_memsz);
            this.elf.rearrangeAllFreeSections(ph.p_offset, sh_offset.add(BigInteger.valueOf(ns.data.length)));
            ph.extendSize(sh_offset.add(BigInteger.valueOf(ns.data.length)).subtract(ph.p_offset.add(ph.p_filesz)).intValue());
            this.elf.addSection(ns, this.newSectionName, sh_offset, 1L, 2L, vaddr, 0L, 0L, BigInteger.ZERO, BigInteger.ZERO);
        } else {
            BigInteger foff;
            ProgramHeader maxPh = null;
            for (ProgramHeader iph : this.elf.programHeaderTable) {
                if (iph.p_type != 1L || iph.p_vaddr.add(iph.p_memsz).compareTo(vaddr) <= 0) continue;
                vaddr = iph.p_vaddr.add(iph.p_memsz);
                maxPh = iph;
            }
            vaddr = vaddr.subtract(vaddr.mod(maxPh.p_align)).add(maxPh.p_align);
            try {
                Section t = this.elf.getLastFreeSection();
                foff = t.header.sh_offset.add(t.header.sh_size);
            }
            catch (ElfException ex) {
                foff = this.elf.elfHeader.e_phoff.add(BigInteger.valueOf(this.elf.elfHeader.e_phentsize * this.elf.elfHeader.e_phnum));
            }
            vaddr = vaddr.add(foff.mod(maxPh.p_align));
            this.elf.rearrangeAllFreeSections(foff, foff.add(BigInteger.valueOf(ns.data.length)));
            if (this.phToReplace != null) {
                this.elf.programHeaderTable.remove(this.phToReplace);
                this.elf.programHeaderTable.add(new ProgramHeader(this.elf, 1L, foff, vaddr, vaddr, BigInteger.valueOf(ns.data.length), BigInteger.valueOf(ns.data.length), 4L, maxPh.p_align));
            }
            this.elf.addSection(ns, this.newSectionName, foff, 1L, 2L, vaddr, 0L, 0L, BigInteger.ZERO, BigInteger.ZERO);
        }
        this.replaceReferences(vaddr.add(BigInteger.ONE));
        this.elf.buildSectionToSegmentMapping();
        this.parent.refreshAll();
        this.dispose();
    }

    private void replaceReferences(BigInteger newAddress) {
        for (ElfReference ref : this.jList2.getSelectedValuesList()) {
            BigInteger n = ref.tarAddr.subtract(this.si.getAddress()).add(newAddress);
            if (this.jCheckBox1.isSelected()) {
                n = newAddress;
            }
            if (ref.relativeAddressing()) {
                n = n.subtract(ref.instAddr.add(BigInteger.valueOf(ref.instSize)));
            }
            int so = ref.refAddr.subtract(ref.section.sh_addr).intValue();
            for (int i = 0; i < 4; ++i) {
                ((ProgbitsSection)ref.section.section).data[so + i] = (byte)n.and(BigInteger.valueOf(255L).shiftLeft(i * 8)).shiftRight(i * 8).intValue();
            }
        }
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (ReplaceString.this.jTable1.getSelectedRow() == -1) {
                ReplaceString.this.jButton8.setEnabled(false);
            } else {
                ReplaceString.this.jButton8.setEnabled(true);
            }
        }
    }
}

