/*
 * Decompiled with CFR 0.152.
 */
package elfmangui;

import elfman.Consts;
import elfman.DynamicSection;
import elfman.DynamicStructure;
import elfman.RelSection;
import elfman.RelocationEntry;
import elfman.Section;
import elfman.StrTabSection;
import elfman.SymTabSection;
import elfman.SymbolTableEntry;
import elfmangui.MainFrame;
import elfmangui.NoEditTableModel;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class SectionEntries
extends JFrame {
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    SectionEntries() {
        this.initComponents();
    }

    SectionEntries(Section s, String label) {
        this.initComponents();
        if (s instanceof StrTabSection) {
            LinkedList<String> allStrings = ((StrTabSection)s).getAllStrings();
            Object[][] data = new String[allStrings.size()][2];
            for (int i = 0; i < data.length; ++i) {
                data[i][0] = "" + i;
                data[i][1] = allStrings.get(i);
            }
            String[] c = new String[]{"#", "String"};
            this.jTable1.setModel(new NoEditTableModel(data, c));
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.setTitle("String table section " + label + " contains " + data.length + " strings.");
        } else if (s instanceof DynamicSection) {
            LinkedList<DynamicStructure> dyn = ((DynamicSection)s).data;
            Object[][] data = new String[dyn.size()][4];
            int i = 0;
            for (DynamicStructure d : dyn) {
                data[i][0] = "" + i;
                data[i][1] = "0x" + MainFrame.Num2Str(d.d_tag, 16, 8);
                data[i][2] = MainFrame.mapGet((Map)Consts.d_tag, (int)d.d_tag);
                data[i++][3] = "0x" + MainFrame.Num2Str(d.d_un, 16);
            }
            String[] c = new String[]{"#", "Tag", "Type", "Value"};
            this.jTable1.setModel(new NoEditTableModel(data, c));
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.setTitle("Dynamic section " + label + " contains " + data.length + " entries.");
        } else if (s instanceof RelSection) {
            LinkedList<RelocationEntry> rel = ((RelSection)s).entries;
            boolean addend = ((RelSection)s).withAddend;
            Object[][] data = new String[rel.size()][5];
            int i = 0;
            for (RelocationEntry r : rel) {
                data[i][0] = "" + i;
                data[i][1] = "0x" + MainFrame.Num2Str(r.r_offset, 16);
                data[i][2] = "0x" + MainFrame.Num2Str(r.r_info, 16);
                SymbolTableEntry se = r.getSymbol();
                data[i][3] = "0x" + MainFrame.Num2Str(se.st_value, 16);
                data[i++][4] = se.getName() + (addend ? " + 0x" + MainFrame.Num2Str(r.r_addend, 16) : "");
            }
            String[] c = new String[]{"#", "Offset", "Info", "Sym. value", "Sym. name" + (addend ? " + Addend" : "")};
            this.jTable1.setModel(new NoEditTableModel(data, c));
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.setTitle("Relocation section " + label + " contains " + data.length + " entries.");
        } else if (s instanceof SymTabSection) {
            LinkedList<SymbolTableEntry> sym = ((SymTabSection)s).data;
            Object[][] data = new String[sym.size()][8];
            int i = 0;
            for (SymbolTableEntry se : sym) {
                data[i][0] = "" + i;
                data[i][1] = "0x" + MainFrame.Num2Str(se.st_value, 16);
                data[i][2] = "0x" + MainFrame.Num2Str(se.st_size, 16);
                data[i][3] = MainFrame.mapGet((Map)Consts.symbolTypes, se.getSt_Type());
                data[i][4] = MainFrame.mapGet((Map)Consts.symbolBinding, se.getSt_Bind());
                data[i][5] = MainFrame.mapGet((Map)Consts.symbolVisibility, se.getSt_Visibility());
                switch (se.st_shndx) {
                    case 65521: {
                        data[i][6] = "ABS";
                        break;
                    }
                    case 65522: {
                        data[i][6] = "COMMON";
                        break;
                    }
                    case 0: {
                        data[i][6] = "UNDEF";
                        break;
                    }
                    case 65535: {
                        data[i][6] = "XINDEX";
                        break;
                    }
                    default: {
                        data[i][6] = "" + se.st_shndx;
                    }
                }
                data[i++][7] = se.getName();
            }
            String[] c = new String[]{"#", "Value", "Size", "Type", "Binding", "Visibility", "Ndx", "Name"};
            this.jTable1.setModel(new NoEditTableModel(data, c));
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.setTitle("Symbol table " + label + " contains " + data.length + " entries.");
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(2);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 564, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 402, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }
}

