/*
 * Decompiled with CFR 0.152.
 */
package sic2intel;

import java.io.File;
import sic2intel.logger.Logger;

public class Main {
    private static boolean testing = false;
    public static boolean debugOuput = false;
    public static File srcFile = null;
    public static String srcFilePath = null;
    public static String srcFileName = null;
    public static String dstFilePath = null;
    public static String dstFileName = null;
    public static String logFileName = null;

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-help") || arg.equals("--help")) {
                Main.showHelp();
                System.exit(0);
                continue;
            }
            if (!arg.equals("-d")) continue;
            if (i < args.length) {
                debugOuput = true;
                Main.extractFileInfo(args[i++]);
                continue;
            }
            System.err.println("Switch \"-d\" requires an input file.");
            System.exit(1);
        }
        if (args.length == 0) {
            if (testing) {
                srcFilePath = "test1.asm";
                Main.extractFileInfo(srcFilePath);
                sic2intel.structure.Main.showConsole();
            } else {
                sic2intel.gui.Main.showGUI();
            }
        } else if (args.length == 1) {
            Main.extractFileInfo(args[0]);
            sic2intel.structure.Main.showConsole();
        } else {
            sic2intel.structure.Main.showConsole();
        }
    }

    public static void extractFileInfo(String path) {
        try {
            Main.extractFileInfo(new File(path));
        }
        catch (NullPointerException e) {
            Logger.fatalError("The file \"" + path + "\" does not exist.", e, 1);
        }
    }

    public static void extractFileInfo(File file) {
        srcFile = file;
        srcFileName = srcFile.getName();
        dstFileName = srcFileName.lastIndexOf(46) != -1 ? String.valueOf(srcFileName.substring(0, srcFileName.lastIndexOf(46))) + "_out.asm" : String.valueOf(srcFileName) + "_out.asm";
        dstFilePath = testing ? String.valueOf(System.getProperty("user.dir")) + File.separator : (srcFile.getParent() != null ? String.valueOf(srcFile.getParent()) + File.separator : "");
        logFileName = srcFileName.lastIndexOf(46) != -1 ? String.valueOf(srcFileName.substring(0, srcFileName.lastIndexOf(46))) + "_err.log" : String.valueOf(srcFileName) + "_err.log";
    }

    public static void showHelp() {
        System.out.println("Usage: ./Sic2Intel.jar [options] file");
        System.out.println("where options include:");
        System.out.println("\t-d\tshow original instructions as comments");
        System.out.println("\t-h\tshow help");
    }
}

