/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import sic2intel.Main;
import sic2intel.gui.AboutDialog;
import sic2intel.gui.CompilerFileFilter;
import sic2intel.gui.HelpDialog;
import sic2intel.logger.Logger;

public class CompilerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JFileChooser fileChooser;
    private CompilerFileFilter fileFilter;
    private JTextField textFieldSelectedFile;

    public static void execute() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CompilerFrame frame = new CompilerFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public CompilerFrame() {
        this.setResizable(false);
        this.setTitle("Sic2Intel");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 250);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open ...");
        mntmOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mntmOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.btnSelectFile_actionPerformed();
            }
        });
        mnFile.add(mntmOpen);
        JMenuItem mntmQuit = new JMenuItem("Exit");
        mntmQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerFrame.this.btnQuit_actionPerformed();
            }
        });
        mnFile.add(mntmQuit);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mntmHelp = new JMenuItem("Help");
        mntmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerFrame.this.mntmHelp_actionPerformed();
            }
        });
        mntmHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        mnHelp.add(mntmHelp);
        JMenuItem mntmAbout = new JMenuItem("About");
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.mntmAbout_actionPerformed();
            }
        });
        mntmAbout.setAccelerator(KeyStroke.getKeyStroke(112, 1));
        mnHelp.add(mntmAbout);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.setupFileChooser();
        JButton btnTranslate = new JButton("Translate");
        btnTranslate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.btnTranslate_actionPerformed();
            }
        });
        btnTranslate.setBounds(220, 163, 102, 25);
        this.contentPane.add(btnTranslate);
        JButton btnQuit = new JButton("Quit");
        btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.btnQuit_actionPerformed();
            }
        });
        btnQuit.setBounds(334, 163, 102, 25);
        this.contentPane.add(btnQuit);
        JButton btnSelectFile = new JButton("Browse ...");
        btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.btnSelectFile_actionPerformed();
            }
        });
        btnSelectFile.setBounds(334, 12, 102, 25);
        this.contentPane.add(btnSelectFile);
        this.textFieldSelectedFile = new JTextField();
        this.textFieldSelectedFile.setBounds(12, 12, 310, 25);
        this.contentPane.add(this.textFieldSelectedFile);
        this.textFieldSelectedFile.setColumns(10);
        JCheckBox chckbxDebugOutput = new JCheckBox("Debug output");
        chckbxDebugOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CompilerFrame.this.chckbxDebugOutput_actionPerformed(arg0);
            }
        });
        chckbxDebugOutput.setToolTipText("Prints original instructions as comments in front of each translated instruction.");
        chckbxDebugOutput.setBounds(12, 45, 129, 23);
        chckbxDebugOutput.setHorizontalTextPosition(2);
        this.contentPane.add(chckbxDebugOutput);
    }

    private void setupFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileFilter = new CompilerFileFilter();
        this.fileChooser.addChoosableFileFilter(this.fileFilter);
        this.fileChooser.setFileFilter(this.fileFilter);
    }

    private void btnQuit_actionPerformed() {
        this.dispose();
    }

    private void btnTranslate_actionPerformed() {
        if (this.textFieldSelectedFile.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "No file selected.\nPlease select a file and try again.", "No file", 0);
        } else {
            Main.extractFileInfo(this.textFieldSelectedFile.getText());
            if (Main.srcFile != null) {
                int status = sic2intel.structure.Main.execute();
                if (status != 0) {
                    JOptionPane.showMessageDialog(this, "An error occured during the translation process.\nSee \"" + Main.logFileName + "\" for more information.", "Translation error", 0);
                } else {
                    JOptionPane.showMessageDialog(this, "The translation process was sucessful.\nSee \"" + Main.dstFileName + "\" for end result.", "Translation successful", 1);
                }
                Logger.close();
            } else {
                JOptionPane.showMessageDialog(this, "No source file selected.\nAborting the translation process.", "No source file", 2);
            }
        }
    }

    private void btnSelectFile_actionPerformed() {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.textFieldSelectedFile.setText(file.getAbsolutePath());
        }
    }

    private void mntmHelp_actionPerformed() {
        new HelpDialog((Component)this);
    }

    private void mntmAbout_actionPerformed() {
        new AboutDialog((Component)this);
    }

    private void chckbxDebugOutput_actionPerformed(ActionEvent e) {
        Main.debugOuput = ((JCheckBox)e.getSource()).isSelected();
    }
}

