/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import sic2intel.logger.Logger;

public class SicLexer
implements Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int DQUOTE_STRING = 8;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 4;
    public static final int NORMAL = 2;
    public static final int COMMANDS = 6;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001)\u00010\u0001.\u0001 \u0003\u0000\u0001(\u0001,\u0001-\u0001#\u0001\u001d\u0001\"\u0001\u001e\u0001*\u0001\u001f\u0001%\t&\u0001\u0000\u00010\u0001+\u0001\u0000\u0001/\u0001\u0000\u0001!\u0001\u0004\u0001\u0019\u0001\t\u0001\u0005\u0001\u000b\u0001\u0006\u0001\u0016\u0001\u0013\u0001\u000f\u0001\u0014\u0001\u001a\u0001\n\u0001\r\u0001\b\u0001\f\u0001\u000e\u0001\u0015\u0001\u0007\u0001\u0017\u0001\u0012\u0001\u0018\u0001\u0010\u0001\u001b\u0001\u0011\u0001\u001c\u0001$\u0001\u0000\u00010\u0002\u0000\u0001$\u0001\u0000\u0017$\u0001'\u0002$\u0091\u0000\u00020R\u0000\u00020\u001b\u0000\u00020\ufe81\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0001\u0001\u0001\u0006\u0003\u0001\u0001\u0007\u0005\u0001\u0001\b\u0001\t\u0001\u0001\u0001\n\u0001\u000b\u0001\f\u0001\u0001\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0002\u0014\u0001\u0015\u0001\u0003\u0002\u0016\u0001\u0017\u0002\u0001\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u0001\u0001\u001b\u0002\u0004\u0005\u0001\u0001\u001c\u0006\u0001\u0001\u0000\u0004\u0001\u0001\u001d\u0001\u0001\u0001\u001e\u0001\u0000\u0001\u001f\f\u0001\u0001 \u0001\u0001\u0001!\u0001\u0001\u0001\u0000\u0002\u0016\u0002\u0001\u0001\u0000\u0001\"\u0001#\u0001$\u0001\u0001\u0001%\u0001\u0001\u0001&\u0004\u0001\u0001\u0000\u0001'\u0001(\u0001\u0001\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u0001\u0000\u00012\u00013\u00014\u00015\u00016\u00017\u0001\u0001\u00018\u00019\u0001:\u0001;\u0001\u0001\u0001<\u0001=\u0001>\u0001?\u0001@\u0001A\u0001\u0001\u0001B\u0001C\u0002\u0001\u0001D\u0001\u0000\u0002\u0001\u0001E\u0001F\u0001G\u0001H\u0001\u0001\u0001I\u0001J\u0001K\u0001L\u0001\u0001\u0001M\u0001N\u0001O\u0001P\u0001Q\u0001R\u0001S\u0001T\u0001\u0001\u0001U\u0001V\u0001\u0001\u0001W\u0001X\u0001Y\u0001Z\u0001[\u0001\u0001\u0001\\\u0001]\u0001^\u0001_\u0001`\u0001\u0001\u0001a\u0001b\u0001c";
    private static final int[] ZZ_ROWMAP;
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00001\u0000b\u0000\u0093\u0000\u00c4\u0000\u0000\u0000\u00f5\u0000\u0126\u0000\u0157\u0000\u0188\u0000\u01b9\u0000\u01ea\u0000\u021b\u0000\u024c\u0000\u027d\u0000\u02ae\u0000\u02df\u0000\u0310\u0000\u0341\u0000\u0372\u0000\u03a3\u0000\u03d4\u0000\u0405\u0000\u0436\u0000\u0467\u0000\u0498\u0000\u04c9\u0000\u04fa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u052b\u0000\u055c\u0000\u0000\u0000\u0000\u0000\u058d\u0000\u05be\u0000\u0000\u0000\u05ef\u0000\u0620\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0651\u0000\u0000\u0000\u0682\u0000\u06b3\u0000\u06e4\u0000\u0715\u0000\u0746\u0000\u0777\u0000\u07a8\u0000\u03a3\u0000\u07d9\u0000\u080a\u0000\u083b\u0000\u086c\u0000\u089d\u0000\u08ce\u0000\u08ff\u0000\u0930\u0000\u0961\u0000\u0992\u0000\u09c3\u0000\u03a3\u0000\u09f4\u0000\u03a3\u0000\u0a25\u0000\u03a3\u0000\u0a56\u0000\u0a87\u0000\u0ab8\u0000\u0ae9\u0000\u0b1a\u0000\u0b4b\u0000\u0b7c\u0000\u0bad\u0000\u0bde\u0000\u0c0f\u0000\u0c40\u0000\u0c71\u0000\u03a3\u0000\u0ca2\u0000\u03a3\u0000\u0cd3\u0000\u0d04\u0000\u0d35\u0000\u0d66\u0000\u0d97\u0000\u0dc8\u0000\u0df9\u0000\u0e2a\u0000\u03a3\u0000\u0e5b\u0000\u0e8c\u0000\u03a3\u0000\u0ebd\u0000\u03a3\u0000\u0eee\u0000\u0f1f\u0000\u0f50\u0000\u0f81\u0000\u0fb2\u0000\u03a3\u0000\u03a3\u0000\u0fe3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u1014\u0000\u1045\u0000\u03a3\u0000\u1076\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u10a7\u0000\u03a3\u0000\u03a3\u0000\u10d8\u0000\u03a3\u0000\u1109\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u113a\u0000\u03a3\u0000\u116b\u0000\u03a3\u0000\u119c\u0000\u11cd\u0000\u11fe\u0000\u0d04\u0000\u122f\u0000\u1260\u0000\u1291\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u12c2\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u12f3\u0000\u1324\u0000\u0000\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u0000\u0000\u03a3\u0000\u03a3\u0000\u1355\u0000\u03a3\u0000\u03a3\u0000\u1386\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u13b7\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u03a3\u0000\u13e8\u0000\u03a3\u0000\u03a3\u0000\u03a3";
    private static final int[] ZZ_TRANS;
    private static final String ZZ_TRANS_PACKED_0 = "1\u0000\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0002\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0002\u0015\u0001\u001a\u0001\u0015\u0001\u001b\u0001\u0015\u0001\u001c\u0001\u0015\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001\u0015\u0001$\u0001%\u0001\u0015\u0001\u0006\u0001\u0007\u0001&\u0006\u0006\u0002'\u0001(\u0001)''\u0001*\u0005'\u0001\u0000\u0001\u0007\u0002\u0000\u0003\u0015\u0001+\u0013\u0015\u0001,\u0001\u0015\u0005\u0000\u0001\"\u0001\u0000\u0001\u0015\u0002%\u0001\u0015\u0001\u0000\u0001\u0007\u0002\u0000\u0001-\u0001.\u0001/\u0001&\u0005\u0000\u00190\u0002\u0000\u00010\u0002\u0000\u00010\u0001\u0000\u00070\u0003\u0000\u00011\u0001\u0000\u00010\u0001\u0000\u0001\u0007'\u0000\u0001\u0007\t\u0000\u0001\b0\u0000\u00012\u000131\u0000\u0001\u0015\u00014\u0002\u0015\u00015\u0014\u0015\u0007\u0000\u0004\u0015\r\u0000\u000b\u0015\u00016\r\u0015\u0007\u0000\u0004\u0015\r\u0000\u0006\u0015\u00017\u0004\u0015\u00018\r\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0015\u00019\u0005\u0015\u0001:\u0001\u0015\u0001;\t\u0015\u0001<\u0005\u0015\u0007\u0000\u0004\u0015\r\u0000\b\u0015\u0001=\u0010\u0015\u0007\u0000\u0004\u0015\r\u0000\u0006\u0015\u0001>\u0001\u0015\u0001?\u0010\u0015\u0007\u0000\u0004\u0015\u0001@\f\u0000\u0001\u0015\u0001A\b\u0015\u0001B\u000e\u0015\u0007\u0000\u0004\u0015\r\u0000\u0004\u0015\u0001C\f\u0015\u0001D\u0007\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001E\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0014\u0015\u0001F\u0004\u0015\u0007\u0000\u0004\u0015\r\u0000\u0005\u0015\u0001G\u0013\u0015\u0007\u0000\u0004\u0015\r\u0000\u0019\u0015\u0007\u0000\u0004\u0015\r\u0000\u0019\u0015\u0007\u0000\u0004\u0015\u0001H\f\u0000\u0001\u0015\u0001I\t\u0015\u0001J\r\u0015\u0007\u0000\u0004\u0015\r\u0000\u000b\u0015\u0001K\r\u0015\u0007\u0000\u0004\u0015\r\u0000\u0006\u0015\u0001L\u0001M\n\u0015\u0001N\u0001O\u0005\u0015\u0007\u0000\u0004\u0015\r\u0000\u000b\u0015\u0001P\u0001Q\u0001\u0015\u0001R\u0001S\u0003\u0015\u0001T\u0001U\u0002\u0015\u0001V\u0001\u0015\u0007\u0000\u0004\u0015\r\u0000\u0018\u0015\u0001W\u0007\u0000\u0004\u0015\r\u0000\u0001\u0015\u0001X\u0006\u0015\u0001Y\u0010\u0015\u0007\u0000\u0004\u0015.\u0000\u0002%\u0001Z.\u0000\u0002%\f\u0000\u0001(0\u0000\u0001[\u0001\\1\u0000\u0007\u0015\u0001]\u0011\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001^\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u00190\u0002\u0000\u00010\u0002\u0000\u00010\u0001\u0000\u00070\u0005\u0000\u00010\u0003\u0000\u0001_0\u0000\u000131\u0000\u0001\u0015\u0001`\u0017\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0015\u0001a\u0017\u0015\u0007\u0000\u0004\u0015\r\u0000\f\u0015\u0001b\f\u0015\u0007\u0000\u0004\u0015\r\u0000\b\u0015\u0001c\u0010\u0015\u0007\u0000\u0004\u0015\r\u0000\r\u0015\u0001d\u000b\u0015\u0007\u0000\u0004\u0015\r\u0000\u0013\u0015\u0001e\u0005\u0015\u0007\u0000\u0004\u0015\r\u0000\b\u0015\u0001f\u0010\u0015\u0007\u0000\u0004\u0015\r\u0000\u0014\u0015\u0001g\u0004\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001h\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0007\u0015\u0001i\u0011\u0015\u0007\u0000\u0004\u0015\r\u0000\t\u0015\u0001j\u000f\u0015\u0007\u0000\u0004\u0015\r\u0000\u0019k\u0007\u0000\u0004k\u0001\u0000\u0001k\u000b\u0000\u0001l\u0001\u0015\u0001m\u0002\u0015\u0001n\u0001o\u0006\u0015\u0001p\u0001q\u0004\u0015\u0001r\u0001\u0015\u0001s\u0003\u0015\u0007\u0000\u0004\u0015\r\u0000\u0013\u0015\u0001t\u0005\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0015\u0001u\u0017\u0015\u0007\u0000\u0004\u0015\r\u0000\u0014\u0015\u0001v\u0004\u0015\u0007\u0000\u0004\u0015\r\u0000\u0006\u0015\u0001w\u0012\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003x\u0002\u0000\u0001x\u0001\u0000\u0001x\r\u0000\u0001x\u000b\u0000\u0002x\u000e\u0000\b\u0015\u0001y\u0004\u0015\u0001z\u000b\u0015\u0007\u0000\u0004\u0015\r\u0000\b\u0015\u0001{\u0010\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001|\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u0011\u0015\u0001}\u0007\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001~\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u0014\u0015\u0001\u007f\u0004\u0015\u0007\u0000\u0004\u0015\r\u0000\b\u0015\u0001\u0080\u0010\u0015\u0007\u0000\u0004\u0015\r\u0000\u0005\u0015\u0001\u0081\u0013\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0082\u0001\u0015\u0001\u0083\u0002\u0015\u0001\u0084\u0001\u0085\u0004\u0015\u0001\u0086\u0001\u0015\u0001\u0087\u0001\u0088\u0004\u0015\u0001\u0089\u0001\u0015\u0001\u008a\u0003\u0015\u0007\u0000\u0004\u0015\r\u0000\u000b\u0015\u0001\u008b\r\u0015\u0007\u0000\u0004\u0015\r\u0000\u0016\u0015\u0001\u008c\u0002\u0015\u0007\u0000\u0004\u0015\r\u0000\u0015\u0015\u0001\u008d\u0003\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001\u008e\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001\u008f\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0090\u0002\u0000\u0001\u0090\u0001\u0000\u0001\u0090\r\u0000\u0001\u0090\u000b\u0000\u0002\u0090\r\u0000\u0001\u00910\u0000\u0001\\1\u0000\u0001\u0092\u0018\u0015\u0007\u0000\u0004\u0015\r\u0000\u000b\u0015\u0001\u0093\r\u0015\u0007\u0000\u0004\u0015\u000b\u0000\u000122\u0000\u0002\u0015\u0001\u0094\u0001\u0095\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0002\u0015\u0001\u0096\u0001\u0097\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0098\u0018\u0015\u0007\u0000\u0004\u0015\r\u0000\u0015\u0015\u0001\u0099\u0001\u0015\u0001\u009a\u0001\u0015\u0007\u0000\u0004\u0015\r\u0000\u0015\u0015\u0001\u009b\u0003\u0015\u0007\u0000\u0004\u0015\r\u0000\t\u0015\u0001\u009c\u000f\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u009d\u0018\u0015\u0007\u0000\u0004\u0015\r\u0000\n\u0015\u0001\u009e\u000e\u0015\u0007\u0000\u0004\u0015\r\u0000\u0019k\u0007\u0000\u0004k\u0001\u009f\u0001k\u000b\u0000\u000f\u0015\u0001\u00a0\t\u0015\u0007\u0000\u0004\u0015\r\u0000\u0002\u0015\u0001\u00a1\u0001\u00a2\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003x\u0002\u0000\u0001x\u0001\u0000\u0001x\r\u0000\u0001x\u000b\u0000\u0002x\u0001\u0000\u0001\u00a3\f\u0000\u0003\u0015\u0001\u00a4\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0015\u0015\u0001\u00a5\u0003\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001\u00a6\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u000f\u0015\u0001\u00a7\t\u0015\u0007\u0000\u0004\u0015\r\u0000\u0017\u0015\u0001\u00a8\u0001\u0015\u0007\u0000\u0004\u0015\r\u0000\u0002\u0015\u0001\u00a9\u0016\u0015\u0007\u0000\u0004\u0015\r\u0000\u0002\u0015\u0001\u00aa\u0001\u00ab\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0007\u0015\u0001\u00ac\u0011\u0015\u0007\u0000\u0004\u0015\r\u0000\u0001\u0015\u0001\u00ad\u0017\u0015\u0007\u0000\u0004\u0015\u000b\u0000\u0001[2\u0000\u0001\u0015\u0001\u00ae\u0017\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001\u00af\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001\u00b0\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001\u00b1\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u0002\u0015\u0001\u00b2\u0001\u00b3\u0015\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001\u00b4\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u000e\u0015\u0001\u00b5\n\u0015\u0007\u0000\u0004\u0015\r\u0000\u0007\u0015\u0001\u00b6\u0011\u0015\u0007\u0000\u0004\u0015\r\u0000\u0003\u0015\u0001\u00b7\u0002\u0015\u0001\u00b8\u0012\u0015\u0007\u0000\u0004\u0015\t\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private static final int[] ZZ_ATTRIBUTE;
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\b\u0003\u0000\u0001\u0001\u0001\t\u0016\u0001\u0007\t\u0002\u0001\u0002\t\u0002\u0001\u0001\t\u0002\u0001\u0003\t\u0001\u0001\u0001\t\u000e\u0001\u0001\u0000\u0007\u0001\u0001\u0000\u0011\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u000b\u0001\u0001\u0000\f\u0001\u0001\u0000\u0018\u0001\u0001\u0000\r\u0001\u0001\t\u0003\u0001\u0001\t\u0015\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    static {
        int[] nArray = new int[10];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[9] = 4;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = SicLexer.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = SicLexer.zzUnpackAction();
        ZZ_ROWMAP = SicLexer.zzUnpackRowMap();
        ZZ_TRANS = SicLexer.zzUnpackTrans();
        ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
        ZZ_ATTRIBUTE = SicLexer.zzUnpackAttribute();
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[184];
        int offset = 0;
        offset = SicLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[184];
        int offset = 0;
        offset = SicLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[5145];
        int offset = 0;
        offset = SicLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[184];
        int offset = 0;
        offset = SicLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private Symbol sym(int type) {
        return new Symbol(type, this.yyline + 1, this.yycolumn + 1, (Object)this.yytext());
    }

    public SicLexer(Reader in) {
        this.yybegin(2);
        this.zzReader = in;
    }

    public SicLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 140) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    @Override
    public Symbol next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block208: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        break;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        break;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        break;
                    }
                    default: {
                        zzR = false;
                        ++this.yycolumn;
                    }
                }
                ++zzCurrentPosL;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 57: {
                    return this.sym(55);
                }
                case 100: {
                    continue block208;
                }
                case 67: {
                    return this.sym(52);
                }
                case 101: {
                    continue block208;
                }
                case 58: {
                    return this.sym(42);
                }
                case 102: {
                    continue block208;
                }
                case 29: {
                    return this.sym(34);
                }
                case 103: {
                    continue block208;
                }
                case 72: {
                    return this.sym(12);
                }
                case 104: {
                    continue block208;
                }
                case 70: {
                    return this.sym(4);
                }
                case 105: {
                    continue block208;
                }
                case 79: {
                    return this.sym(23);
                }
                case 106: {
                    continue block208;
                }
                case 89: {
                    return this.sym(68);
                }
                case 107: {
                    continue block208;
                }
                case 8: {
                    return this.sym(93);
                }
                case 108: {
                    continue block208;
                }
                case 95: {
                    return this.sym(9);
                }
                case 109: {
                    continue block208;
                }
                case 86: {
                    return this.sym(49);
                }
                case 110: {
                    continue block208;
                }
                case 50: {
                    return this.sym(57);
                }
                case 111: {
                    continue block208;
                }
                case 85: {
                    return this.sym(44);
                }
                case 112: {
                    continue block208;
                }
                case 92: {
                    return this.sym(14);
                }
                case 113: {
                    continue block208;
                }
                case 32: {
                    return this.sym(91);
                }
                case 114: {
                    continue block208;
                }
                case 97: {
                    return this.sym(61);
                }
                case 115: {
                    continue block208;
                }
                case 14: {
                    return this.sym(71);
                }
                case 116: {
                    continue block208;
                }
                case 35: {
                    return this.sym(5);
                }
                case 117: {
                    continue block208;
                }
                case 4: {
                    return this.sym(75);
                }
                case 118: {
                    continue block208;
                }
                case 42: {
                    return this.sym(28);
                }
                case 119: {
                    continue block208;
                }
                case 9: {
                    return this.sym(92);
                }
                case 120: {
                    continue block208;
                }
                case 68: {
                    return this.sym(83);
                }
                case 121: {
                    continue block208;
                }
                case 96: {
                    return this.sym(63);
                }
                case 122: {
                    continue block208;
                }
                case 11: {
                    return this.sym(90);
                }
                case 123: {
                    continue block208;
                }
                case 90: {
                    return this.sym(67);
                }
                case 124: {
                    continue block208;
                }
                case 27: {
                    this.yybegin(6);
                    return this.sym(80);
                }
                case 125: {
                    continue block208;
                }
                case 1: {
                    return this.sym(81);
                }
                case 126: {
                    continue block208;
                }
                case 56: {
                    return this.sym(40);
                }
                case 127: {
                    continue block208;
                }
                case 98: {
                    return this.sym(39);
                }
                case 128: {
                    continue block208;
                }
                case 62: {
                    return this.sym(51);
                }
                case 129: {
                    continue block208;
                }
                case 13: {
                    return this.sym(70);
                }
                case 130: {
                    continue block208;
                }
                case 80: {
                    return this.sym(31);
                }
                case 131: {
                    continue block208;
                }
                case 43: {
                    return this.sym(27);
                }
                case 132: {
                    continue block208;
                }
                case 2: {
                    Logger.warning("Unexpected character: '" + this.yytext() + "'", this.yyline + 1, this.yycolumn + 1);
                }
                case 133: {
                    continue block208;
                }
                case 44: {
                    return this.sym(26);
                }
                case 134: {
                    continue block208;
                }
                case 52: {
                    return this.sym(15);
                }
                case 135: {
                    continue block208;
                }
                case 47: {
                    return this.sym(64);
                }
                case 136: {
                    continue block208;
                }
                case 16: {
                    return this.sym(73);
                }
                case 137: {
                    continue block208;
                }
                case 73: {
                    return this.sym(66);
                }
                case 138: {
                    continue block208;
                }
                case 63: {
                    return this.sym(50);
                }
                case 139: {
                    continue block208;
                }
                case 71: {
                    return this.sym(11);
                }
                case 140: {
                    continue block208;
                }
                case 25: {
                    return this.sym(78);
                }
                case 141: {
                    continue block208;
                }
                case 69: {
                    return this.sym(3);
                }
                case 142: {
                    continue block208;
                }
                case 22: {
                    this.yybegin(2);
                    return this.sym(75);
                }
                case 143: {
                    continue block208;
                }
                case 21: {
                    this.yybegin(4);
                }
                case 144: {
                    continue block208;
                }
                case 7: {
                    return this.sym(89);
                }
                case 145: {
                    continue block208;
                }
                case 94: {
                    return this.sym(8);
                }
                case 146: {
                    continue block208;
                }
                case 64: {
                    return this.sym(48);
                }
                case 147: {
                    continue block208;
                }
                case 37: {
                    return this.sym(13);
                }
                case 148: {
                    continue block208;
                }
                case 78: {
                    return this.sym(85);
                }
                case 149: {
                    continue block208;
                }
                case 99: {
                    return this.sym(38);
                }
                case 150: {
                    continue block208;
                }
                case 15: {
                    return this.sym(72);
                }
                case 151: {
                    continue block208;
                }
                case 10: {
                    return this.sym(16);
                }
                case 152: {
                    continue block208;
                }
                case 24: {
                    return this.sym(79);
                }
                case 153: {
                    continue block208;
                }
                case 18: {
                    return this.sym(76);
                }
                case 154: {
                    continue block208;
                }
                case 23: {
                    this.yybegin(6);
                }
                case 155: {
                    continue block208;
                }
                case 76: {
                    return this.sym(33);
                }
                case 156: {
                    continue block208;
                }
                case 20: {
                    return this.sym(82);
                }
                case 157: {
                    continue block208;
                }
                case 28: {
                    return this.sym(35);
                }
                case 158: {
                    continue block208;
                }
                case 41: {
                    return this.sym(25);
                }
                case 159: {
                    continue block208;
                }
                case 84: {
                    return this.sym(20);
                }
                case 160: {
                    continue block208;
                }
                case 77: {
                    return this.sym(7);
                }
                case 161: {
                    continue block208;
                }
                case 38: {
                    return this.sym(36);
                }
                case 162: {
                    continue block208;
                }
                case 17: {
                    return this.sym(74);
                }
                case 163: {
                    continue block208;
                }
                case 31: {
                    return this.sym(56);
                }
                case 164: {
                    continue block208;
                }
                case 83: {
                    return this.sym(59);
                }
                case 165: {
                    continue block208;
                }
                case 88: {
                    return this.sym(54);
                }
                case 166: {
                    continue block208;
                }
                case 6: {
                    return this.sym(88);
                }
                case 167: {
                    continue block208;
                }
                case 82: {
                    return this.sym(84);
                }
                case 168: {
                    continue block208;
                }
                case 46: {
                    return this.sym(29);
                }
                case 169: {
                    continue block208;
                }
                case 60: {
                    return this.sym(47);
                }
                case 170: {
                    continue block208;
                }
                case 66: {
                    return this.sym(41);
                }
                case 171: {
                    continue block208;
                }
                case 33: {
                    return this.sym(60);
                }
                case 172: {
                    continue block208;
                }
                case 30: {
                    return this.sym(94);
                }
                case 173: {
                    continue block208;
                }
                case 93: {
                    return this.sym(6);
                }
                case 174: {
                    continue block208;
                }
                case 74: {
                    return this.sym(65);
                }
                case 175: {
                    continue block208;
                }
                case 40: {
                    return this.sym(24);
                }
                case 176: {
                    continue block208;
                }
                case 12: {
                    return this.sym(87);
                }
                case 177: {
                    continue block208;
                }
                case 61: {
                    return this.sym(46);
                }
                case 178: {
                    continue block208;
                }
                case 19: {
                    return this.sym(77);
                }
                case 179: {
                    continue block208;
                }
                case 55: {
                    return this.sym(18);
                }
                case 180: {
                    continue block208;
                }
                case 5: {
                    return this.sym(86);
                }
                case 181: {
                    continue block208;
                }
                case 51: {
                    return this.sym(58);
                }
                case 182: {
                    continue block208;
                }
                case 54: {
                    return this.sym(17);
                }
                case 183: {
                    continue block208;
                }
                case 49: {
                    return this.sym(30);
                }
                case 184: {
                    continue block208;
                }
                case 75: {
                    return this.sym(37);
                }
                case 185: {
                    continue block208;
                }
                case 59: {
                    return this.sym(45);
                }
                case 186: {
                    continue block208;
                }
                case 91: {
                    return this.sym(62);
                }
                case 187: {
                    continue block208;
                }
                case 45: {
                    return this.sym(22);
                }
                case 188: {
                    continue block208;
                }
                case 36: {
                    return this.sym(10);
                }
                case 189: {
                    continue block208;
                }
                case 34: {
                    return this.sym(2);
                }
                case 190: {
                    continue block208;
                }
                case 53: {
                    return this.sym(19);
                }
                case 191: {
                    continue block208;
                }
                case 39: {
                    return this.sym(21);
                }
                case 192: {
                    continue block208;
                }
                case 81: {
                    return this.sym(32);
                }
                case 193: {
                    continue block208;
                }
                case 48: {
                    return this.sym(69);
                }
                case 194: {
                    continue block208;
                }
                case 26: {
                    this.yybegin(8);
                    return this.sym(80);
                }
                case 195: {
                    continue block208;
                }
                case 65: {
                    return this.sym(43);
                }
                case 196: {
                    continue block208;
                }
                case 87: {
                    return this.sym(53);
                }
                case 197: {
                    continue block208;
                }
                case 3: 
                case 198: {
                    continue block208;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                switch (this.zzLexicalState) {
                    case 2: {
                        return this.sym(0);
                    }
                    case 185: {
                        continue block208;
                    }
                }
                return new Symbol(0);
            }
            this.zzScanError(1);
        }
    }
}

