/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.logger;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import sic2intel.Main;

public class Logger {
    private static SimpleDateFormat sdf;
    private static Date date;
    private static PrintWriter writer;
    private static File errFile;

    public static void initLogger() {
        sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        date = new Date();
        try {
            errFile = new File(String.valueOf(Main.dstFilePath) + "/" + Main.logFileName);
            writer = new PrintWriter(errFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int error(String shortMsg) {
        if (writer == null) {
            Logger.initLogger();
        }
        writer.println(String.valueOf(Logger.timestamp()) + shortMsg + "\n");
        return 1;
    }

    public static int error(String shortMsg, Exception error) {
        if (writer == null) {
            Logger.initLogger();
        }
        writer.println(String.valueOf(Logger.timestamp()) + shortMsg + "\n");
        error.printStackTrace(writer);
        return 1;
    }

    public static int fatalError(String shortMsg, Exception error, int exitStatus) {
        if (writer == null) {
            Logger.initLogger();
        }
        writer.println(String.valueOf(Logger.timestamp()) + shortMsg + "\n");
        error.printStackTrace(writer);
        return exitStatus;
    }

    public static void warning(String msg) {
        if (writer == null) {
            Logger.initLogger();
        }
        writer.println(String.valueOf(Logger.timestamp()) + msg + "\n");
    }

    public static void warning(String msg, int begLine, int begColumn) {
        if (writer == null) {
            Logger.initLogger();
        }
        writer.println(String.valueOf(Logger.timestamp()) + msg + " [" + begLine + ":" + begColumn + "]." + "\n");
    }

    public static void close() {
        if (writer != null) {
            writer.close();
        }
    }

    public static String timestamp() {
        return "[" + sdf.format(date.getTime()) + "] ";
    }
}

