/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import sic2intel.logger.Logger;
import sic2intel.structure.DataInspector;
import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelInstrADD;
import sic2intel.structure.intel.IntelInstrAND;
import sic2intel.structure.intel.IntelInstrCALL;
import sic2intel.structure.intel.IntelInstrCMP;
import sic2intel.structure.intel.IntelInstrDATA;
import sic2intel.structure.intel.IntelInstrDIV;
import sic2intel.structure.intel.IntelInstrEQU;
import sic2intel.structure.intel.IntelInstrFADD;
import sic2intel.structure.intel.IntelInstrFCOM;
import sic2intel.structure.intel.IntelInstrFDIV;
import sic2intel.structure.intel.IntelInstrFILD;
import sic2intel.structure.intel.IntelInstrFIST;
import sic2intel.structure.intel.IntelInstrFLD;
import sic2intel.structure.intel.IntelInstrFMUL;
import sic2intel.structure.intel.IntelInstrFST;
import sic2intel.structure.intel.IntelInstrFSUB;
import sic2intel.structure.intel.IntelInstrIMUL;
import sic2intel.structure.intel.IntelInstrINT;
import sic2intel.structure.intel.IntelInstrJcc;
import sic2intel.structure.intel.IntelInstrMOV;
import sic2intel.structure.intel.IntelInstrOR;
import sic2intel.structure.intel.IntelInstrPOP;
import sic2intel.structure.intel.IntelInstrPROC;
import sic2intel.structure.intel.IntelInstrPUSH;
import sic2intel.structure.intel.IntelInstrREAD;
import sic2intel.structure.intel.IntelInstrRET;
import sic2intel.structure.intel.IntelInstrSHx;
import sic2intel.structure.intel.IntelInstrSUB;
import sic2intel.structure.intel.IntelInstrWRITE;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicInstrADD;
import sic2intel.structure.sic.SicInstrADDF;
import sic2intel.structure.sic.SicInstrADDR;
import sic2intel.structure.sic.SicInstrAND;
import sic2intel.structure.sic.SicInstrBYTE;
import sic2intel.structure.sic.SicInstrCLEAR;
import sic2intel.structure.sic.SicInstrCOMP;
import sic2intel.structure.sic.SicInstrCOMPF;
import sic2intel.structure.sic.SicInstrCOMPR;
import sic2intel.structure.sic.SicInstrDIV;
import sic2intel.structure.sic.SicInstrDIVF;
import sic2intel.structure.sic.SicInstrDIVR;
import sic2intel.structure.sic.SicInstrEND;
import sic2intel.structure.sic.SicInstrEQU;
import sic2intel.structure.sic.SicInstrEQU_BinExpr;
import sic2intel.structure.sic.SicInstrEQU_UnExpr;
import sic2intel.structure.sic.SicInstrFIX;
import sic2intel.structure.sic.SicInstrFLOAT;
import sic2intel.structure.sic.SicInstrHIO;
import sic2intel.structure.sic.SicInstrJ;
import sic2intel.structure.sic.SicInstrJEQ;
import sic2intel.structure.sic.SicInstrJGT;
import sic2intel.structure.sic.SicInstrJLT;
import sic2intel.structure.sic.SicInstrJSUB;
import sic2intel.structure.sic.SicInstrLDA;
import sic2intel.structure.sic.SicInstrLDB;
import sic2intel.structure.sic.SicInstrLDCH;
import sic2intel.structure.sic.SicInstrLDF;
import sic2intel.structure.sic.SicInstrLDL;
import sic2intel.structure.sic.SicInstrLDS;
import sic2intel.structure.sic.SicInstrLDT;
import sic2intel.structure.sic.SicInstrLDX;
import sic2intel.structure.sic.SicInstrLPS;
import sic2intel.structure.sic.SicInstrMUL;
import sic2intel.structure.sic.SicInstrMULF;
import sic2intel.structure.sic.SicInstrMULR;
import sic2intel.structure.sic.SicInstrNORM;
import sic2intel.structure.sic.SicInstrOR;
import sic2intel.structure.sic.SicInstrRD;
import sic2intel.structure.sic.SicInstrREAD;
import sic2intel.structure.sic.SicInstrRESB;
import sic2intel.structure.sic.SicInstrRESW;
import sic2intel.structure.sic.SicInstrRMO;
import sic2intel.structure.sic.SicInstrRSUB;
import sic2intel.structure.sic.SicInstrSHIFTL;
import sic2intel.structure.sic.SicInstrSHIFTR;
import sic2intel.structure.sic.SicInstrSIO;
import sic2intel.structure.sic.SicInstrSSK;
import sic2intel.structure.sic.SicInstrSTA;
import sic2intel.structure.sic.SicInstrSTART;
import sic2intel.structure.sic.SicInstrSTB;
import sic2intel.structure.sic.SicInstrSTCH;
import sic2intel.structure.sic.SicInstrSTF;
import sic2intel.structure.sic.SicInstrSTI;
import sic2intel.structure.sic.SicInstrSTL;
import sic2intel.structure.sic.SicInstrSTS;
import sic2intel.structure.sic.SicInstrSTSW;
import sic2intel.structure.sic.SicInstrSTT;
import sic2intel.structure.sic.SicInstrSTX;
import sic2intel.structure.sic.SicInstrSUB;
import sic2intel.structure.sic.SicInstrSUBF;
import sic2intel.structure.sic.SicInstrSUBR;
import sic2intel.structure.sic.SicInstrSVC;
import sic2intel.structure.sic.SicInstrTD;
import sic2intel.structure.sic.SicInstrTIO;
import sic2intel.structure.sic.SicInstrTIX;
import sic2intel.structure.sic.SicInstrTIXR;
import sic2intel.structure.sic.SicInstrVisitor;
import sic2intel.structure.sic.SicInstrWD;
import sic2intel.structure.sic.SicInstrWORD;
import sic2intel.structure.sic.SicInstrWRITE;

public class CodeGenerator
implements SicInstrVisitor {
    public static LinkedList<IntelInstr> endMainBlock;
    public static LinkedList<IntelInstr> endDataBlock;
    public static LinkedList<IntelInstrPROC> endProcBlock;
    public static HashMap<String, Integer> dataTypes;
    public static HashMap<String, String> dataValues;
    public static HashMap<String, String> fDescriptors;
    public static HashSet<String> equSet;
    public static String startLabel;

    public CodeGenerator() {
        endMainBlock = new LinkedList();
        endDataBlock = new LinkedList();
        endProcBlock = new LinkedList();
        dataTypes = DataInspector.dataTypes;
        dataValues = DataInspector.dataValues;
        equSet = DataInspector.equSet;
        fDescriptors = new HashMap();
    }

    @Override
    public void visit(SicInstrSTART acceptor) {
    }

    @Override
    public void visit(SicInstrEND acceptor) {
        startLabel = acceptor.identifier;
        endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)0, (Integer)1, "0x1", false, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)1, "0x0", false, null));
        endMainBlock.add(new IntelInstrINT(null, "0x80", null));
    }

    @Override
    public void visit(SicInstrADD acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrADD(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrADD(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrADDF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFADD(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFADD(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrADDR acceptor) {
        endMainBlock.add(new IntelInstrADD(acceptor.label, (Integer)-1, acceptor.register2, (Integer)-1, acceptor.register1, false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrAND acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrAND(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrAND(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrCLEAR acceptor) {
        endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, acceptor.register, (Integer)1, "0", false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrCOMP acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrCMP(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrCMP(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrCOMPF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFCOM(null, (Integer)0, 9, false, null));
        } else if (acceptor.addressing == 1) {
            IntelInstrDATA temp = new IntelInstrDATA(4, acceptor.identifier);
            dataTypes.put(temp.getLabel(), 4);
            endDataBlock.addFirst(temp);
            endMainBlock.add(new IntelInstrFCOM(null, (Integer)0, temp.label, false, (SicInstr)acceptor));
        } else {
            endMainBlock.add(new IntelInstrFCOM(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrCOMPR acceptor) {
        endMainBlock.add(new IntelInstrCMP(acceptor.label, (Integer)-1, acceptor.register1, (Integer)-1, acceptor.register2, false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrDIV acceptor) {
        endMainBlock.add(new IntelInstrPUSH(acceptor.label, 6, (SicInstr)acceptor));
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, null));
            endMainBlock.add(new IntelInstrDIV(null, (Integer)0, 9, false, null));
        } else if (acceptor.addressing == 1) {
            IntelInstrDATA temp = new IntelInstrDATA(1, acceptor.identifier);
            dataTypes.put(temp.getLabel(), 3);
            endDataBlock.addFirst(temp);
            endMainBlock.add(new IntelInstrDIV(acceptor.label, (Integer)0, temp.label, false, (SicInstr)acceptor));
        } else {
            endMainBlock.add(new IntelInstrDIV(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
        endMainBlock.add(new IntelInstrPOP(acceptor.label, 6, null));
    }

    @Override
    public void visit(SicInstrDIVF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFDIV(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFDIV(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrDIVR acceptor) {
        endMainBlock.add(new IntelInstrPUSH(acceptor.label, 6, (SicInstr)acceptor));
        if (acceptor.register2 != 0) {
            endMainBlock.add(new IntelInstrPUSH(acceptor.label, 0, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)-1, acceptor.register2, false, null));
        }
        endMainBlock.add(new IntelInstrDIV(null, (Integer)-1, acceptor.register1, false, null));
        if (acceptor.register2 != 0) {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, acceptor.register2, (Integer)-1, (Integer)0, false, null));
            endMainBlock.add(new IntelInstrPOP(null, 0, null));
        }
        endMainBlock.add(new IntelInstrPOP(acceptor.label, 6, null));
    }

    @Override
    public void visit(SicInstrFIX acceptor) {
        IntelInstrDATA temp = new IntelInstrDATA(3, "1");
        dataTypes.put(temp.getLabel(), 3);
        endDataBlock.addFirst(temp);
        endMainBlock.add(new IntelInstrFIST(acceptor.label, 0, temp.getLabel(), false, acceptor));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)0, temp.getLabel(), false, null));
    }

    @Override
    public void visit(SicInstrFLOAT acceptor) {
        IntelInstrDATA temp = new IntelInstrDATA(3, "1");
        dataTypes.put(temp.getLabel(), 3);
        endDataBlock.addFirst(temp);
        endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)0, temp.getLabel(), (Integer)-1, (Integer)0, false, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrFILD(null, 0, temp.getLabel(), false, null));
    }

    @Override
    public void visit(SicInstrHIO acceptor) {
        Logger.error("SIC instruction \"HIO\" not supported.");
    }

    @Override
    public void visit(SicInstrJ acceptor) {
        if (acceptor.label.equals(acceptor.identifier)) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)0, (Integer)1, "0x1", false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)1, "0x0", false, null));
            endMainBlock.add(new IntelInstrINT(null, "0x80", null));
        } else {
            endMainBlock.add(new IntelInstrJcc(acceptor.label, 1, acceptor.identifier, acceptor));
        }
    }

    @Override
    public void visit(SicInstrJEQ acceptor) {
        endMainBlock.add(new IntelInstrJcc(acceptor.label, 2, acceptor.identifier, acceptor));
    }

    @Override
    public void visit(SicInstrJGT acceptor) {
        endMainBlock.add(new IntelInstrJcc(acceptor.label, 3, acceptor.identifier, acceptor));
    }

    @Override
    public void visit(SicInstrJLT acceptor) {
        endMainBlock.add(new IntelInstrJcc(acceptor.label, 4, acceptor.identifier, acceptor));
    }

    @Override
    public void visit(SicInstrJSUB acceptor) {
        endMainBlock.add(new IntelInstrCALL(acceptor.label, acceptor.identifier, acceptor));
    }

    @Override
    public void visit(SicInstrLDA acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDB acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)1, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDCH acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)0, (Integer)9, true, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, true, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFLD(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFLD(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDL acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)3, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)3, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDS acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)4, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDT acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)6, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLDX acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)7, (Integer)0, (Integer)9, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)7, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrLPS acceptor) {
        Logger.error("Instruction \"LPS\" not supported.");
    }

    @Override
    public void visit(SicInstrMUL acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrIMUL(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrIMUL(null, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrMULF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFMUL(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFMUL(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrMULR acceptor) {
        endMainBlock.add(new IntelInstrIMUL(acceptor.label, (Integer)-1, acceptor.register2, (Integer)-1, acceptor.register1, false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrNORM acceptor) {
        Logger.error("Instruction \"NORM\" not supported.");
    }

    @Override
    public void visit(SicInstrOR acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrOR(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrOR(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrRD acceptor) {
        IntelInstrDATA temp1 = new IntelInstrDATA(3, "1");
        dataTypes.put(temp1.getLabel(), 3);
        endDataBlock.addFirst(temp1);
        String deviceNum = acceptor.identifier;
        while (dataValues.containsKey(deviceNum)) {
            deviceNum = dataValues.get(deviceNum);
        }
        if (deviceNum.charAt(0) == 'X') {
            deviceNum = deviceNum.substring(2, deviceNum.length() - 1);
        }
        endMainBlock.add(new IntelInstrPUSH(acceptor.label, 0, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrPUSH(null, 1, null));
        endMainBlock.add(new IntelInstrPUSH(null, 4, null));
        endMainBlock.add(new IntelInstrPUSH(null, 6, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)1, "0x3", false, null));
        if (deviceNum.equals("0") || deviceNum.equals("1") || deviceNum.equals("2")) {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)0, deviceNum, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)0, fDescriptors.get(deviceNum), false, null));
        }
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, temp1.label, false, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)1, "0x1", false, null));
        endMainBlock.add(new IntelInstrINT(null, "0x80", null));
        endMainBlock.add(new IntelInstrPOP(null, 6, null));
        endMainBlock.add(new IntelInstrPOP(null, 4, null));
        endMainBlock.add(new IntelInstrPOP(null, 1, null));
        endMainBlock.add(new IntelInstrPOP(null, 0, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)0, temp1.label, false, null));
    }

    @Override
    public void visit(SicInstrRMO acceptor) {
        endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, acceptor.register2, (Integer)-1, acceptor.register1, false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrRSUB acceptor) {
        endMainBlock.add(new IntelInstrRET(acceptor.label, null, acceptor));
    }

    @Override
    public void visit(SicInstrSHIFTL acceptor) {
        endMainBlock.add(new IntelInstrSHx(acceptor.label, 0, -1, acceptor.register, 1, acceptor.number, acceptor));
    }

    @Override
    public void visit(SicInstrSHIFTR acceptor) {
        endMainBlock.add(new IntelInstrSHx(acceptor.label, 1, -1, acceptor.register, 1, acceptor.number, acceptor));
    }

    @Override
    public void visit(SicInstrSIO acceptor) {
        Logger.error("Instruction \"SIO\" not supported.");
    }

    @Override
    public void visit(SicInstrSSK acceptor) {
        Logger.error("Instruction \"SSK\" not supported.");
    }

    @Override
    public void visit(SicInstrSTA acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)0, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)0, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTB acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)1, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)1, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTCH acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)0, true, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)0, true, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFST(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFST(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTI acceptor) {
        Logger.error("Instruction \"STI\" not supported.");
    }

    @Override
    public void visit(SicInstrSTL acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)3, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)3, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTS acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)4, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)4, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTSW acceptor) {
        Logger.error("Instruction \"STSW\" not supported.");
    }

    @Override
    public void visit(SicInstrSTT acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)6, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)6, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSTX acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, (Integer)9, (Integer)-1, (Integer)7, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, acceptor.addressing, acceptor.identifier, (Integer)-1, (Integer)7, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSUB acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrSUB(null, (Integer)-1, (Integer)0, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrSUB(acceptor.label, (Integer)-1, (Integer)0, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSUBF acceptor) {
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrFSUB(null, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrFSUB(acceptor.label, acceptor.addressing, acceptor.identifier, acceptor.indexed, (SicInstr)acceptor));
        }
    }

    @Override
    public void visit(SicInstrSUBR acceptor) {
        endMainBlock.add(new IntelInstrSUB(acceptor.label, (Integer)-1, acceptor.register2, (Integer)-1, acceptor.register1, false, (SicInstr)acceptor));
    }

    @Override
    public void visit(SicInstrSVC acceptor) {
        Logger.error("Instruction \"SVC\" not supported.");
    }

    @Override
    public void visit(SicInstrTD acceptor) {
        String deviceNum = acceptor.identifier;
        while (dataValues.containsKey(deviceNum)) {
            deviceNum = dataValues.get(deviceNum);
        }
        if (deviceNum.charAt(0) == 'X') {
            deviceNum = deviceNum.substring(2, deviceNum.length() - 1);
        }
        if (!(deviceNum.equals("0") || deviceNum.equals("1") || deviceNum.equals("2"))) {
            IntelInstrDATA temp1 = new IntelInstrDATA(3, "1");
            dataTypes.put(temp1.getLabel(), 3);
            endDataBlock.addFirst(temp1);
            IntelInstrDATA temp2 = new IntelInstrDATA(5, String.valueOf(deviceNum) + ".txt");
            dataTypes.put(temp2.getLabel(), 5);
            endDataBlock.addFirst(temp2);
            endMainBlock.add(new IntelInstrPUSH(acceptor.label, 0, (SicInstr)acceptor));
            endMainBlock.add(new IntelInstrPUSH(null, 1, null));
            endMainBlock.add(new IntelInstrPUSH(null, 4, null));
            endMainBlock.add(new IntelInstrPUSH(null, 6, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)1, "0x5", false, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)1, temp2.getLabel(), false, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, "0x66", false, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)1, "0x1B6", false, null));
            endMainBlock.add(new IntelInstrINT(null, "0x80", null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)0, temp1.getLabel(), (Integer)-1, (Integer)0, false, null));
            endMainBlock.add(new IntelInstrCMP(null, (Integer)-1, (Integer)0, (Integer)1, "-1", false, null));
            fDescriptors.put(deviceNum, temp1.getLabel());
            endMainBlock.add(new IntelInstrPOP(null, 6, null));
            endMainBlock.add(new IntelInstrPOP(null, 4, null));
            endMainBlock.add(new IntelInstrPOP(null, 1, null));
            endMainBlock.add(new IntelInstrPOP(null, 0, null));
        }
    }

    @Override
    public void visit(SicInstrTIO acceptor) {
        Logger.error("Instruction \"TIO\" not supported.");
    }

    @Override
    public void visit(SicInstrTIX acceptor) {
        endMainBlock.add(new IntelInstrADD(acceptor.label, (Integer)-1, (Integer)7, (Integer)1, "1", false, (SicInstr)acceptor));
        if (acceptor.addressing == 2) {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)9, (Integer)0, acceptor.identifier, false, null));
            endMainBlock.add(new IntelInstrCMP(null, (Integer)-1, (Integer)7, (Integer)0, 9, false, null));
        } else {
            endMainBlock.add(new IntelInstrCMP(null, (Integer)-1, (Integer)7, acceptor.addressing, acceptor.identifier, acceptor.indexed, null));
        }
    }

    @Override
    public void visit(SicInstrTIXR acceptor) {
        endMainBlock.add(new IntelInstrADD(acceptor.label, (Integer)-1, (Integer)7, (Integer)1, "1", false, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrCMP(null, (Integer)-1, (Integer)7, (Integer)-1, acceptor.register, false, null));
    }

    @Override
    public void visit(SicInstrWD acceptor) {
        IntelInstrDATA temp1 = new IntelInstrDATA(3, "1");
        dataTypes.put(temp1.getLabel(), 3);
        endDataBlock.addFirst(temp1);
        String deviceNum = acceptor.identifier;
        while (dataValues.containsKey(deviceNum)) {
            deviceNum = dataValues.get(deviceNum);
        }
        if (deviceNum.startsWith("X'") && deviceNum.endsWith("'")) {
            deviceNum = deviceNum.substring(2, deviceNum.length() - 1);
        }
        endMainBlock.add(new IntelInstrMOV(acceptor.label, (Integer)0, temp1.label, (Integer)-1, (Integer)0, false, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrPUSH(null, 0, null));
        endMainBlock.add(new IntelInstrPUSH(null, 1, null));
        endMainBlock.add(new IntelInstrPUSH(null, 4, null));
        endMainBlock.add(new IntelInstrPUSH(null, 6, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)0, (Integer)1, "0x4", false, null));
        if (deviceNum.equals("0") || deviceNum.equals("1") || deviceNum.equals("2")) {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)0, deviceNum, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)1, (Integer)0, fDescriptors.get(deviceNum), false, null));
        }
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, temp1.label, false, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)1, "0x1", false, null));
        endMainBlock.add(new IntelInstrINT(null, "0x80", null));
        endMainBlock.add(new IntelInstrPOP(null, 6, null));
        endMainBlock.add(new IntelInstrPOP(null, 4, null));
        endMainBlock.add(new IntelInstrPOP(null, 1, null));
        endMainBlock.add(new IntelInstrPOP(null, 0, null));
    }

    @Override
    public void visit(SicInstrRESB acceptor) {
        endDataBlock.add(new IntelInstrDATA(acceptor.label, 2, acceptor.value, acceptor));
    }

    @Override
    public void visit(SicInstrRESW acceptor) {
        endDataBlock.add(new IntelInstrDATA(acceptor.label, 3, acceptor.value, acceptor));
    }

    @Override
    public void visit(SicInstrBYTE acceptor) {
        endDataBlock.add(new IntelInstrDATA(acceptor.label, 0, acceptor.value, acceptor));
    }

    @Override
    public void visit(SicInstrWORD acceptor) {
        endDataBlock.add(new IntelInstrDATA(acceptor.label, 1, acceptor.value, acceptor));
    }

    @Override
    public void visit(SicInstrEQU acceptor) {
        endDataBlock.add(new IntelInstrEQU(acceptor.label, acceptor.expr, acceptor));
    }

    @Override
    public void visit(SicInstrWRITE acceptor) {
        String procLabel;
        IntelInstrWRITE writeProc = null;
        for (IntelInstrPROC proc : endProcBlock) {
            if (!(proc instanceof IntelInstrWRITE)) continue;
            writeProc = (IntelInstrWRITE)proc;
            break;
        }
        if (writeProc == null) {
            procLabel = IntelInstrPROC.genLabel();
            endProcBlock.add(new IntelInstrWRITE(procLabel));
        } else {
            procLabel = writeProc.label;
        }
        endMainBlock.add(new IntelInstrPUSH(acceptor.label, 4, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrPUSH(null, 6, null));
        if (acceptor.length == null) {
            IntelInstrDATA temp1 = new IntelInstrDATA(5, acceptor.identifier);
            dataTypes.put(temp1.getLabel(), 5);
            endDataBlock.add(temp1);
            IntelInstrEQU temp2 = new IntelInstrEQU(new SicInstrEQU_BinExpr(1, new SicInstrEQU_UnExpr(0), new SicInstrEQU_UnExpr(2, temp1.label)));
            equSet.add(temp2.label);
            endDataBlock.add(temp2);
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, temp1.label, false, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)0, temp2.label, false, null));
        } else {
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, acceptor.identifier, false, null));
            endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)1, acceptor.length, false, null));
        }
        endMainBlock.add(new IntelInstrCALL(null, procLabel, null));
        endMainBlock.add(new IntelInstrPOP(null, 6, null));
        endMainBlock.add(new IntelInstrPOP(null, 4, null));
    }

    @Override
    public void visit(SicInstrREAD acceptor) {
        String procLabel;
        IntelInstrREAD readProc = null;
        for (IntelInstrPROC proc : endProcBlock) {
            if (!(proc instanceof IntelInstrREAD)) continue;
            readProc = (IntelInstrREAD)proc;
            break;
        }
        if (readProc == null) {
            procLabel = IntelInstrPROC.genLabel();
            endProcBlock.add(new IntelInstrREAD(procLabel));
        } else {
            procLabel = readProc.label;
        }
        endMainBlock.add(new IntelInstrPUSH(acceptor.label, 4, (SicInstr)acceptor));
        endMainBlock.add(new IntelInstrPUSH(null, 6, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)4, (Integer)1, acceptor.identifier, false, null));
        endMainBlock.add(new IntelInstrMOV(null, (Integer)-1, (Integer)6, (Integer)1, acceptor.length, false, null));
        endMainBlock.add(new IntelInstrCALL(null, procLabel, null));
        endMainBlock.add(new IntelInstrPOP(null, 6, null));
        endMainBlock.add(new IntelInstrPOP(null, 4, null));
    }
}

