/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import sic2intel.lexer.SicLexer;
import sic2intel.logger.Logger;
import sic2intel.parser.SicSyntax;
import sic2intel.structure.CodeGenerator;
import sic2intel.structure.DataInspector;
import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelInstrPROC;
import sic2intel.structure.sic.SicProgram;

public class Main {
    public static void showConsole() {
        int status = Main.execute();
        if (status != 0) {
            System.out.println("An error occured during the translation process.\nSee \"" + sic2intel.Main.logFileName + "\" for more information.");
        } else {
            System.out.println("The translation process was sucessful.\nSee \"" + sic2intel.Main.dstFileName + "\" for end result.");
        }
        Logger.close();
        System.exit(status);
    }

    public static int execute() {
        FileReader reader = null;
        try {
            reader = new FileReader(sic2intel.Main.srcFile);
        }
        catch (FileNotFoundException e) {
            return Logger.error("Unable to open source file '" + sic2intel.Main.srcFileName + "'.", e);
        }
        SicLexer lexer = new SicLexer(reader);
        SicSyntax parser = new SicSyntax(lexer);
        SicProgram program = null;
        try {
            program = (SicProgram)parser.parse().value;
        }
        catch (Exception e) {
            return Logger.error("Error while testing the construction of syntax tree.", e);
        }
        DataInspector inspector = new DataInspector();
        program.accept(inspector);
        CodeGenerator generator = new CodeGenerator();
        program.accept(generator);
        FileWriter writer = null;
        try {
            writer = new FileWriter(String.valueOf(sic2intel.Main.dstFilePath) + sic2intel.Main.dstFileName);
        }
        catch (IOException e) {
            return Logger.error("Unable to open/create output file '" + sic2intel.Main.dstFileName + "'.", e);
        }
        try {
            writer.write("# How to run:\n");
            writer.write("#\tas -o " + sic2intel.Main.srcFileName.substring(0, sic2intel.Main.srcFileName.lastIndexOf(46)) + "_out.o " + sic2intel.Main.dstFileName + "\n");
            writer.write("#\tld -o " + sic2intel.Main.srcFileName.substring(0, sic2intel.Main.srcFileName.lastIndexOf(46)) + "_out " + sic2intel.Main.srcFileName.substring(0, sic2intel.Main.srcFileName.lastIndexOf(46)) + "_out.o" + "\n");
            writer.write("#\t./" + sic2intel.Main.srcFileName.substring(0, sic2intel.Main.srcFileName.lastIndexOf(46)) + "\n\n");
            writer.write(".intel_syntax\n");
            boolean first = true;
            for (IntelInstr instr : CodeGenerator.endDataBlock) {
                if (first) {
                    writer.write(".data\n");
                    first = false;
                }
                writer.write(instr.toString());
            }
            writer.write("\n.text\n");
            writer.write(String.valueOf(String.format("%1$-16s%2$-16s", ".global", "_start")) + "\n");
            if (CodeGenerator.startLabel == null) {
                writer.write("_start:\n");
            }
            for (IntelInstr instr : CodeGenerator.endMainBlock) {
                if (CodeGenerator.startLabel != null && instr.label != null && instr.label.equals(CodeGenerator.startLabel)) {
                    writer.write("_start:\n");
                }
                writer.write(instr.toString());
            }
            for (IntelInstrPROC proc : CodeGenerator.endProcBlock) {
                writer.write("\n" + proc.listToString() + "\n");
            }
        }
        catch (IOException e) {
            return Logger.error("A problem occured while writing to output file '" + sic2intel.Main.dstFileName + "'.", e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            return Logger.error("Unable to close source file '" + sic2intel.Main.srcFileName + "'.", e);
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            return Logger.error("Unable to close output file '" + sic2intel.Main.dstFileName + "'.", e);
        }
        return 0;
    }
}

