/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.Main;
import sic2intel.structure.CodeGenerator;
import sic2intel.structure.sic.SicInstr;

public class IntelInstr {
    public String label;

    public String toString(String l, String i, String op, SicInstr src) {
        if (Main.debugOuput) {
            if (src != null) {
                return String.format("%4$s%1$-16s%2$-8s%3$s\n", l, i, op, src.toString());
            }
            return String.format("%1$-16s%2$-8s%3$s\n", l, i, op);
        }
        return String.format("%1$-16s%2$-8s%3$s\n", l, i, op);
    }

    public String setAddressing(Integer addrType, String op) {
        switch (addrType) {
            case -1: {
                return op;
            }
            case 0: {
                if (CodeGenerator.equSet.contains(op)) {
                    return op;
                }
                return "[" + op + "]";
            }
            case 1: {
                try {
                    Integer.decode(op);
                    return op;
                }
                catch (Exception _) {
                    return "offset " + op;
                }
            }
            case 2: {
                return "not implemented";
            }
        }
        return "not supported ";
    }

    public String setAddressing(Integer addrType, Integer op) {
        return this.setAddressing(addrType, op.toString());
    }

    public String setPtrSize(Integer type) {
        switch (type) {
            case 0: {
                return "byte ";
            }
            case 1: {
                return "dword ";
            }
            case 4: {
                return "qword ";
            }
        }
        return "not supported ";
    }
}

