/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelRegisters;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicRegisters;

public class IntelInstrCMP
extends IntelInstr {
    private Integer dstAddrType;
    private Integer dstReg;
    private Integer srcAddrType;
    private String src;
    private Integer srcReg;
    private boolean indexed;
    private SicInstr srcInstr;

    public IntelInstrCMP(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, String src, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrCMP(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, Integer srcReg, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public String toString() {
        String l = this.label != null ? String.valueOf(this.label) + ":" : "";
        String i = "cmp";
        String op = "";
        if (this.srcReg != null) {
            op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1));
        } else {
            op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", ";
            op = this.indexed ? String.valueOf(op) + "[" + this.src + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" : String.valueOf(op) + this.setAddressing(this.srcAddrType, this.src);
        }
        return super.toString(l, i, op, this.srcInstr);
    }
}

