/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.sic.SicInstr;

public class IntelInstrDATA
extends IntelInstr {
    private Integer type;
    private String value;
    private static int counter;
    private SicInstr srcInstr;

    public IntelInstrDATA(String label, Integer type, String value, SicInstr srcInstr) {
        this.label = label;
        this.type = type;
        this.value = value;
        this.srcInstr = srcInstr;
    }

    public IntelInstrDATA(Integer type, String value) {
        this.label = "_t" + counter;
        this.type = type;
        this.value = value;
        ++counter;
    }

    public static String genLabel() {
        return "_t" + (++counter - 1);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public static Integer getCounter() {
        return counter;
    }

    public String toString() {
        String l = this.label != null ? String.valueOf(this.label) + ":" : "";
        String t = "";
        String v = "";
        if (this.type == 0 || this.type == 1) {
            if (this.value.charAt(0) == 'X') {
                v = "0x" + this.value.substring(1).replaceAll("'", "");
            } else if (this.value.charAt(0) == 'C') {
                int i = this.value.length() - 2;
                while (i >= 2) {
                    v = i == 2 ? String.valueOf(v) + "0x" + (byte)this.value.charAt(i) : String.valueOf(v) + "0x" + (byte)this.value.charAt(i) + ", ";
                    --i;
                }
            } else {
                v = this.value;
            }
        } else {
            v = this.value;
        }
        switch (this.type) {
            case 0: {
                t = ".byte";
                break;
            }
            case 1: {
                t = ".long";
                break;
            }
            case 2: {
                t = ".byte";
                break;
            }
            case 3: {
                t = ".space";
                v = "" + Integer.parseInt(this.value) * 4;
                break;
            }
            case 4: {
                t = ".double";
                break;
            }
            case 5: {
                t = ".string";
                v = "\"" + v + "\"";
                break;
            }
            default: {
                t = "";
            }
        }
        return super.toString(l, t, v, this.srcInstr);
    }
}

