/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.CodeGenerator;
import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelRegisters;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicRegisters;

public class IntelInstrDIV
extends IntelInstr {
    private Integer srcAddrType;
    private String src;
    private Integer srcReg;
    private boolean indexed;
    private SicInstr srcInstr;

    public IntelInstrDIV(String label, Integer srcAddrType, String src, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrDIV(String label, Integer srcAddrType, Integer srcReg, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public String toString() {
        String l = this.label != null ? String.valueOf(this.label) + ":" : "";
        String i = "idiv";
        String op = "";
        if (this.src != null) {
            Integer type = CodeGenerator.dataTypes.get(this.src);
            if (type == null || type == 1 || type == 3) {
                op = "dword ptr ";
                op = this.indexed ? String.valueOf(op) + "[" + this.src + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" : String.valueOf(op) + this.setAddressing(this.srcAddrType, this.src);
            } else if (type == 0 || type == 2) {
                op = "byte ptr ";
                op = this.indexed ? String.valueOf(op) + "[" + this.src + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" : String.valueOf(op) + this.setAddressing(this.srcAddrType, this.src);
            }
        } else {
            op = this.srcAddrType == 0 ? "dword ptr " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1)) : IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1);
        }
        return super.toString(l, i, op, this.srcInstr);
    }
}

