/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicInstrEQU_BinExpr;
import sic2intel.structure.sic.SicInstrEQU_Expr;
import sic2intel.structure.sic.SicInstrEQU_UnExpr;

public class IntelInstrEQU
extends IntelInstr {
    private SicInstrEQU_Expr expr;
    private SicInstr srcInstr;
    private static int counter;

    public IntelInstrEQU(String label, SicInstrEQU_Expr expr, SicInstr srcInstr) {
        this.label = label;
        this.expr = expr;
        this.srcInstr = srcInstr;
    }

    public IntelInstrEQU(SicInstrEQU_Expr expr) {
        this.label = "_e" + counter;
        this.expr = expr;
        ++counter;
    }

    public String toString() {
        return super.toString("", ".equ", String.valueOf(this.label) + ", " + this.produceString(this.expr), this.srcInstr);
    }

    public String produceString(SicInstrEQU_Expr expr) {
        if (expr instanceof SicInstrEQU_UnExpr) {
            return this.produceString((SicInstrEQU_UnExpr)expr);
        }
        return this.produceString((SicInstrEQU_BinExpr)expr);
    }

    public String produceString(SicInstrEQU_UnExpr expr) {
        switch (expr.expr) {
            case 0: {
                return "$";
            }
            case 1: 
            case 2: {
                return expr.numOrId;
            }
        }
        return "";
    }

    public String produceString(SicInstrEQU_BinExpr expr) {
        switch (expr.op) {
            case 0: {
                return String.valueOf(this.produceString(expr.expr1)) + "+" + this.produceString(expr.expr2);
            }
            case 1: {
                return String.valueOf(this.produceString(expr.expr1)) + "-" + this.produceString(expr.expr2);
            }
            case 2: {
                return String.valueOf(this.produceString(expr.expr1)) + "/" + this.produceString(expr.expr2);
            }
        }
        return "";
    }
}

