/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.CodeGenerator;
import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelRegisters;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicRegisters;

public class IntelInstrMOV
extends IntelInstr {
    private Integer dstAddrType;
    private String dst;
    private Integer dstReg;
    private Integer srcAddrType;
    private String src;
    private Integer srcReg;
    private boolean indexed;
    private boolean loadByte = false;
    private SicInstr srcInstr;

    public IntelInstrMOV(String label, Integer dstAddrType, String dst, Integer srcAddrType, String src, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dst = dst;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, Integer srcReg, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, String src, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, String dst, Integer srcAddrType, Integer srcReg, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dst = dst;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, String src, boolean loadByte, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.loadByte = true;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, String dst, Integer srcAddrType, Integer srcReg, boolean loadByte, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dst = dst;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.loadByte = true;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrMOV(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, Integer srcReg, boolean loadByte, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.loadByte = true;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public String toString() {
        String l = this.label != null ? String.valueOf(this.label) + ":" : "";
        String i = "mov";
        String op = "";
        if (this.dstReg != null && this.srcReg != null) {
            op = this.dstReg == 0 && this.loadByte ? String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 0))) + ", " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1)) : (this.srcReg == 0 && this.loadByte ? String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 0)) : String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1)));
        } else if (this.dstReg != null && this.src != null) {
            if (this.loadByte) {
                op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 0))) + ", ";
            } else {
                Integer type = CodeGenerator.dataTypes.get(this.src);
                if (type == null || type == 1 || type == 3 || type == 5) {
                    op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", ";
                } else if (type == 0 || type == 2) {
                    op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", ";
                }
            }
            op = this.indexed ? String.valueOf(op) + "[" + this.src + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" : String.valueOf(op) + this.setAddressing(this.srcAddrType, this.src);
        } else if (this.dst != null && this.srcReg != null) {
            op = this.indexed ? "[" + this.dst + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" + ", " : String.valueOf(this.setAddressing(this.dstAddrType, this.dst)) + ", ";
            if (this.loadByte) {
                op = String.valueOf(op) + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 0));
            } else {
                Integer type = CodeGenerator.dataTypes.get(this.dst);
                if (type == null || type == 1 || type == 3 || type == 5) {
                    op = String.valueOf(op) + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1));
                } else if (type == 0 || type == 2) {
                    op = String.valueOf(op) + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1));
                }
            }
        }
        return super.toString(l, i, op, this.srcInstr);
    }
}

