/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

import sic2intel.structure.CodeGenerator;
import sic2intel.structure.intel.IntelInstr;
import sic2intel.structure.intel.IntelRegisters;
import sic2intel.structure.sic.SicInstr;
import sic2intel.structure.sic.SicRegisters;

public class IntelInstrOR
extends IntelInstr {
    private Integer dstAddrType;
    private Integer dstReg;
    private Integer srcAddrType;
    private String src;
    private Integer srcReg;
    private boolean indexed;
    private SicInstr srcInstr;

    public IntelInstrOR(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, String src, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.src = src;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public IntelInstrOR(String label, Integer dstAddrType, Integer dstReg, Integer srcAddrType, Integer srcReg, boolean indexed, SicInstr srcInstr) {
        this.label = label;
        this.dstAddrType = dstAddrType;
        this.dstReg = dstReg;
        this.srcAddrType = srcAddrType;
        this.srcReg = srcReg;
        this.indexed = indexed;
        this.srcInstr = srcInstr;
    }

    public String toString() {
        String l = this.label != null ? String.valueOf(this.label) + ":" : "";
        String i = "or";
        String op = "";
        if (this.srcReg != null) {
            op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", " + this.setAddressing(this.srcAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.srcReg), 1));
        } else if (this.src != null) {
            Integer type = CodeGenerator.dataTypes.get(this.src);
            if (type == null || type == 1 || type == 3) {
                op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", ";
            } else if (type == 0 || type == 2) {
                op = String.valueOf(this.setAddressing(this.dstAddrType, IntelRegisters.getActualReg(SicRegisters.toIntel(this.dstReg), 1))) + ", ";
            }
            op = this.indexed ? String.valueOf(op) + "[" + this.src + " + " + IntelRegisters.getActualReg(SicRegisters.toIntel(7), 1) + "]" : String.valueOf(op) + this.setAddressing(this.srcAddrType, this.src);
        }
        return super.toString(l, i, op, this.srcInstr);
    }
}

