/*
 * Decompiled with CFR 0.152.
 */
package sic2intel.structure.intel;

public class IntelRegisters {
    public static final int REG_A = 0;
    public static final int REG_B = 1;
    public static final int REG_C = 2;
    public static final int REG_D = 3;
    public static final int REG_SI = 4;
    public static final int REG_DI = 5;
    public static final int REG_SP = 6;
    public static final int REG_BP = 7;
    public static final int REG_IP = 8;

    public static String getActualReg(int baseReg, int dataSize) {
        switch (baseReg) {
            case 0: {
                if (dataSize == 0) {
                    return "%al";
                }
                if (dataSize == 1) {
                    return "%eax";
                }
            }
            case 1: {
                if (dataSize == 0) {
                    return "%bl";
                }
                if (dataSize == 1) {
                    return "%ebx";
                }
            }
            case 2: {
                if (dataSize == 0) {
                    return "%cl";
                }
                if (dataSize == 1) {
                    return "%ecx";
                }
            }
            case 3: {
                if (dataSize == 0) {
                    return "%dl";
                }
                if (dataSize == 1) {
                    return "%edx";
                }
            }
            case 4: {
                return "%esi";
            }
            case 5: {
                return "%edi";
            }
            case 6: {
                return null;
            }
            case 7: {
                return "%ebp";
            }
            case 8: {
                return "%eip";
            }
        }
        return "null";
    }
}

